/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

public final class IdUtil {
    public static final int CONSTANT = 0;
    public static final int INSTANCE_VAR = 1;
    public static final int CLASS_VAR = 2;
    public static final int GLOBAL_VAR = 4;
    public static final int LOCAL_VAR = 8;

    public static int getVarType(String id) {
        char c = id.charAt(0);
        switch (c) {
            case '@': {
                return id.charAt(1) == '@' ? 2 : 1;
            }
            case '$': {
                return 4;
            }
        }
        return Character.isUpperCase(c) ? 0 : 8;
    }

    public static boolean isConstant(String id) {
        return Character.isUpperCase(id.charAt(0));
    }

    public static boolean isClassVariable(String id) {
        return id.charAt(0) == '@' && id.charAt(1) == '@';
    }

    public static boolean isInstanceVariable(String id) {
        return id.charAt(0) == '@' && id.charAt(1) != '@';
    }

    public static boolean isGlobal(String id) {
        return id.charAt(0) == '$';
    }

    public static boolean isLocal(String id) {
        return !IdUtil.isGlobal(id) && !IdUtil.isClassVariable(id) && !IdUtil.isInstanceVariable(id) && !IdUtil.isConstant(id);
    }

    public static boolean isAttrSet(String id) {
        return id.endsWith("=");
    }
}

