/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.jruby.main.ASTSerializer;

public class JRubySerialize
extends Task {
    private File destdir = null;
    private boolean verbose = false;
    private List fileSets = new ArrayList();
    private Mapper mapperElement = null;

    public void execute() throws BuildException {
        HashMap<File, File> fileMap = new HashMap<File, File>();
        FileNameMapper mapper = null;
        if (this.mapperElement != null) {
            mapper = this.mapperElement.getImplementation();
        } else {
            mapper = new GlobPatternMapper();
            mapper.setFrom("*.rb");
            mapper.setTo("*.rb.ast.ser");
        }
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        int size = this.fileSets.size();
        for (int i = 0; i < size; ++i) {
            FileSet fs = (FileSet)this.fileSets.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File dir = fs.getDir(this.getProject());
            String[] files = ds.getIncludedFiles();
            files = sfs.restrict(files, dir, this.destdir, mapper);
            for (int j = 0; j < files.length; ++j) {
                File src = new File(dir, files[j]);
                File dest = new File(this.destdir, mapper.mapFileName(files[j])[0]);
                fileMap.put(src, dest);
            }
        }
        if (fileMap.size() > 0) {
            this.log("Serializing " + fileMap.size() + " file" + (fileMap.size() == 1 ? "" : "s") + " to " + this.destdir.getAbsolutePath());
            Iterator iter = fileMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                try {
                    ((File)entry.getValue()).getParentFile().mkdirs();
                    if (this.verbose) {
                        System.out.println(entry.getKey());
                    }
                    ASTSerializer.serialize((File)entry.getKey(), (File)entry.getValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void addFileset(FileSet set) {
        this.fileSets.add(set);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }
}

