/*
 * Decompiled with CFR 0.152.
 */
package org.jvyaml;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jvyaml.Scanner;
import org.jvyaml.ScannerException;
import org.jvyaml.SimpleKey;
import org.jvyaml.YAMLException;
import org.jvyaml.tokens.AliasToken;
import org.jvyaml.tokens.AnchorToken;
import org.jvyaml.tokens.DirectiveToken;
import org.jvyaml.tokens.ScalarToken;
import org.jvyaml.tokens.TagToken;
import org.jvyaml.tokens.Token;

public class ScannerImpl
implements Scanner {
    private static final String LINEBR = "\n\u0085\u2028\u2029";
    private static final String NULL_BL_LINEBR = "\u0000 \r\n\u0085";
    private static final String NULL_BL_T_LINEBR = "\u0000 \t\r\n\u0085";
    private static final String NULL_OR_OTHER = "\u0000 \t\r\n\u0085";
    private static final String NULL_OR_LINEBR = "\u0000\r\n\u0085";
    private static final String FULL_LINEBR = "\r\n\u0085";
    private static final String BLANK_OR_LINEBR = " \r\n\u0085";
    private static final String S4 = "\u0000 \t\r\n\u0085[]{}";
    private static final String ALPHA = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_";
    private static final String STRANGE_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789][-';/?:@&=+$,.!~*()%";
    private static final String RN = "\r\n";
    private static final String BLANK_T = " \t";
    private static final String SPACES_AND_STUFF = "'\"\\\u0000 \t\r\n\u0085";
    private static final String DOUBLE_ESC = "\"\\";
    private static final String NON_ALPHA_OR_NUM = "\u0000 \t\r\n\u0085?:,]}%@`";
    private static final Pattern NON_PRINTABLE = Pattern.compile("[^\t\n\r -~\u0085\u00a0-\u00ff]");
    private static final Pattern NOT_HEXA = Pattern.compile("[^0-9A-Fa-f]");
    private static final Pattern NON_ALPHA = Pattern.compile("[^-0-9A-Za-z_]");
    private static final Pattern R_FLOWZERO = Pattern.compile("[\u0000 \t\r\n\u0085]|(:[\u0000 \t\r\n\u0085])");
    private static final Pattern R_FLOWNONZERO = Pattern.compile("[\u0000 \t\r\n\u0085\\[\\]{},:?]");
    private static final Pattern LINE_BR_REG = Pattern.compile("[\n\u0085]|(?:\r[^\n])");
    private static final Pattern END_OR_START = Pattern.compile("^(---|\\.\\.\\.)[\u0000 \t\r\n\u0085]$");
    private static final Pattern ENDING = Pattern.compile("^---[\u0000 \t\r\n\u0085]$");
    private static final Pattern START = Pattern.compile("^\\.\\.\\.[\u0000 \t\r\n\u0085]$");
    private static final Pattern BEG = Pattern.compile("^([^\u0000 \t\r\n\u0085\\-?:,\\[\\]{}#&*!|>'\"%@]|([\\-?:][^\u0000 \t\r\n\u0085]))");
    private static final Map ESCAPE_REPLACEMENTS = new HashMap();
    private static final Map ESCAPE_CODES = new HashMap();
    private boolean done = false;
    private int flowLevel = 0;
    private int tokensTaken = 0;
    private int indent = -1;
    private boolean allowSimpleKey = true;
    private boolean eof = true;
    private int column = 0;
    private int pointer = 0;
    private StringBuffer buffer;
    private Reader stream;
    private List tokens;
    private List indents;
    private Map possibleSimpleKeys;
    private boolean docStart = false;

    public ScannerImpl(Reader stream) {
        this.stream = stream;
        this.eof = false;
        this.buffer = new StringBuffer();
        this.tokens = new LinkedList();
        this.indents = new LinkedList();
        this.possibleSimpleKeys = new HashMap();
        this.fetchStreamStart();
    }

    public ScannerImpl(String stream) {
        this.buffer = new StringBuffer(stream);
        this.stream = null;
        this.tokens = new LinkedList();
        this.indents = new LinkedList();
        this.possibleSimpleKeys = new HashMap();
        this.fetchStreamStart();
    }

    public boolean checkToken(Class[] choices) {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            if (choices.length == 0) {
                return true;
            }
            Object first = this.tokens.get(0);
            int j = choices.length;
            for (int i = 0; i < j; ++i) {
                if (!choices[i].isInstance(first)) continue;
                return true;
            }
        }
        return false;
    }

    public Token peekToken() {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        return this.tokens.isEmpty() ? null : this.tokens.get(0);
    }

    public Token getToken() {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            ++this.tokensTaken;
            return (Token)this.tokens.remove(0);
        }
        return null;
    }

    public Iterator eachToken() {
        return new TokenIterator();
    }

    public Iterator iterator() {
        return this.eachToken();
    }

    private char peek() {
        if (this.pointer + 1 > this.buffer.length()) {
            this.update(1);
        }
        return this.buffer.charAt(this.pointer);
    }

    private char peek(int index) {
        if (this.pointer + index + 1 > this.buffer.length()) {
            this.update(index + 1);
        }
        return this.buffer.charAt(this.pointer + index);
    }

    private String prefix() {
        return this.prefix(1);
    }

    private String prefix(int length) {
        if (this.pointer + length >= this.buffer.length()) {
            this.update(length);
        }
        if (this.pointer + length > this.buffer.length()) {
            return this.buffer.substring(this.pointer, this.buffer.length());
        }
        return this.buffer.substring(this.pointer, this.pointer + length);
    }

    private String prefixForward(int length) {
        if (this.pointer + length + 1 >= this.buffer.length()) {
            this.update(length + 1);
        }
        String buff = null;
        buff = this.pointer + length > this.buffer.length() ? this.buffer.substring(this.pointer, this.buffer.length()) : this.buffer.substring(this.pointer, this.pointer + length);
        char ch = '\u0000';
        int j = buff.length();
        for (int i = 0; i < j; ++i) {
            ch = buff.charAt(i);
            ++this.pointer;
            if (LINEBR.indexOf(ch) != -1 || ch == '\r' && buff.charAt(i + 1) != '\n') {
                this.column = 0;
                continue;
            }
            if (ch == '\ufeff') continue;
            ++this.column;
        }
        return buff;
    }

    private void forward() {
        if (this.pointer + 2 >= this.buffer.length()) {
            this.update(2);
        }
        char ch1 = this.buffer.charAt(this.pointer);
        ++this.pointer;
        this.column = ch1 == '\n' || ch1 == '\u0085' || ch1 == '\r' && this.buffer.charAt(this.pointer) != '\n' ? 0 : ++this.column;
    }

    private void forward(int length) {
        if (this.pointer + length + 1 >= this.buffer.length()) {
            this.update(length + 1);
        }
        char ch = '\u0000';
        for (int i = 0; i < length; ++i) {
            ch = this.buffer.charAt(this.pointer);
            ++this.pointer;
            if (LINEBR.indexOf(ch) != -1 || ch == '\r' && this.buffer.charAt(this.pointer) != '\n') {
                this.column = 0;
                continue;
            }
            if (ch == '\ufeff') continue;
            ++this.column;
        }
    }

    private void checkPrintable(CharSequence data) {
        Matcher em = NON_PRINTABLE.matcher(data);
        if (em.find()) {
            int position = this.buffer.length() - this.pointer + em.start();
            throw new YAMLException("At " + position + " we found: " + em.group() + ". Special characters are not allowed");
        }
    }

    private void update(int length) {
        this.buffer.delete(0, this.pointer);
        this.pointer = 0;
        while (this.buffer.length() < length) {
            String rawData = "";
            if (!this.eof) {
                char[] data = new char[1024];
                int converted = -2;
                try {
                    converted = this.stream.read(data);
                }
                catch (IOException ioe) {
                    throw new YAMLException(ioe);
                }
                if (converted == -1) {
                    this.eof = true;
                } else {
                    rawData = String.valueOf(data, 0, converted);
                }
            }
            this.checkPrintable(rawData);
            this.buffer.append(rawData);
            if (!this.eof) continue;
            this.buffer.append('\u0000');
            break;
        }
    }

    private boolean needMoreTokens() {
        if (this.done) {
            return false;
        }
        return this.tokens.isEmpty() || this.nextPossibleSimpleKey() == this.tokensTaken;
    }

    private Token fetchMoreTokens() {
        this.scanToNextToken();
        this.unwindIndent(this.column);
        char ch = this.peek();
        boolean colz = this.column == 0;
        switch (ch) {
            case '\u0000': {
                return this.fetchStreamEnd();
            }
            case '\'': {
                return this.fetchSingle();
            }
            case '\"': {
                return this.fetchDouble();
            }
            case '?': {
                if (this.flowLevel == 0 && "\u0000 \t\r\n\u0085".indexOf(this.peek(1)) == -1) break;
                return this.fetchKey();
            }
            case ':': {
                if (this.flowLevel == 0 && "\u0000 \t\r\n\u0085".indexOf(this.peek(1)) == -1) break;
                return this.fetchValue();
            }
            case '%': {
                if (!colz) break;
                return this.fetchDirective();
            }
            case '-': {
                if ((colz || this.docStart) && ENDING.matcher(this.prefix(4)).matches()) {
                    return this.fetchDocumentStart();
                }
                if ("\u0000 \t\r\n\u0085".indexOf(this.peek(1)) == -1) break;
                return this.fetchBlockEntry();
            }
            case '.': {
                if (!colz || !START.matcher(this.prefix(4)).matches()) break;
                return this.fetchDocumentEnd();
            }
            case '[': {
                return this.fetchFlowSequenceStart();
            }
            case '{': {
                return this.fetchFlowMappingStart();
            }
            case ']': {
                return this.fetchFlowSequenceEnd();
            }
            case '}': {
                return this.fetchFlowMappingEnd();
            }
            case ',': {
                return this.fetchFlowEntry();
            }
            case '*': {
                return this.fetchAlias();
            }
            case '&': {
                return this.fetchAnchor();
            }
            case '!': {
                return this.fetchTag();
            }
            case '|': {
                if (this.flowLevel != 0) break;
                return this.fetchLiteral();
            }
            case '>': {
                if (this.flowLevel != 0) break;
                return this.fetchFolded();
            }
        }
        if (BEG.matcher(this.prefix(2)).find()) {
            return this.fetchPlain();
        }
        throw new ScannerException("while scanning for the next token", "found character " + ch + "(" + ch + " that cannot start any token", null);
    }

    private int nextPossibleSimpleKey() {
        Iterator iter = this.possibleSimpleKeys.values().iterator();
        while (iter.hasNext()) {
            SimpleKey key = (SimpleKey)iter.next();
            if (key.getTokenNumber() <= 0) continue;
            return key.getTokenNumber();
        }
        return -1;
    }

    private void savePossibleSimpleKey() {
        if (this.allowSimpleKey) {
            this.possibleSimpleKeys.put(new Integer(this.flowLevel), new SimpleKey(this.tokensTaken + this.tokens.size(), this.flowLevel == 0 && this.indent == this.column, -1, -1, this.column));
        }
    }

    private void unwindIndent(int col) {
        if (this.flowLevel != 0) {
            return;
        }
        while (this.indent > col) {
            this.indent = (Integer)this.indents.remove(0);
            this.tokens.add(Token.BLOCK_END);
        }
    }

    private boolean addIndent(int col) {
        if (this.indent < col) {
            this.indents.add(0, new Integer(this.indent));
            this.indent = col;
            return true;
        }
        return false;
    }

    private Token fetchStreamStart() {
        this.docStart = true;
        this.tokens.add(Token.STREAM_START);
        return Token.STREAM_START;
    }

    private Token fetchStreamEnd() {
        this.unwindIndent(-1);
        this.allowSimpleKey = false;
        this.possibleSimpleKeys = new HashMap();
        this.tokens.add(Token.STREAM_END);
        this.done = true;
        return Token.STREAM_END;
    }

    private Token fetchDirective() {
        this.unwindIndent(-1);
        this.allowSimpleKey = false;
        Token tok = this.scanDirective();
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchDocumentStart() {
        this.docStart = false;
        return this.fetchDocumentIndicator(Token.DOCUMENT_START);
    }

    private Token fetchDocumentEnd() {
        return this.fetchDocumentIndicator(Token.DOCUMENT_END);
    }

    private Token fetchDocumentIndicator(Token tok) {
        this.unwindIndent(-1);
        this.allowSimpleKey = false;
        this.forward(3);
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchFlowSequenceStart() {
        return this.fetchFlowCollectionStart(Token.FLOW_SEQUENCE_START);
    }

    private Token fetchFlowMappingStart() {
        return this.fetchFlowCollectionStart(Token.FLOW_MAPPING_START);
    }

    private Token fetchFlowCollectionStart(Token tok) {
        this.savePossibleSimpleKey();
        ++this.flowLevel;
        this.allowSimpleKey = true;
        this.forward(1);
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchFlowSequenceEnd() {
        return this.fetchFlowCollectionEnd(Token.FLOW_SEQUENCE_END);
    }

    private Token fetchFlowMappingEnd() {
        return this.fetchFlowCollectionEnd(Token.FLOW_MAPPING_END);
    }

    private Token fetchFlowCollectionEnd(Token tok) {
        --this.flowLevel;
        this.allowSimpleKey = false;
        this.forward(1);
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchFlowEntry() {
        this.allowSimpleKey = true;
        this.forward(1);
        this.tokens.add(Token.FLOW_ENTRY);
        return Token.FLOW_ENTRY;
    }

    private Token fetchBlockEntry() {
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                throw new ScannerException(null, "sequence entries are not allowed here", null);
            }
            if (this.addIndent(this.column)) {
                this.tokens.add(Token.BLOCK_SEQUENCE_START);
            }
        }
        this.allowSimpleKey = true;
        this.forward();
        this.tokens.add(Token.BLOCK_ENTRY);
        return Token.BLOCK_ENTRY;
    }

    private Token fetchKey() {
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                throw new ScannerException(null, "mapping keys are not allowed here", null);
            }
            if (this.addIndent(this.column)) {
                this.tokens.add(Token.BLOCK_MAPPING_START);
            }
        }
        this.allowSimpleKey = this.flowLevel == 0;
        this.forward();
        this.tokens.add(Token.KEY);
        return Token.KEY;
    }

    private Token fetchValue() {
        SimpleKey key = (SimpleKey)this.possibleSimpleKeys.get(new Integer(this.flowLevel));
        if (null == key) {
            if (this.flowLevel == 0 && !this.allowSimpleKey) {
                throw new ScannerException(null, "mapping values are not allowed here", null);
            }
        } else {
            this.possibleSimpleKeys.remove(new Integer(this.flowLevel));
            this.tokens.add(key.getTokenNumber() - this.tokensTaken, Token.KEY);
            if (this.flowLevel == 0 && this.addIndent(key.getColumn())) {
                this.tokens.add(key.getTokenNumber() - this.tokensTaken, Token.BLOCK_MAPPING_START);
            }
            this.allowSimpleKey = false;
        }
        this.forward();
        this.tokens.add(Token.VALUE);
        return Token.VALUE;
    }

    private Token fetchAlias() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanAnchor(new AliasToken());
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchAnchor() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanAnchor(new AnchorToken());
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchTag() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanTag();
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchLiteral() {
        return this.fetchBlockScalar('|');
    }

    private Token fetchFolded() {
        return this.fetchBlockScalar('>');
    }

    private Token fetchBlockScalar(char style) {
        this.allowSimpleKey = true;
        Token tok = this.scanBlockScalar(style);
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchSingle() {
        return this.fetchFlowScalar('\'');
    }

    private Token fetchDouble() {
        return this.fetchFlowScalar('\"');
    }

    private Token fetchFlowScalar(char style) {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanFlowScalar(style);
        this.tokens.add(tok);
        return tok;
    }

    private Token fetchPlain() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanPlain();
        this.tokens.add(tok);
        return tok;
    }

    private void scanToNextToken() {
        while (true) {
            if (this.peek() == ' ') {
                this.forward();
                continue;
            }
            if (this.peek() == '#') {
                while (NULL_OR_LINEBR.indexOf(this.peek()) == -1) {
                    this.forward();
                }
            }
            if (this.scanLineBreak().length() == 0) break;
            if (this.flowLevel != 0) continue;
            this.allowSimpleKey = true;
        }
    }

    private Token scanDirective() {
        this.forward();
        String name = this.scanDirectiveName();
        String[] value = null;
        if (name.equals("YAML")) {
            value = this.scanYamlDirectiveValue();
        } else if (name.equals("TAG")) {
            value = this.scanTagDirectiveValue();
        } else {
            while (NULL_OR_LINEBR.indexOf(this.peek()) == -1) {
                this.forward();
            }
        }
        this.scanDirectiveIgnoredLine();
        return new DirectiveToken(name, value);
    }

    private String scanDirectiveName() {
        int length = 0;
        char ch = this.peek(length);
        boolean zlen = true;
        while (ALPHA.indexOf(ch) != -1) {
            zlen = false;
            ch = this.peek(++length);
        }
        if (zlen) {
            throw new ScannerException("while scanning a directive", "expected alphabetic or numeric character, but found " + ch + "(" + ch + ")", null);
        }
        String value = this.prefixForward(length);
        if (NULL_BL_LINEBR.indexOf(this.peek()) == -1) {
            throw new ScannerException("while scanning a directive", "expected alphabetic or numeric character, but found " + ch + "(" + ch + ")", null);
        }
        return value;
    }

    private String[] scanYamlDirectiveValue() {
        while (this.peek() == ' ') {
            this.forward();
        }
        String major = this.scanYamlDirectiveNumber();
        if (this.peek() != '.') {
            throw new ScannerException("while scanning a directive", "expected a digit or '.', but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        this.forward();
        String minor = this.scanYamlDirectiveNumber();
        if (NULL_BL_LINEBR.indexOf(this.peek()) == -1) {
            throw new ScannerException("while scanning a directive", "expected a digit or ' ', but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return new String[]{major, minor};
    }

    private String scanYamlDirectiveNumber() {
        char ch = this.peek();
        if (!Character.isDigit(ch)) {
            throw new ScannerException("while scanning a directive", "expected a digit, but found " + ch + "(" + ch + ")", null);
        }
        int length = 0;
        while (Character.isDigit(this.peek(length))) {
            ++length;
        }
        String value = this.prefixForward(length);
        return value;
    }

    private String[] scanTagDirectiveValue() {
        while (this.peek() == ' ') {
            this.forward();
        }
        String handle = this.scanTagDirectiveHandle();
        while (this.peek() == ' ') {
            this.forward();
        }
        String prefix = this.scanTagDirectivePrefix();
        return new String[]{handle, prefix};
    }

    private String scanTagDirectiveHandle() {
        String value = this.scanTagHandle("directive");
        if (this.peek() != ' ') {
            throw new ScannerException("while scanning a directive", "expected ' ', but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return value;
    }

    private String scanTagDirectivePrefix() {
        String value = this.scanTagUri("directive");
        if (NULL_BL_LINEBR.indexOf(this.peek()) == -1) {
            throw new ScannerException("while scanning a directive", "expected ' ', but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return value;
    }

    private String scanDirectiveIgnoredLine() {
        char ch;
        while (this.peek() == ' ') {
            this.forward();
        }
        if (this.peek() == '\"') {
            while (NULL_OR_LINEBR.indexOf(this.peek()) == -1) {
                this.forward();
            }
        }
        if (NULL_OR_LINEBR.indexOf(ch = this.peek()) == -1) {
            throw new ScannerException("while scanning a directive", "expected a comment or a line break, but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return this.scanLineBreak();
    }

    private Token scanAnchor(Token tok) {
        String chunk;
        char indicator = this.peek();
        String name = indicator == '*' ? "alias" : "anchor";
        this.forward();
        int length = 0;
        int chunk_size = 16;
        Matcher m = null;
        while (!(m = NON_ALPHA.matcher(chunk = this.prefix(chunk_size))).find()) {
            chunk_size += 16;
        }
        length = m.start();
        if (length == 0) {
            throw new ScannerException("while scanning an " + name, "expected alphabetic or numeric character, but found something else...", null);
        }
        String value = this.prefixForward(length);
        if (NON_ALPHA_OR_NUM.indexOf(this.peek()) == -1) {
            throw new ScannerException("while scanning an " + name, "expected alphabetic or numeric character, but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        tok.setValue(value);
        return tok;
    }

    private Token scanTag() {
        char ch = this.peek(1);
        String handle = null;
        String suffix = null;
        if (ch == '<') {
            this.forward(2);
            suffix = this.scanTagUri("tag");
            if (this.peek() != '>') {
                throw new ScannerException("while scanning a tag", "expected '>', but found " + this.peek() + "(" + this.peek() + ")", null);
            }
            this.forward();
        } else if ("\u0000 \t\r\n\u0085".indexOf(ch) != -1) {
            suffix = "!";
            this.forward();
        } else {
            int length = 1;
            boolean useHandle = false;
            while ("\u0000 \t\r\n\u0085".indexOf(ch) == -1) {
                if (ch == '!') {
                    useHandle = true;
                    break;
                }
                ch = this.peek(++length);
            }
            handle = "!";
            if (useHandle) {
                handle = this.scanTagHandle("tag");
            } else {
                handle = "!";
                this.forward();
            }
            suffix = this.scanTagUri("tag");
        }
        if (NULL_BL_LINEBR.indexOf(this.peek()) == -1) {
            throw new ScannerException("while scanning a tag", "expected ' ', but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return new TagToken(new String[]{handle, suffix});
    }

    private Token scanBlockScalar(char style) {
        boolean folded = style == '>';
        StringBuffer chunks = new StringBuffer();
        this.forward();
        Object[] chompi = this.scanBlockScalarIndicators();
        boolean chomping = (Boolean)chompi[0];
        int increment = (Integer)chompi[1];
        this.scanBlockScalarIgnoredLine();
        int minIndent = this.indent + 1;
        if (minIndent < 1) {
            minIndent = 1;
        }
        String breaks = null;
        int maxIndent = 0;
        int ind = 0;
        if (increment == -1) {
            Object[] brme = this.scanBlockScalarIndentation();
            breaks = (String)brme[0];
            maxIndent = (Integer)brme[1];
            ind = minIndent > maxIndent ? minIndent : maxIndent;
        } else {
            ind = minIndent + increment - 1;
            breaks = this.scanBlockScalarBreaks(ind);
        }
        String lineBreak = "";
        while (this.column == ind && this.peek() != '\u0000') {
            chunks.append(breaks);
            boolean leadingNonSpace = BLANK_T.indexOf(this.peek()) == -1;
            int length = 0;
            while (NULL_OR_LINEBR.indexOf(this.peek(length)) == -1) {
                ++length;
            }
            chunks.append(this.prefixForward(length));
            lineBreak = this.scanLineBreak();
            breaks = this.scanBlockScalarBreaks(ind);
            if (this.column != ind || this.peek() == '\u0000') break;
            if (folded && lineBreak.equals("\n") && leadingNonSpace && BLANK_T.indexOf(this.peek()) == -1) {
                if (breaks.length() != 0) continue;
                chunks.append(" ");
                continue;
            }
            chunks.append(lineBreak);
        }
        if (chomping) {
            chunks.append(lineBreak);
            chunks.append(breaks);
        }
        return new ScalarToken(chunks.toString(), false, style);
    }

    private Object[] scanBlockScalarIndicators() {
        boolean chomping = false;
        int increment = -1;
        char ch = this.peek();
        if (ch == '-' || ch == '+') {
            chomping = ch == '+';
            this.forward();
            ch = this.peek();
            if (Character.isDigit(ch)) {
                increment = Integer.parseInt("" + ch);
                if (increment == 0) {
                    throw new ScannerException("while scanning a block scalar", "expected indentation indicator in the range 1-9, but found 0", null);
                }
                this.forward();
            }
        } else if (Character.isDigit(ch)) {
            increment = Integer.parseInt("" + ch);
            if (increment == 0) {
                throw new ScannerException("while scanning a block scalar", "expected indentation indicator in the range 1-9, but found 0", null);
            }
            this.forward();
            ch = this.peek();
            if (ch == '-' || ch == '+') {
                chomping = ch == '+';
                this.forward();
            }
        }
        if (NULL_BL_LINEBR.indexOf(this.peek()) == -1) {
            throw new ScannerException("while scanning a block scalar", "expected chomping or indentation indicators, but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return new Object[]{chomping, new Integer(increment)};
    }

    private String scanBlockScalarIgnoredLine() {
        while (this.peek() == ' ') {
            this.forward();
        }
        if (this.peek() == '#') {
            while (NULL_OR_LINEBR.indexOf(this.peek()) == -1) {
                this.forward();
            }
        }
        if (NULL_OR_LINEBR.indexOf(this.peek()) == -1) {
            throw new ScannerException("while scanning a block scalar", "expected a comment or a line break, but found " + this.peek() + "(" + this.peek() + ")", null);
        }
        return this.scanLineBreak();
    }

    private Object[] scanBlockScalarIndentation() {
        StringBuffer chunks = new StringBuffer();
        int maxIndent = 0;
        while (BLANK_OR_LINEBR.indexOf(this.peek()) != -1) {
            if (this.peek() != ' ') {
                chunks.append(this.scanLineBreak());
                continue;
            }
            this.forward();
            if (this.column <= maxIndent) continue;
            maxIndent = this.column;
        }
        return new Object[]{chunks.toString(), new Integer(maxIndent)};
    }

    private String scanBlockScalarBreaks(int indent) {
        StringBuffer chunks = new StringBuffer();
        while (this.column < indent && this.peek() == ' ') {
            this.forward();
        }
        while (FULL_LINEBR.indexOf(this.peek()) != -1) {
            chunks.append(this.scanLineBreak());
            while (this.column < indent && this.peek() == ' ') {
                this.forward();
            }
        }
        return chunks.toString();
    }

    private Token scanFlowScalar(char style) {
        boolean dbl = style == '\"';
        StringBuffer chunks = new StringBuffer();
        char quote = this.peek();
        this.forward();
        chunks.append(this.scanFlowScalarNonSpaces(dbl));
        while (this.peek() != quote) {
            chunks.append(this.scanFlowScalarSpaces());
            chunks.append(this.scanFlowScalarNonSpaces(dbl));
        }
        this.forward();
        return new ScalarToken(chunks.toString(), false, style);
    }

    private String scanFlowScalarNonSpaces(boolean dbl) {
        StringBuffer chunks;
        block8: {
            char ch;
            chunks = new StringBuffer();
            while (true) {
                int length = 0;
                while (SPACES_AND_STUFF.indexOf(this.peek(length)) == -1) {
                    ++length;
                }
                if (length != 0) {
                    chunks.append(this.prefixForward(length));
                }
                ch = this.peek();
                if (!dbl && ch == '\'' && this.peek(1) == '\'') {
                    chunks.append("'");
                    this.forward(2);
                    continue;
                }
                if (dbl && ch == '\'' || !dbl && DOUBLE_ESC.indexOf(ch) != -1) {
                    chunks.append(ch);
                    this.forward();
                    continue;
                }
                if (!dbl || ch != '\\') break block8;
                this.forward();
                ch = this.peek();
                if (ESCAPE_REPLACEMENTS.containsKey(new Character(ch))) {
                    chunks.append(ESCAPE_REPLACEMENTS.get(new Character(ch)));
                    this.forward();
                    continue;
                }
                if (ESCAPE_CODES.containsKey(new Character(ch))) {
                    length = (Integer)ESCAPE_CODES.get(new Character(ch));
                    this.forward();
                    String val = this.prefix(length);
                    if (NOT_HEXA.matcher(val).find()) {
                        throw new ScannerException("while scanning a double-quoted scalar", "expected escape sequence of " + length + " hexadecimal numbers, but found something else: " + val, null);
                    }
                    chunks.append((char)Integer.parseInt(val, 16));
                    this.forward(length);
                    continue;
                }
                if (FULL_LINEBR.indexOf(ch) == -1) break;
                this.scanLineBreak();
                chunks.append(this.scanFlowScalarBreaks());
            }
            throw new ScannerException("while scanning a double-quoted scalar", "found unknown escape character " + ch + "(" + ch + ")", null);
        }
        return chunks.toString();
    }

    private String scanFlowScalarSpaces() {
        StringBuffer chunks = new StringBuffer();
        int length = 0;
        while (BLANK_T.indexOf(this.peek(length)) != -1) {
            ++length;
        }
        String whitespaces = this.prefixForward(length);
        char ch = this.peek();
        if (ch == '\u0000') {
            throw new ScannerException("while scanning a quoted scalar", "found unexpected end of stream", null);
        }
        if (FULL_LINEBR.indexOf(ch) != -1) {
            String lineBreak = this.scanLineBreak();
            String breaks = this.scanFlowScalarBreaks();
            if (!lineBreak.equals("\n")) {
                chunks.append(lineBreak);
            } else if (breaks.length() == 0) {
                chunks.append(" ");
            }
            chunks.append(breaks);
        } else {
            chunks.append(whitespaces);
        }
        return chunks.toString();
    }

    private String scanFlowScalarBreaks() {
        StringBuffer chunks = new StringBuffer();
        String pre = null;
        while (true) {
            if (((pre = this.prefix(3)).equals("---") || pre.equals("...")) && "\u0000 \t\r\n\u0085".indexOf(this.peek(3)) != -1) {
                throw new ScannerException("while scanning a quoted scalar", "found unexpected document separator", null);
            }
            while (BLANK_T.indexOf(this.peek()) != -1) {
                this.forward();
            }
            if (FULL_LINEBR.indexOf(this.peek()) == -1) break;
            chunks.append(this.scanLineBreak());
        }
        return chunks.toString();
    }

    private Token scanPlain() {
        StringBuffer chunks = new StringBuffer();
        int ind = this.indent + 1;
        String spaces = "";
        boolean f_nzero = true;
        Pattern r_check = R_FLOWNONZERO;
        if (this.flowLevel == 0) {
            f_nzero = false;
            r_check = R_FLOWZERO;
        }
        while (this.peek() != '#') {
            int length = 0;
            int chunkSize = 32;
            Matcher m = null;
            while (!(m = r_check.matcher(this.prefix(chunkSize))).find()) {
                chunkSize += 32;
            }
            length = m.start();
            char ch = this.peek(length);
            if (f_nzero && ch == ':' && S4.indexOf(this.peek(length + 1)) == -1) {
                this.forward(length);
                throw new ScannerException("while scanning a plain scalar", "found unexpected ':'", "Please check http://pyyaml.org/wiki/YAMLColonInFlowContext for details.");
            }
            if (length == 0) break;
            this.allowSimpleKey = false;
            chunks.append(spaces);
            chunks.append(this.prefixForward(length));
            spaces = this.scanPlainSpaces(ind);
            if (spaces != null && (this.flowLevel != 0 || this.column >= ind)) continue;
            break;
        }
        return new ScalarToken(chunks.toString(), true);
    }

    private String scanPlainSpaces(int indent) {
        StringBuffer chunks = new StringBuffer();
        int length = 0;
        while (this.peek(length) == ' ') {
            ++length;
        }
        String whitespaces = this.prefixForward(length);
        char ch = this.peek();
        if (FULL_LINEBR.indexOf(ch) != -1) {
            String lineBreak = this.scanLineBreak();
            this.allowSimpleKey = true;
            if (END_OR_START.matcher(this.prefix(4)).matches()) {
                return "";
            }
            StringBuffer breaks = new StringBuffer();
            while (BLANK_OR_LINEBR.indexOf(this.peek()) != -1) {
                if (' ' == this.peek()) {
                    this.forward();
                    continue;
                }
                breaks.append(this.scanLineBreak());
                if (!END_OR_START.matcher(this.prefix(4)).matches()) continue;
                return "";
            }
            if (!lineBreak.equals("\n")) {
                chunks.append(lineBreak);
            } else if (breaks == null || breaks.toString().equals("")) {
                chunks.append(" ");
            }
            chunks.append(breaks);
        } else {
            chunks.append(whitespaces);
        }
        return chunks.toString();
    }

    private String scanTagHandle(String name) {
        char ch = this.peek();
        if (ch != '!') {
            throw new ScannerException("while scanning a " + name, "expected '!', but found " + ch + "(" + ch + ")", null);
        }
        int length = 1;
        ch = this.peek(length);
        if (ch != ' ') {
            while (ALPHA.indexOf(ch) != -1) {
                ch = this.peek(++length);
            }
            if ('!' != ch) {
                this.forward(length);
                throw new ScannerException("while scanning a " + name, "expected '!', but found " + ch + "(" + ch + ")", null);
            }
            ++length;
        }
        String value = this.prefixForward(length);
        return value;
    }

    private String scanTagUri(String name) {
        StringBuffer chunks = new StringBuffer();
        int length = 0;
        char ch = this.peek(length);
        while (STRANGE_CHAR.indexOf(ch) != -1) {
            if ('%' == ch) {
                chunks.append(this.prefixForward(length));
                length = 0;
                chunks.append(this.scanUriEscapes(name));
            } else {
                ++length;
            }
            ch = this.peek(length);
        }
        if (length != 0) {
            chunks.append(this.prefixForward(length));
        }
        if (chunks.length() == 0) {
            throw new ScannerException("while scanning a " + name, "expected URI, but found " + ch + "(" + ch + ")", null);
        }
        return chunks.toString();
    }

    private String scanUriEscapes(String name) {
        StringBuffer bytes = new StringBuffer();
        while (this.peek() == '%') {
            this.forward();
            try {
                bytes.append(Integer.parseInt(this.prefix(2), 16));
            }
            catch (NumberFormatException nfe) {
                throw new ScannerException("while scanning a " + name, "expected URI escape sequence of 2 hexadecimal numbers, but found " + this.peek(1) + "(" + this.peek(1) + ") and " + this.peek(2) + "(" + this.peek(2) + ")", null);
            }
            this.forward(2);
        }
        return bytes.toString();
    }

    private String scanLineBreak() {
        char val = this.peek();
        if (FULL_LINEBR.indexOf(val) != -1) {
            if (RN.equals(this.prefix(2))) {
                this.forward(2);
            } else {
                this.forward();
            }
            return "\n";
        }
        return "";
    }

    public static void main(String[] args) throws Exception {
        String filename = args[0];
        System.out.println("Reading of file: \"" + filename + "\"");
        StringBuffer input = new StringBuffer();
        FileReader reader = new FileReader(filename);
        char[] buff = new char[1024];
        int read = 0;
        do {
            read = reader.read(buff);
            input.append(buff, 0, read);
        } while (read >= 1024);
        ((Reader)reader).close();
        String str = input.toString();
        long before = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            ScannerImpl sce2 = new ScannerImpl(str);
            Iterator iter = sce2.eachToken();
            while (iter.hasNext()) {
                System.out.println(iter.next());
            }
        }
        long after = System.currentTimeMillis();
        long time = after - before;
        double timeS = (double)(after - before) / 1000.0;
        System.out.println("Walking through the tokens for the file: " + filename + " took " + time + "ms, or " + timeS + " seconds");
    }

    static {
        ESCAPE_REPLACEMENTS.put(new Character('0'), "\u0000");
        ESCAPE_REPLACEMENTS.put(new Character('a'), "\u0007");
        ESCAPE_REPLACEMENTS.put(new Character('b'), "\b");
        ESCAPE_REPLACEMENTS.put(new Character('t'), "\t");
        ESCAPE_REPLACEMENTS.put(new Character('\t'), "\t");
        ESCAPE_REPLACEMENTS.put(new Character('n'), "\n");
        ESCAPE_REPLACEMENTS.put(new Character('v'), "\u000b");
        ESCAPE_REPLACEMENTS.put(new Character('f'), "\f");
        ESCAPE_REPLACEMENTS.put(new Character('r'), "\r");
        ESCAPE_REPLACEMENTS.put(new Character('e'), "\u001b");
        ESCAPE_REPLACEMENTS.put(new Character(' '), " ");
        ESCAPE_REPLACEMENTS.put(new Character('\"'), "\"");
        ESCAPE_REPLACEMENTS.put(new Character('\\'), "\\");
        ESCAPE_REPLACEMENTS.put(new Character('N'), "\u0085");
        ESCAPE_REPLACEMENTS.put(new Character('_'), "\u00a0");
        ESCAPE_REPLACEMENTS.put(new Character('L'), "\u2028");
        ESCAPE_REPLACEMENTS.put(new Character('P'), "\u2029");
        ESCAPE_CODES.put(new Character('x'), new Integer(2));
        ESCAPE_CODES.put(new Character('u'), new Integer(4));
        ESCAPE_CODES.put(new Character('U'), new Integer(8));
    }

    private class TokenIterator
    implements Iterator {
        private TokenIterator() {
        }

        public boolean hasNext() {
            return null != ScannerImpl.this.peekToken();
        }

        public Object next() {
            return ScannerImpl.this.getToken();
        }

        public void remove() {
        }
    }
}

