<?xml version="1.0"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="html"/>

  	<xsl:template match="/proxyType">
    	<html>
      		<head>
				<xsl:call-template name="style"/>
       		</head>
      		<body>
				<div class="header">
					<h1>Class <b><xsl:value-of select="class"/></b></h1>
				</div>
				<div class="shadow"/>
			
				<div class="body">
				
				<div class="toc">
					<xsl:apply-templates select="interface" mode="toc"/>
				</div>

				<xsl:apply-templates select="interface"/>
				
				</div>				
      		</body>
    	</html>
  	</xsl:template>

	<xsl:template match="interface" mode="toc">
		<div class="toc-interface">
			<xsl:element name="a">
				<xsl:attribute name="href">#<xsl:value-of select="position()"/></xsl:attribute>
				<b><xsl:value-of select="@class"/></b>
			</xsl:element></div>

		<xsl:apply-templates select="method" mode="toc">
			<xsl:with-param name="interfacePosition" select="position()"/>
		</xsl:apply-templates>
  	</xsl:template>

	<xsl:template match="method" mode="toc">
		<xsl:param name="interfacePosition"/>
		<div class="toc-method">
			<xsl:element name="a">
				<xsl:attribute name="href">#<xsl:value-of select="$interfacePosition"/>.<xsl:value-of select="position()"/></xsl:attribute>
				<xsl:value-of select="signature"/>
			</xsl:element></div>
  	</xsl:template>

	<xsl:template match="interface">
		<xsl:element name="a">
			<xsl:attribute name="name"><xsl:value-of select="position()"/></xsl:attribute>
		</xsl:element>

		<h2>Interface <b><xsl:value-of select="@class"/></b></h2>

		<div class="methods">
			<xsl:apply-templates select="method">
				<xsl:with-param name="interfacePosition" select="position()"/>
			</xsl:apply-templates>
  		</div>
  	</xsl:template>

	<xsl:template match="method">
		<xsl:param name="interfacePosition"/>
		<xsl:element name="a">
			<xsl:attribute name="name"><xsl:value-of select="$interfacePosition"/>.<xsl:value-of select="position()"/></xsl:attribute>
		</xsl:element>
		<p>
			<div class="method">Method <b><xsl:value-of select="signature"/></b></div>

			<xsl:apply-templates select="interceptorFactory"/>
		</p>
	</xsl:template>

	<xsl:template match="interceptorFactory">
		<div class="interceptorFactory"><xsl:apply-templates select="property"/></div>
	</xsl:template>

	<xsl:template match="property">
		<b><xsl:value-of select="name"/>:</b>&#160;<xsl:value-of select="value"/><br/>
	</xsl:template>
	
	<xsl:template name="style">
 			<style type="text/css">
      			body {
					background: #FFFFFF;
					margin: 0px;
					font-family: Georgia, serif;
					font-size: 13px;
				}
				
				.body {
					margin: 15px;
				}
				
				.toc-interface {
					margin-left: 10px;
					margin-top: 5px;
				}
				.toc-method {
					margin-left: 30px;
				}
				
				a {
					color: #225588;;
					text-decoration: none;
				}
				
				a:hover {
					color: #993333;;
					text-decoration: underline;
				}
				
				.header {
					font-family: serif, Trebuchet MS;
					color: #ffffee;
					background: #5588BB;
					border-bottom: 1px solid #333333;
					padding: 10px;
					font-size: 24px;
				}
				
				.shadow {
					background-color: #dddddd;
					border-bottom: 1px solid #eeeeee;
					margin-bottom: 15px;
					height:1px;
					font-size: 1px;
					width: 100%;
				}
				
				h1 {
					color: #ffffcc;
					font-family: Trebuchet MS, sans-serif;
					font-size: 28px;
					font-weight: normal;
						margin-bottom: 0px;
				}
				
				h2 {
					color: #114477;
					font-family: Trebuchet MS, sans-serif;
					font-size: 22px;
					font-weight: normal;
					margin-bottom: 0px;
					width: 100%;
					margin-top: 20px;
					padding-bottom: 5px;
					border-bottom: 1px dotted #666666;
				}
				
				.methods {
					margin: 10px;
					margin-right: 20px;
				}
				
				.method {
					background-color: #ffffcc;
					border: 1px solid #999999;
					width: 100%;
					padding: 5px;
					font-size: 16px;
				}
				
				.interceptorFactory {
					background-color: #eeeeee;
					border: 1px solid #999999;
					border-top: 0px;
					width: 100%;
					padding: 5px;
				}
  			</style>
	</xsl:template>
</xsl:stylesheet>