/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.engine.AbstractConnectionFactory;
import org.castor.jdo.engine.DatabaseRegistry;
import org.castor.persist.ProposedObject;
import org.castor.persist.TransactionContext;
import org.exolab.castor.jdo.CacheManager;
import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DatabaseNotFoundException;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.ObjectNotPersistentException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.Query;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.jdo.TransactionNotInProgressException;
import org.exolab.castor.jdo.engine.OQLQueryImpl;
import org.exolab.castor.jdo.engine.TransactionContextImpl;
import org.exolab.castor.jdo.engine.TxDatabaseMap;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.PersistenceInfo;
import org.exolab.castor.persist.PersistenceInfoGroup;
import org.exolab.castor.persist.TxSynchronizable;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.InstanceFactory;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.Messages;

public class DatabaseImpl
implements Database,
Synchronization {
    private static final String TxSynchronizableProperty = "org.exolab.castor.persist.TxSynchronizable";
    private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$jdo$engine$DatabaseImpl == null ? (class$org$exolab$castor$jdo$engine$DatabaseImpl = DatabaseImpl.class$("org.exolab.castor.jdo.engine.DatabaseImpl")) : class$org$exolab$castor$jdo$engine$DatabaseImpl);
    protected PersistenceInfoGroup _scope;
    protected TransactionContext _ctx;
    private ArrayList _synchronizables;
    private int _lockTimeout;
    private CallbackInterceptor _callback;
    private InstanceFactory _instanceFactory;
    private String _dbName;
    private Transaction _transaction;
    private boolean _autoStore;
    private ClassLoader _classLoader;
    private TxDatabaseMap _txMap;
    private CacheManager cacheManager;
    static /* synthetic */ Class class$org$exolab$castor$jdo$engine$DatabaseImpl;

    public DatabaseImpl(String dbName, int lockTimeout, CallbackInterceptor callback, InstanceFactory instanceFactory, Transaction transaction, ClassLoader classLoader, boolean autoStore) throws DatabaseNotFoundException {
        this._autoStore = autoStore;
        AbstractConnectionFactory factory = null;
        try {
            factory = DatabaseRegistry.getConnectionFactory(dbName);
        }
        catch (MappingException ex) {
            throw new DatabaseNotFoundException(Messages.format("jdo.dbNoMapping", dbName));
        }
        this._scope = new PersistenceInfoGroup(new LockEngine[]{factory.getEngine()});
        this._callback = callback;
        this._instanceFactory = instanceFactory;
        this._dbName = dbName;
        this._lockTimeout = lockTimeout;
        this._transaction = transaction;
        if (this._transaction != null) {
            try {
                this._ctx = new TransactionContextImpl(this, true, transaction);
            }
            catch (SystemException se) {
                throw new DatabaseNotFoundException(se);
            }
        } else {
            this._ctx = new TransactionContextImpl((Database)this, false);
        }
        this._ctx.setLockTimeout(this._lockTimeout);
        this._ctx.setAutoStore(this._autoStore);
        this._ctx.setCallback(this._callback);
        this._ctx.setInstanceFactory(this._instanceFactory);
        this._classLoader = classLoader;
        this.loadSynchronizables();
    }

    LockEngine getLockEngine() {
        return this._scope.getLockEngine();
    }

    public PersistenceInfoGroup getScope() {
        return this._scope;
    }

    public void setAutoStore(boolean autoStore) {
        this._autoStore = autoStore;
    }

    public boolean isAutoStore() {
        if (this._ctx != null) {
            return this._ctx.isAutoStore();
        }
        return this._autoStore;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String getDatabaseName() {
        return this._dbName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws PersistenceException {
        block10: {
            try {
                if (this._transaction == null) {
                    if (this._ctx == null || !this._ctx.isOpen()) break block10;
                    try {
                        this._ctx.rollback();
                    }
                    catch (Exception except) {
                        // empty catch block
                    }
                    try {
                        this._ctx.close();
                    }
                    catch (Exception except) {
                        // empty catch block
                    }
                    throw new PersistenceException(Messages.message("jdo.dbClosedTxRolledback"));
                }
                if (this._ctx == null || !this._ctx.isOpen()) break block10;
                try {
                    this._ctx.close();
                }
                catch (Exception e) {
                    throw new PersistenceException(e.getMessage());
                }
            }
            finally {
                this._scope = null;
            }
        }
    }

    public boolean isClosed() {
        return this._scope == null;
    }

    public Object load(Class type, Object identity) throws ObjectNotFoundException, LockNotGrantedException, TransactionNotInProgressException, PersistenceException {
        return this.load(type, identity, null, null);
    }

    public Object load(Class type, Object identity, Object object) throws TransactionNotInProgressException, ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        return this.load(type, identity, object, null);
    }

    public Object load(Class type, Object identity, short accessMode) throws ObjectNotFoundException, LockNotGrantedException, TransactionNotInProgressException, PersistenceException {
        AccessMode mode = AccessMode.valueOf(accessMode);
        return this.load(type, identity, null, mode);
    }

    public Object load(Class type, Object identity, AccessMode mode) throws TransactionNotInProgressException, ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        return this.load(type, identity, null, mode);
    }

    private Object load(Class type, Object identity, Object object, AccessMode mode) throws TransactionNotInProgressException, ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(type);
        ProposedObject proposedObject = new ProposedObject();
        return tx.load(info.engine, info.molder, identity, proposedObject, mode);
    }

    public void create(Object object) throws ClassNotPersistenceCapableException, DuplicateIdentityException, TransactionNotInProgressException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(object.getClass());
        tx.create(info.engine, info.molder, object, null);
    }

    public CacheManager getCacheManager() {
        if (this.cacheManager == null) {
            this.cacheManager = new CacheManager(this, this._ctx, this.getLockEngine());
        }
        return this.cacheManager;
    }

    public void update(Object object) throws ClassNotPersistenceCapableException, ObjectModifiedException, TransactionNotInProgressException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(object.getClass());
        tx.update(info.engine, info.molder, object, null);
    }

    public void remove(Object object) throws ObjectNotPersistentException, LockNotGrantedException, TransactionNotInProgressException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(object.getClass());
        tx.delete(object);
    }

    public boolean isPersistent(Object object) {
        if (this._scope == null) {
            throw new IllegalStateException(Messages.message("jdo.dbClosed"));
        }
        if (this._ctx != null && this._ctx.isOpen()) {
            return this._ctx.isPersistent(object);
        }
        return false;
    }

    public Object getIdentity(Object object) {
        if (this._scope == null) {
            throw new IllegalStateException(Messages.message("jdo.dbClosed"));
        }
        if (this._ctx != null && this._ctx.isOpen()) {
            return this._ctx.getIdentity(object);
        }
        return null;
    }

    public void lock(Object object) throws LockNotGrantedException, ObjectNotPersistentException, TransactionNotInProgressException, PersistenceException {
        if (this._ctx == null || !this._ctx.isOpen()) {
            throw new TransactionNotInProgressException(Messages.message("jdo.txNotInProgress"));
        }
        this._ctx.writeLock(object, this._lockTimeout);
    }

    public OQLQuery getOQLQuery() {
        return new OQLQueryImpl(this);
    }

    public OQLQuery getOQLQuery(String oql) throws PersistenceException {
        OQLQueryImpl oqlImpl = new OQLQueryImpl(this);
        oqlImpl.create(oql);
        return oqlImpl;
    }

    public Query getQuery() {
        return new OQLQueryImpl(this);
    }

    protected void finalize() throws Throwable {
        if (this._scope != null) {
            OQLQuery oqlQuery = this.getOQLQuery();
            String sql = ((OQLQueryImpl)oqlQuery).getSQL();
            _log.warn((Object)Messages.format("jdo.finalize_close", this.toString(), this._dbName, sql));
            this.close();
        }
    }

    protected TransactionContext getTransaction() throws TransactionNotInProgressException {
        if (this._scope == null) {
            throw new TransactionNotInProgressException(Messages.message("jdo.dbClosed"));
        }
        if (this._ctx != null && this._ctx.isOpen()) {
            return this._ctx;
        }
        throw new TransactionNotInProgressException(Messages.message("jdo.dbTxNotInProgress"));
    }

    public void begin() throws PersistenceException {
        _log.debug((Object)"Beginning tx");
        if (this._transaction != null) {
            throw new IllegalStateException(Messages.message("jdo.txInJ2EE"));
        }
        if (this._ctx != null && this._ctx.isOpen()) {
            throw new PersistenceException(Messages.message("jdo.txInProgress"));
        }
        ((TransactionContextImpl)this._ctx).setStatusActive();
        this._ctx.setLockTimeout(this._lockTimeout);
        this._ctx.setAutoStore(this._autoStore);
        this._ctx.setCallback(this._callback);
        this._ctx.setInstanceFactory(this._instanceFactory);
        this.registerSynchronizables();
    }

    /*
     * Loose catch block
     */
    public void commit() throws TransactionNotInProgressException, TransactionAbortedException {
        block12: {
            _log.debug((Object)"Committing tx");
            if (this._transaction != null) {
                throw new IllegalStateException(Messages.message("jdo.txInJ2EE"));
            }
            if (this._ctx == null || !this._ctx.isOpen()) {
                throw new TransactionNotInProgressException(Messages.message("jdo.txNotInProgress"));
            }
            if (this._ctx.getStatus() == 1) {
                throw new TransactionAbortedException(Messages.message("jdo.txRollback"));
            }
            this._ctx.prepare();
            this._ctx.commit();
            Object var3_1 = null;
            try {
                if (this._ctx.isOpen()) {
                    this._ctx.close();
                }
                break block12;
            }
            catch (Exception e) {
                _log.info((Object)e.getMessage(), (Throwable)e);
            }
            break block12;
            {
                catch (TransactionAbortedException except) {
                    _log.error((Object)Messages.format("jdo.txAborted", except.getMessage()), (Throwable)except);
                    this._ctx.rollback();
                    throw except;
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                try {
                    if (this._ctx.isOpen()) {
                        this._ctx.close();
                    }
                }
                catch (Exception e) {
                    _log.info((Object)e.getMessage(), (Throwable)e);
                }
                throw throwable;
            }
        }
        this.unregisterSynchronizables();
    }

    public void rollback() throws TransactionNotInProgressException {
        _log.debug((Object)"Rolling back tx");
        if (this._transaction != null) {
            throw new IllegalStateException(Messages.message("jdo.txInJ2EE"));
        }
        if (this._ctx == null || !this._ctx.isOpen()) {
            throw new TransactionNotInProgressException(Messages.message("jdo.txNotInProgress"));
        }
        this._ctx.rollback();
        this.unregisterSynchronizables();
    }

    public void beforeCompletion() {
        if (this._transaction == null || this._ctx == null || !this._ctx.isOpen()) {
            throw new IllegalStateException(Messages.message("jdo.txNotInProgress"));
        }
        if (this._ctx.getStatus() == 1) {
            try {
                this._transaction.setRollbackOnly();
            }
            catch (SystemException except) {
                _log.warn((Object)Messages.format("jdo.warnException", (Object)except));
            }
            return;
        }
        try {
            this._ctx.prepare();
        }
        catch (TransactionAbortedException tae) {
            _log.error((Object)Messages.format("jdo.txAbortedMarkRollback", tae.getMessage()), (Throwable)tae);
            try {
                this._transaction.setRollbackOnly();
            }
            catch (SystemException se) {
                _log.fatal((Object)Messages.format("jdo.txMarkRollbackFailure", se.getMessage()), (Throwable)se);
            }
            this._ctx.rollback();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void afterCompletion(int status) {
        block13: {
            block12: {
                block11: {
                    try {
                        if (this._transaction == null) throw new IllegalStateException(Messages.message("jdo.txNotInProgress"));
                        if (this._ctx == null) {
                            throw new IllegalStateException(Messages.message("jdo.txNotInProgress"));
                        }
                        if (this._ctx.getStatus() == 4) {
                            Object var4_2 = null;
                            if (this._txMap == null) return;
                            if (this._transaction == null) return;
                            this._txMap.remove(this._transaction);
                            break block11;
                        }
                        if (this._ctx.getStatus() != 2 && status != 4) {
                            throw new IllegalStateException("Unexpected state: afterCompletion called at status " + this._ctx.getStatus());
                        }
                        switch (status) {
                            case 3: {
                                try {
                                    this._ctx.commit();
                                }
                                catch (TransactionAbortedException except) {
                                    _log.fatal((Object)Messages.format("jdo.fatalException", except));
                                    this._ctx.rollback();
                                }
                                break block12;
                            }
                            case 4: {
                                this._ctx.rollback();
                                break block13;
                            }
                            default: {
                                this._ctx.rollback();
                                throw new IllegalStateException("Unexpected state: afterCompletion called with status " + status);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        if (this._txMap == null) throw throwable;
                        if (this._transaction == null) throw throwable;
                        this._txMap.remove(this._transaction);
                        this._txMap = null;
                        throw throwable;
                    }
                }
                this._txMap = null;
                return;
            }
            Object var4_3 = null;
            if (this._txMap == null) return;
            if (this._transaction == null) return;
            this._txMap.remove(this._transaction);
            this._txMap = null;
            return;
        }
        Object var4_4 = null;
        if (this._txMap == null) return;
        if (this._transaction == null) return;
        this._txMap.remove(this._transaction);
        this._txMap = null;
    }

    void setTxMap(TxDatabaseMap txMap) {
        this._txMap = txMap;
    }

    public boolean isActive() {
        return this._ctx != null && this._ctx.isOpen();
    }

    public String toString() {
        return super.toString() + ":" + this._dbName;
    }

    public Connection getJdbcConnection() throws PersistenceException {
        return this._ctx.getConnection(this._scope.getLockEngine());
    }

    private void loadSynchronizables() {
        if (this._synchronizables == null) {
            this._synchronizables = new ArrayList();
            String syncName = LocalConfiguration.getInstance().getProperty(TxSynchronizableProperty, "");
            StringTokenizer tokenizer = new StringTokenizer(syncName, ", ");
            while (tokenizer.hasMoreTokens()) {
                syncName = tokenizer.nextToken();
                try {
                    Class<?> cls = null;
                    cls = this._classLoader != null ? this._classLoader.loadClass(syncName) : Class.forName(syncName);
                    TxSynchronizable sync = (TxSynchronizable)cls.newInstance();
                    if (sync == null) continue;
                    this._synchronizables.add(sync);
                }
                catch (Exception except) {
                    _log.warn((Object)Messages.format("jdo.missingTxSynchronizable", syncName));
                }
            }
            if (this._synchronizables.size() == 0) {
                this._synchronizables = null;
            }
        }
    }

    private void registerSynchronizables() {
        if (this._synchronizables != null && this._synchronizables.size() > 0) {
            Iterator iter = this._synchronizables.iterator();
            while (iter.hasNext()) {
                this._ctx.addTxSynchronizable((TxSynchronizable)iter.next());
            }
        }
    }

    private void unregisterSynchronizables() {
        if (this._synchronizables != null && this._synchronizables.size() > 0) {
            Iterator iter = this._synchronizables.iterator();
            while (iter.hasNext()) {
                this._ctx.removeTxSynchronizable((TxSynchronizable)iter.next());
            }
        }
    }

    public void expireCache(Class[] type, Object[] identity) throws PersistenceException {
        throw new PersistenceException("Please use the new CacheManager to manage Castor performance caches.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

