/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.transactionmanager.spi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import org.exolab.castor.jdo.conf.JdoConf;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerAcquireException;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerFactory;
import org.exolab.castor.util.Messages;

public abstract class AbstractTransactionManagerFactory
implements TransactionManagerFactory {
    public abstract String getFactoryClassName();

    public abstract String getFactoryMethodName();

    public final TransactionManager getTransactionManager(JdoConf jdoConf) throws TransactionManagerAcquireException {
        TransactionManager transactionManager;
        try {
            Class<?> factory = Class.forName(this.getFactoryClassName());
            Method method = factory.getMethod(this.getFactoryMethodName(), null);
            Object obj = method.invoke(factory, (Object[])null);
            transactionManager = (TransactionManager)obj;
        }
        catch (ClassNotFoundException ex) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.failToGetManager", this.getFactoryClassName()), ex);
        }
        catch (IllegalAccessException ex) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.failToGetManager", this.getFactoryClassName()), ex);
        }
        catch (InvocationTargetException ex) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.failToGetManager", this.getFactoryClassName()), ex);
        }
        catch (NoSuchMethodException ex) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.failToGetManager", this.getFactoryClassName()), ex);
        }
        return transactionManager;
    }
}

