/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.sql.Connection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.persist.ProposedObject;
import org.castor.persist.TransactionContext;
import org.castor.persist.UpdateAndRemovedFlags;
import org.castor.persist.UpdateFlags;
import org.castor.persist.resolver.ResolverFactory;
import org.castor.persist.resolver.ResolverStrategy;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.TimeStampable;
import org.exolab.castor.jdo.engine.JDOCallback;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.MappingLoader;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.persist.ClassMolderHelper;
import org.exolab.castor.persist.DatingService;
import org.exolab.castor.persist.DepositBox;
import org.exolab.castor.persist.FieldMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectLock;
import org.exolab.castor.persist.QueryResults;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.Complex;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.util.Messages;

public class ClassMolder {
    private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$persist$ClassMolder == null ? (class$org$exolab$castor$persist$ClassMolder = ClassMolder.class$("org.exolab.castor.persist.ClassMolder")) : class$org$exolab$castor$persist$ClassMolder);
    private String _name;
    private FieldMolder[] _ids;
    private FieldMolder[] _fhs;
    private ClassMolder _extends;
    private ClassMolder _depends;
    private Vector _dependent;
    private Vector _extendent;
    private AccessMode _accessMode;
    private Persistence _persistence;
    private LockEngine _engine;
    private CallbackInterceptor _callback;
    private String _cachetype;
    private int _cacheparam;
    boolean _isKeyGenUsed;
    private boolean _debug = Boolean.getBoolean("org.exolab.castor.debug");
    private boolean _timeStampable;
    private int _priority = -1;
    boolean resolversHaveBeenReset = false;
    private ResolverStrategy[] _resolvers;
    static /* synthetic */ Class class$org$exolab$castor$persist$ClassMolder;
    static /* synthetic */ Class class$org$exolab$castor$jdo$TimeStampable;
    static /* synthetic */ Class class$org$exolab$castor$jdo$Persistent;

    ClassMolder(DatingService ds, MappingLoader loader, LockEngine lock, ClassDescriptor clsDesc, Persistence persist) throws ClassNotFoundException, MappingException {
        ClassMapping clsMap = ((ClassDescriptorImpl)clsDesc).getMapping();
        this._engine = lock;
        this._persistence = persist;
        this._name = clsMap.getName();
        this._accessMode = AccessMode.valueOf(clsMap.getAccess().toString());
        this._timeStampable = (class$org$exolab$castor$jdo$TimeStampable == null ? (class$org$exolab$castor$jdo$TimeStampable = ClassMolder.class$("org.exolab.castor.jdo.TimeStampable")) : class$org$exolab$castor$jdo$TimeStampable).isAssignableFrom(clsDesc.getJavaClass());
        ds.register(this._name, this);
        ClassMapping dep = (ClassMapping)clsMap.getDepends();
        ClassMapping ext = (ClassMapping)clsMap.getExtends();
        if (dep != null) {
            ds.pairDepends(this, dep.getName());
        }
        if (ext != null) {
            ds.pairExtends(this, ext.getName());
        }
        if (clsDesc instanceof JDOClassDescriptor) {
            if (((JDOClassDescriptor)clsDesc).getCacheType() != null) {
                this._cachetype = ((JDOClassDescriptor)clsDesc).getCacheType();
                this._cacheparam = ((JDOClassDescriptor)clsDesc).getCacheParam();
            }
            boolean bl = this._isKeyGenUsed = ((JDOClassDescriptor)clsDesc).getKeyGeneratorDescriptor() != null;
            if (this._timeStampable && this._cachetype != null && this._cachetype.equalsIgnoreCase("none")) {
                throw new MappingException(Messages.format("persist.wrongCacheTypeSpecified", this._name));
            }
        }
        FieldMapping[] fmId = ClassMolderHelper.getIdFields(clsMap);
        this._ids = new FieldMolder[fmId.length];
        for (int i = 0; i < this._ids.length; ++i) {
            this._ids[i] = new FieldMolder(ds, this, fmId[i]);
        }
        FieldMapping[] fmFields = ClassMolderHelper.getFullFields(clsMap);
        int numberOfNonTransietnFieldMolders = 0;
        for (int i = 0; i < fmFields.length; ++i) {
            boolean isFieldTransient = fmFields[i].getTransient();
            if (fmFields[i].getSql() != null) {
                isFieldTransient |= fmFields[i].getSql().getTransient();
            }
            if (isFieldTransient) continue;
            ++numberOfNonTransietnFieldMolders;
        }
        this._fhs = new FieldMolder[numberOfNonTransietnFieldMolders];
        this._resolvers = new ResolverStrategy[numberOfNonTransietnFieldMolders];
        int fieldMolderNumber = 0;
        for (int i = 0; i < fmFields.length; ++i) {
            boolean isTransientField = fmFields[i].getTransient();
            if (fmFields[i].getSql() != null) {
                isTransientField |= fmFields[i].getSql().getTransient();
            }
            if (isTransientField) continue;
            if (fmFields[i].getSql() != null && fmFields[i].getSql().getManyTable() != null) {
                String[] manyName;
                String[] manyKey;
                String manyTable = null;
                String[] idSQL = null;
                int[] idType = null;
                String[] relatedIdSQL = null;
                int[] relatedIdType = null;
                TypeConvertor[] idConvertTo = null;
                TypeConvertor[] idConvertFrom = null;
                String[] idConvertParam = null;
                TypeConvertor[] relatedIdConvertTo = null;
                TypeConvertor[] relatedIdConvertFrom = null;
                String[] relatedIdConvertParam = null;
                manyTable = fmFields[i].getSql().getManyTable();
                idSQL = new String[fmId.length];
                idType = new int[fmId.length];
                idConvertFrom = new TypeConvertor[fmId.length];
                idConvertTo = new TypeConvertor[fmId.length];
                idConvertParam = new String[fmId.length];
                FieldDescriptor[] fd = ((ClassDescriptorImpl)clsDesc).getIdentities();
                for (int j = 0; j < fmId.length; ++j) {
                    idSQL[j] = fmId[j].getSql().getName()[0];
                    if (!(fd[j] instanceof JDOFieldDescriptor)) {
                        throw new MappingException("Identity type must contains sql information: " + this._name);
                    }
                    int[] type = ((JDOFieldDescriptor)fd[j]).getSQLType();
                    idType[j] = type == null ? 0 : type[0];
                    FieldHandlerImpl fh = (FieldHandlerImpl)fd[j].getHandler();
                    idConvertTo[j] = fh.getConvertTo();
                    idConvertFrom[j] = fh.getConvertFrom();
                    idConvertParam[j] = fh.getConvertParam();
                }
                relatedIdSQL = null;
                String relatedType = fmFields[i].getType();
                ClassDescriptor relDesc = loader.getDescriptor(ds.resolve(relatedType));
                if (relDesc instanceof JDOClassDescriptor) {
                    FieldDescriptor[] relatedIds = ((JDOClassDescriptor)relDesc).getIdentities();
                    relatedIdSQL = new String[relatedIds.length];
                    relatedIdType = new int[relatedIds.length];
                    relatedIdConvertTo = new TypeConvertor[relatedIds.length];
                    relatedIdConvertFrom = new TypeConvertor[relatedIds.length];
                    relatedIdConvertParam = new String[relatedIds.length];
                    for (int j = 0; j < relatedIdSQL.length; ++j) {
                        if (!(relatedIds[j] instanceof JDOFieldDescriptor)) {
                            throw new MappingException("Field type is not persistence-capable: " + relatedIds[j].getFieldName());
                        }
                        String[] tempId = ((JDOFieldDescriptor)relatedIds[j]).getSQLName();
                        relatedIdSQL[j] = tempId == null ? null : tempId[0];
                        int[] tempType = ((JDOFieldDescriptor)relatedIds[j]).getSQLType();
                        relatedIdType[j] = tempType == null ? 0 : tempType[0];
                        FieldHandlerImpl fh = (FieldHandlerImpl)relatedIds[j].getHandler();
                        relatedIdConvertTo[j] = fh.getConvertTo();
                        relatedIdConvertFrom[j] = fh.getConvertFrom();
                        relatedIdConvertParam[j] = fh.getConvertParam();
                    }
                }
                if ((manyKey = fmFields[i].getSql().getManyKey()) != null && manyKey.length != 0) {
                    if (manyKey.length != idSQL.length) {
                        throw new MappingException("The number of many-keys doesn't match referred object: " + clsDesc.getJavaClass().getName());
                    }
                    idSQL = manyKey;
                }
                if ((manyName = fmFields[i].getSql().getName()) != null && manyName.length != 0) {
                    if (manyName.length != relatedIdSQL.length) {
                        throw new MappingException("The number of many-keys doesn't match referred object: " + relDesc.getJavaClass().getName());
                    }
                    relatedIdSQL = manyName;
                }
                this._fhs[fieldMolderNumber] = new FieldMolder(ds, this, fmFields[i], manyTable, idSQL, idType, idConvertTo, idConvertFrom, idConvertParam, relatedIdSQL, relatedIdType, relatedIdConvertTo, relatedIdConvertFrom, relatedIdConvertParam);
            } else {
                this._fhs[fieldMolderNumber] = new FieldMolder(ds, this, fmFields[i]);
            }
            this._resolvers[fieldMolderNumber] = ResolverFactory.createRelationResolver(this._fhs[fieldMolderNumber], this, this._debug);
            ++fieldMolderNumber;
        }
        if ((class$org$exolab$castor$jdo$Persistent == null ? (class$org$exolab$castor$jdo$Persistent = ClassMolder.class$("org.exolab.castor.jdo.Persistent")) : class$org$exolab$castor$jdo$Persistent).isAssignableFrom(ds.resolve(this._name))) {
            this._callback = new JDOCallback();
        }
    }

    public boolean removeRelation(TransactionContext tx, Object object, ClassMolder relatedMolder, Object relatedObject) {
        boolean removed = false;
        boolean updateCache = false;
        boolean updatePersist = false;
        this.resetResolvers();
        UpdateAndRemovedFlags flags = null;
        for (int i = 0; i < this._fhs.length; ++i) {
            flags = this._resolvers[i].removeRelation(tx, object, relatedMolder, relatedObject);
            updateCache |= flags.getUpdateCache();
            updatePersist |= flags.getUpdatePersist();
            removed |= flags.getRemoved();
        }
        tx.markModified(object, updatePersist, updateCache);
        return removed;
    }

    public int getPriority() {
        if (this._priority == -2) {
            return 0;
        }
        if (this._priority < 0) {
            this._priority = -2;
            int maxPrior = 0;
            for (int i = 0; i < this._fhs.length; ++i) {
                if (!this._fhs[i].isPersistanceCapable() || this._fhs[i].getFieldClassMolder() == this || !this._fhs[i].isStored()) continue;
                int refPrior = this._fhs[i].getFieldClassMolder().getPriority() + 1;
                maxPrior = Math.max(maxPrior, refPrior);
            }
            if (this._depends != null) {
                maxPrior = Math.max(maxPrior, this._depends.getPriority() + 1);
            }
            if (this._extends != null) {
                maxPrior = Math.max(maxPrior, this._extends.getPriority() + 1);
            }
            this._priority = maxPrior;
        }
        return this._priority;
    }

    public Object load(TransactionContext tx, OID oid, DepositBox locker, ProposedObject proposedObject, AccessMode suggestedAccessMode) throws ObjectNotFoundException, PersistenceException {
        return this.load(tx, oid, locker, proposedObject, suggestedAccessMode, null);
    }

    private Object loadFields(TransactionContext tx, OID oid, DepositBox locker, ProposedObject proposedObject, AccessMode suggestedAccessMode, QueryResults results) throws ObjectNotFoundException, PersistenceException {
        Object[] fields = null;
        Object stamp = null;
        AccessMode accessMode = this.getAccessMode(suggestedAccessMode);
        if (!proposedObject.isObjectLockObjectToBeIgnored()) {
            fields = (Object[])locker.getObject(tx);
        }
        proposedObject.setFields(fields);
        if (fields == null || accessMode == AccessMode.DbLocked) {
            fields = new Object[this._fhs.length];
            proposedObject.setFields(fields);
            if (results != null) {
                stamp = results.getQuery().fetch(proposedObject, oid.getIdentity());
                fields = proposedObject.getFields();
            } else {
                Connection conn = tx.getConnection(oid.getLockEngine());
                stamp = this._persistence.load(conn, proposedObject, oid.getIdentity(), accessMode);
                fields = proposedObject.getFields();
            }
            if (proposedObject.isExpanded() && _log.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Actual object has been expanded from ");
                sb.append(proposedObject.getProposedClass());
                sb.append(" to ");
                sb.append(proposedObject.getActualClass());
                sb.append(", with the field values to set as follows:\n");
                for (int i = 0; i < fields.length; ++i) {
                    sb.append("field ");
                    sb.append(i + 1);
                    sb.append(": ");
                    sb.append(fields[i]);
                    sb.append('\n');
                }
                _log.debug((Object)sb);
            }
            oid.setDbLock(accessMode == AccessMode.DbLocked);
            locker.setObject(tx, fields);
        }
        proposedObject.setActualClassMolder(this);
        return stamp;
    }

    public Object load(TransactionContext tx, OID oid, DepositBox locker, ProposedObject proposedObject, AccessMode suggestedAccessMode, QueryResults results) throws ObjectNotFoundException, PersistenceException {
        Object stamp = null;
        AccessMode accessMode = this.getAccessMode(suggestedAccessMode);
        this.resetResolvers();
        if (oid.getIdentity() == null) {
            throw new PersistenceException("The identities of the object to be loaded is null");
        }
        stamp = this.loadFields(tx, oid, locker, proposedObject, suggestedAccessMode, results);
        if (proposedObject.isExpanded()) {
            return stamp;
        }
        Object[] fields = proposedObject.getFields();
        if (proposedObject.getObject() instanceof TimeStampable) {
            ((TimeStampable)proposedObject.getObject()).jdoSetTimeStamp(locker.getTimeStamp());
        }
        Object ids = oid.getIdentity();
        this.setIdentity(tx, proposedObject.getObject(), ids);
        block3: for (int i = 0; i < this._fhs.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this._resolvers[i].load(tx, oid, proposedObject, accessMode, fields[i]);
                    continue block3;
                }
                default: {
                    throw new PersistenceException("Unexpected field type!");
                }
            }
        }
        return stamp;
    }

    public Object create(TransactionContext tx, OID oid, DepositBox locker, Object object) throws DuplicateIdentityException, PersistenceException {
        int i;
        this.resetResolvers();
        if (this._persistence == null) {
            throw new PersistenceException("non persistence capable: " + oid.getName());
        }
        Object[] fields = new Object[this._fhs.length];
        Object ids = oid.getIdentity();
        block3: for (i = 0; i < this._fhs.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    fields[i] = this._resolvers[i].create(tx, object);
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException("Field type invalid!");
                }
            }
        }
        Object createdId = this._persistence.create(tx.getDatabase(), tx.getConnection(oid.getLockEngine()), fields, ids);
        if (createdId == null) {
            throw new PersistenceException("Identity can't be created!");
        }
        locker.setObject(tx, fields);
        oid.setDbLock(true);
        if (object instanceof TimeStampable) {
            ((TimeStampable)object).jdoSetTimeStamp(locker.getTimeStamp());
        }
        this.setIdentity(tx, object, createdId);
        for (i = 0; i < this._fhs.length; ++i) {
            fields[i] = this._resolvers[i].postCreate(tx, oid, object, fields[i], createdId);
        }
        return createdId;
    }

    public void markCreate(TransactionContext tx, OID oid, DepositBox locker, Object object) throws DuplicateIdentityException, PersistenceException {
        boolean updateCache = false;
        this.resetResolvers();
        for (int i = 0; i < this._fhs.length; ++i) {
            updateCache |= this._resolvers[i].markCreate(tx, oid, object);
        }
        tx.markModified(object, false, updateCache);
    }

    public boolean preStore(TransactionContext tx, OID oid, DepositBox locker, Object object, int timeout) throws PersistenceException {
        if (oid.getIdentity() == null) {
            throw new PersistenceException("The identity of the object to be stored is null");
        }
        if (!oid.getIdentity().equals(this.getIdentity(tx, object))) {
            throw new PersistenceException(Messages.format("jdo.identityChanged", this._name, oid.getIdentity(), this.getIdentity(tx, object)));
        }
        Object[] fields = (Object[])locker.getObject(tx);
        if (fields == null) {
            throw new PersistenceException("Object, " + oid + ",  isn't loaded in the persistence storage!");
        }
        Object[] newfields = new Object[this._fhs.length];
        boolean updateCache = false;
        boolean updatePersist = false;
        for (int i = 0; i < newfields.length; ++i) {
            UpdateFlags flags = this._resolvers[i].preStore(tx, oid, object, timeout, fields[i]);
            updateCache |= flags.getUpdateCache();
            updatePersist |= flags.getUpdatePersist();
            newfields[i] = flags.getNewField();
        }
        tx.markModified(object, updatePersist, updateCache);
        if (updateCache || updatePersist) {
            tx.writeLock(object, timeout);
        }
        return updateCache;
    }

    public void store(TransactionContext tx, OID oid, DepositBox locker, Object object) throws DuplicateIdentityException, PersistenceException, ObjectModifiedException, ObjectDeletedException {
        if (oid.getIdentity() == null) {
            throw new PersistenceException("The identities of the object to be stored is null");
        }
        if (!oid.getIdentity().equals(this.getIdentity(tx, object))) {
            throw new PersistenceException("Identities changes is not allowed!");
        }
        Object[] fields = (Object[])locker.getObject(tx);
        if (fields == null) {
            throw new PersistenceException("Object, " + oid + ",  isn't loaded in the persistence storage!");
        }
        Object[] newfields = new Object[this._fhs.length];
        for (int i = 0; i < newfields.length; ++i) {
            newfields[i] = this._resolvers[i].store(tx, object, fields[i]);
        }
        Object stamp = this._persistence.store(tx.getConnection(oid.getLockEngine()), newfields, oid.getIdentity(), fields, oid.getStamp());
        oid.setStamp(stamp);
    }

    public boolean update(TransactionContext tx, OID oid, DepositBox locker, Object object, AccessMode suggestedAccessMode) throws PersistenceException, ObjectModifiedException {
        long objectTimestamp;
        AccessMode accessMode = this.getAccessMode(suggestedAccessMode);
        this.resetResolvers();
        Object[] fields = (Object[])locker.getObject(tx);
        if (!this.isDependent() && !this._timeStampable) {
            throw new IllegalArgumentException("A master object that involves in a long transaction must be a TimeStampable!");
        }
        long lockTimestamp = locker.getTimeStamp();
        long l = objectTimestamp = this._timeStampable ? ((TimeStampable)object).jdoGetTimeStamp() : 1L;
        if (objectTimestamp > 0L && oid.getIdentity() != null) {
            if (this._timeStampable && lockTimestamp == 0L) {
                _log.warn((Object)Messages.format("persist.objectNotInCache", this._name, oid.getIdentity()));
                throw new PersistenceException(Messages.format("persist.objectNotInCache", this._name, oid.getIdentity()));
            }
            if (this._timeStampable && objectTimestamp != lockTimestamp) {
                throw new ObjectModifiedException("Timestamp mismatched!");
            }
            if (!this._timeStampable && this.isDependent() && fields == null) {
                fields = new Object[this._fhs.length];
                Connection conn = tx.getConnection(oid.getLockEngine());
                ProposedObject proposedObject = new ProposedObject();
                proposedObject.setProposedClass(object.getClass());
                proposedObject.setObject(object);
                proposedObject.setFields(fields);
                Object stamp = this._persistence.load(conn, proposedObject, oid.getIdentity(), accessMode);
                fields = proposedObject.getFields();
                oid.setDbLock(accessMode == AccessMode.DbLocked);
                locker.setObject(tx, fields);
            }
            try {
                for (int i = 0; i < this._fhs.length; ++i) {
                    this._resolvers[i].update(tx, oid, object, accessMode, fields[i]);
                }
            }
            catch (ObjectNotFoundException e) {
                e.printStackTrace();
                throw new ObjectModifiedException("dependent object deleted concurrently");
            }
            return false;
        }
        if (objectTimestamp == 0L || objectTimestamp == 1L) {
            boolean updateCache = false;
            block9: for (int i = 0; i < this._fhs.length; ++i) {
                short fieldType = this._fhs[i].getFieldType();
                switch (fieldType) {
                    case 0: 
                    case 1: {
                        continue block9;
                    }
                    case 2: {
                        boolean creating;
                        ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                        LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                        Object o = this._fhs[i].getValue(object, tx.getClassLoader());
                        if (o == null) continue block9;
                        if (this._fhs[i].isDependent()) {
                            if (tx.isRecorded(o)) continue block9;
                            tx.markCreate(fieldEngine, fieldClassMolder, o, oid);
                            if (this._fhs[i].isStored() || !fieldClassMolder._isKeyGenUsed) continue block9;
                            updateCache = true;
                            continue block9;
                        }
                        if (!tx.isAutoStore() || tx.isRecorded(o) || !(creating = tx.markUpdate(fieldEngine, fieldClassMolder, o, null)) || this._fhs[i].isStored() || !fieldClassMolder._isKeyGenUsed) continue block9;
                        updateCache = true;
                        continue block9;
                    }
                    case 3: {
                        boolean creating;
                        Object oo;
                        ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                        LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                        Object o = this._fhs[i].getValue(object, tx.getClassLoader());
                        if (o == null) continue block9;
                        Iterator itor = ClassMolderHelper.getIterator(o);
                        while (itor.hasNext()) {
                            oo = itor.next();
                            if (this._fhs[i].isDependent()) {
                                if (!tx.isRecorded(oo)) {
                                    tx.markCreate(fieldEngine, fieldClassMolder, oo, oid);
                                    if (!fieldClassMolder._isKeyGenUsed) continue;
                                    updateCache = true;
                                    continue;
                                }
                                if (tx.isDepended(oid, oo)) continue;
                                throw new PersistenceException("Dependent object may not change its master");
                            }
                            if (!tx.isAutoStore() || tx.isRecorded(oo) || !(creating = tx.markUpdate(fieldEngine, fieldClassMolder, oo, null)) || !fieldClassMolder._isKeyGenUsed) continue;
                            updateCache = true;
                        }
                        continue block9;
                    }
                    case 4: {
                        boolean creating;
                        Object oo;
                        ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                        LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                        Object o = this._fhs[i].getValue(object, tx.getClassLoader());
                        if (o == null) continue block9;
                        Iterator itor = ClassMolderHelper.getIterator(o);
                        while (itor.hasNext()) {
                            oo = itor.next();
                            if (!tx.isAutoStore() || tx.isRecorded(oo) || !(creating = tx.markUpdate(fieldEngine, fieldClassMolder, oo, null))) continue;
                            updateCache = true;
                        }
                        continue block9;
                    }
                }
            }
            tx.markModified(object, false, updateCache);
            return true;
        }
        _log.warn((Object)("object: " + object + " timestamp: " + objectTimestamp + " lockertimestamp: " + lockTimestamp));
        throw new ObjectModifiedException("Invalid object timestamp detected.");
    }

    public void updateCache(TransactionContext tx, OID oid, DepositBox locker, Object object) {
        this.resetResolvers();
        if (oid.getIdentity() == null) {
            throw new IllegalStateException("The identities of the cache to be updated is null");
        }
        Object[] fields = new Object[this._fhs.length];
        block3: for (int i = 0; i < this._fhs.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    fields[i] = this._resolvers[i].updateCache(tx, oid, object);
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException("Field type invalid!");
                }
            }
        }
        locker.setObject(tx, fields);
        if (object instanceof TimeStampable) {
            ((TimeStampable)object).jdoSetTimeStamp(locker.getTimeStamp());
        }
    }

    public void delete(TransactionContext tx, OID oid) throws PersistenceException {
        this.resetResolvers();
        Object ids = oid.getIdentity();
        for (int i = 0; i < this._fhs.length; ++i) {
            if (!this._fhs[i].isManyToMany()) continue;
            this._fhs[i].getRelationLoader().deleteRelation(tx.getConnection(oid.getLockEngine()), ids);
        }
        this._persistence.delete(tx.getConnection(oid.getLockEngine()), ids);
        Vector<ClassMolder> extendPath = new Vector<ClassMolder>();
        ClassMolder base = this;
        while (base != null) {
            extendPath.add(base);
            base = base._extends;
        }
        base = this._depends;
        while (base != null) {
            if (base._extendent != null) {
                for (int i = 0; i < base._extendent.size(); ++i) {
                    if (!extendPath.contains(base._extendent.get(i))) continue;
                }
            }
            base = base._extends;
        }
    }

    public void markDelete(TransactionContext tx, OID oid, DepositBox locker, Object object) throws ObjectNotFoundException, PersistenceException {
        this.resetResolvers();
        Object[] fields = (Object[])locker.getObject(tx);
        block3: for (int i = 0; i < this._fhs.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this._resolvers[i].markDelete(tx, object, fields[i]);
                    continue block3;
                }
                default: {
                    throw new PersistenceException("Invalid field type!");
                }
            }
        }
    }

    public void revertObject(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
        this.resetResolvers();
        if (oid.getIdentity() == null) {
            throw new PersistenceException("The identities of the object to be revert is null");
        }
        Object[] fields = (Object[])locker.getObject(tx);
        this.setIdentity(tx, object, oid.getIdentity());
        for (int i = 0; i < this._fhs.length; ++i) {
            if (fields != null) {
                this._resolvers[i].revertObject(tx, oid, object, fields[i]);
                continue;
            }
            this._resolvers[i].revertObject(tx, oid, object, null);
        }
    }

    public void writeLock(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
    }

    public Object newInstance(ClassLoader loader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (loader != null) {
            return loader.loadClass(this._name).newInstance();
        }
        return Class.forName(this._name).newInstance();
    }

    public AccessMode getAccessMode(AccessMode txMode) {
        if (txMode == null) {
            return this._accessMode;
        }
        if (this._accessMode == AccessMode.ReadOnly || txMode == AccessMode.ReadOnly) {
            return AccessMode.ReadOnly;
        }
        if (this._accessMode == AccessMode.DbLocked || txMode == AccessMode.DbLocked) {
            return AccessMode.DbLocked;
        }
        if (this._accessMode == AccessMode.Exclusive || txMode == AccessMode.Exclusive) {
            return AccessMode.Exclusive;
        }
        return txMode;
    }

    public CallbackInterceptor getCallback() {
        return this._callback;
    }

    public boolean isDefaultIdentity(Object identity) {
        if (this._ids.length == 1) {
            return this._ids[0].isDefault(identity);
        }
        if (identity == null) {
            return true;
        }
        Complex c = (Complex)identity;
        for (int i = 0; i < c.size(); ++i) {
            if (this._ids[i].isDefault(c.get(i))) continue;
            return false;
        }
        return true;
    }

    public Object getIdentity(TransactionContext tx, Object o) {
        if (this.isKeyGeneratorUsed() && !tx.isPersistent(o) && !tx.isReadOnly(o)) {
            return null;
        }
        return this.getActualIdentity(tx, o);
    }

    public Object getActualIdentity(TransactionContext tx, Object o) {
        return this.getActualIdentity(tx.getClassLoader(), o);
    }

    public Object getActualIdentity(ClassLoader loader, Object o) {
        if (this._ids.length == 1) {
            return this._ids[0].getValue(o, loader);
        }
        if (this._ids.length == 2) {
            Object temp = this._ids[0].getValue(o, loader);
            return temp == null ? null : new Complex(temp, this._ids[1].getValue(o, loader));
        }
        Object[] osIds = new Object[this._ids.length];
        for (int i = 0; i < osIds.length; ++i) {
            osIds[i] = this._ids[i].getValue(o, loader);
        }
        if (osIds[0] == null) {
            return null;
        }
        return new Complex(osIds);
    }

    public void setIdentity(TransactionContext tx, Object object, Object identity) throws PersistenceException {
        if (this._ids.length > 1) {
            if (identity instanceof Complex) {
                Complex com = (Complex)identity;
                if (com.size() != this._ids.length) {
                    throw new PersistenceException("Complex size mismatched!");
                }
                for (int i = 0; i < this._ids.length; ++i) {
                    this._ids[i].setValue(object, com.get(i), tx.getClassLoader());
                }
            }
        } else {
            if (identity instanceof Complex) {
                throw new PersistenceException("Complex type not accepted!");
            }
            this._ids[0].setValue(object, identity, tx.getClassLoader());
        }
    }

    public Persistence getPersistence() {
        return this._persistence;
    }

    public void setPersistence(Persistence persist) {
        this._persistence = persist;
    }

    public Class getJavaClass(ClassLoader loader) {
        Class<?> result = null;
        try {
            result = loader != null ? loader.loadClass(this._name) : Class.forName(this._name);
        }
        catch (ClassNotFoundException e) {
            _log.error((Object)("Unable to load base class of " + this.getName()), (Throwable)e);
        }
        return result;
    }

    public boolean isAssignableFrom(Class cls) {
        ClassLoader loader = cls.getClassLoader();
        Class<?> molderClass = null;
        try {
            molderClass = loader != null ? loader.loadClass(this._name) : Class.forName(this._name);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return molderClass.isAssignableFrom(cls);
    }

    public String getName() {
        return this._name;
    }

    public FieldMolder[] getFields() {
        return this._fhs;
    }

    public FieldMolder[] getIds() {
        return this._ids;
    }

    public ClassMolder getExtends() {
        return this._extends;
    }

    public ClassMolder getDepends() {
        return this._depends;
    }

    public LockEngine getLockEngine() {
        return this._engine;
    }

    public String getCacheType() {
        return this._cachetype;
    }

    public int getCacheParam() {
        return this._cacheparam;
    }

    public boolean isDependent() {
        return this._depends != null;
    }

    public void setFieldsNull(Object object) {
    }

    void addExtendent(ClassMolder ext) {
        if (this._extendent == null) {
            this._extendent = new Vector();
        }
        this._extendent.add(ext);
    }

    void addDependent(ClassMolder dep) {
        if (this._dependent == null) {
            this._dependent = new Vector();
        }
        this._dependent.add(dep);
    }

    void setExtends(ClassMolder ext) {
        this._extends = ext;
        ext.addExtendent(this);
    }

    void setDepends(ClassMolder dep) {
        this._depends = dep;
        dep.addDependent(this);
    }

    public String toString() {
        return "ClassMolder " + this._name;
    }

    public boolean isKeyGenUsed() {
        return this._isKeyGenUsed;
    }

    public boolean isKeyGeneratorUsed() {
        return this._isKeyGenUsed || this._extends != null && this._extends.isKeyGeneratorUsed();
    }

    public void expireCache(TransactionContext tx, ObjectLock locker) throws PersistenceException {
        if (locker == null) {
            return;
        }
        Object[] fields = (Object[])locker.getObject();
        if (fields == null) {
            return;
        }
        for (int i = 0; i < this._fhs.length; ++i) {
            this._resolvers[i].expireCache(tx, fields[i]);
        }
    }

    public void resetResolvers() {
        if (!this.resolversHaveBeenReset) {
            for (int i = 0; i < this._fhs.length; ++i) {
                this._resolvers[i] = ResolverFactory.createRelationResolver(this._fhs[i], this, this._debug);
            }
            this.resolversHaveBeenReset = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

