/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.PrintWriter;
import org.exolab.javasource.JAnnotationTypeElement;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNamedMap;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JStructure;
import org.exolab.javasource.JType;

public class JAnnotationType
extends JStructure {
    private JNamedMap _elements = new JNamedMap();

    public JAnnotationType(String name) throws IllegalArgumentException {
        super(name);
        this.getJDocComment().appendComment("Annotation " + this.getLocalName() + ".");
    }

    public void addMember(JMember jMember) throws IllegalArgumentException {
        if (!(jMember instanceof JAnnotationTypeElement)) {
            throw new IllegalArgumentException("Must be a JAnnotationTypeElement.");
        }
        this.addElement((JAnnotationTypeElement)jMember);
    }

    public void addElement(JAnnotationTypeElement jElement) throws IllegalArgumentException {
        if (jElement == null) {
            throw new IllegalArgumentException("Class members cannot be null");
        }
        String name = jElement.getName();
        if (this._elements.get(name) != null) {
            String err = "duplicate name found: " + name;
            throw new IllegalArgumentException(err);
        }
        this._elements.put(name, jElement);
        JType type = jElement.getType();
        while (type.isArray()) {
            type = type.getComponentType();
        }
        if (!type.isPrimitive()) {
            this.addImport(type.getName());
        }
    }

    public JAnnotationTypeElement getElement(String name) {
        return (JAnnotationTypeElement)this._elements.get(name);
    }

    public JAnnotationTypeElement[] getElements() {
        int size = this._elements.size();
        JAnnotationTypeElement[] farray = new JAnnotationTypeElement[size];
        for (int i = 0; i < size; ++i) {
            farray[i] = (JAnnotationTypeElement)this._elements.get(i);
        }
        return farray;
    }

    public void addField(JField jField) throws IllegalArgumentException {
        throw new RuntimeException("Not implemented.");
    }

    public JField getField(String name) {
        throw new RuntimeException("Not implemented.");
    }

    public JField[] getFields() {
        throw new RuntimeException("Not implemented.");
    }

    public void print(JSourceWriter jsw) {
        if (jsw == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        StringBuffer buffer = new StringBuffer();
        this.printHeader(jsw);
        this.printPackageDeclaration(jsw);
        this.printImportDeclarations(jsw);
        this.getJDocComment().print(jsw);
        buffer.setLength(0);
        JModifiers modifiers = this.getModifiers();
        if (modifiers.isPrivate()) {
            buffer.append("private ");
        } else if (modifiers.isPublic()) {
            buffer.append("public ");
        }
        buffer.append("@interface ");
        buffer.append(this.getLocalName());
        buffer.append(' ');
        buffer.append('{');
        jsw.writeln(buffer.toString());
        buffer.setLength(0);
        jsw.writeln();
        jsw.indent();
        for (int i = 0; i < this._elements.size(); ++i) {
            JAnnotationTypeElement jElement = (JAnnotationTypeElement)this._elements.get(i);
            jElement.print(jsw);
            jsw.writeln();
        }
        jsw.unindent();
        jsw.writeln('}');
        jsw.flush();
    }

    public static void main(String[] args) {
        JSourceWriter jsw = new JSourceWriter(new PrintWriter(System.out));
        JAnnotationType annotationType = new JAnnotationType("RequestForEnhancement");
        annotationType.addElement(new JAnnotationTypeElement("id", JType.Int));
        annotationType.addElement(new JAnnotationTypeElement("synopsis", new JType("String")));
        JAnnotationTypeElement enginer = new JAnnotationTypeElement("enginer", new JType("String"));
        enginer.setDefaultString("\"[unassigned]\"");
        annotationType.addElement(enginer);
        JAnnotationTypeElement date = new JAnnotationTypeElement("date", new JType("String"));
        date.setDefaultString("\"[unimplemented]\"");
        annotationType.addElement(date);
        annotationType.print(jsw);
        jsw.flush();
    }
}

