/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.client;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.openejb.loader.OpenEJBInstance;
import org.openejb.loader.SystemInstance;

public class LocalInitialContextFactory
implements InitialContextFactory {
    static Context intraVmContext;
    private static OpenEJBInstance openejb;

    public Context getInitialContext(Hashtable env) throws NamingException {
        if (intraVmContext == null) {
            try {
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)env);
                this.init(properties);
            }
            catch (Exception e) {
                throw (NamingException)new NamingException("Attempted to load OpenEJB. " + e.getMessage()).initCause(e);
            }
            intraVmContext = this.getIntraVmContext(env);
        }
        return intraVmContext;
    }

    public void init(Properties properties) throws Exception {
        if (openejb != null) {
            return;
        }
        SystemInstance.init(properties);
        openejb = new OpenEJBInstance();
        if (openejb.isInitialized()) {
            return;
        }
        openejb.init(properties);
    }

    private Context getIntraVmContext(Hashtable env) throws NamingException {
        Context context = null;
        try {
            InitialContextFactory factory = null;
            ClassLoader cl = SystemInstance.get().getClassLoader();
            Class<?> ivmFactoryClass = Class.forName("org.openejb.core.ivm.naming.InitContextFactory", true, cl);
            factory = (InitialContextFactory)ivmFactoryClass.newInstance();
            context = factory.getInitialContext(env);
        }
        catch (Exception e) {
            throw new NamingException("Cannot instantiate an IntraVM InitialContext. Exception: " + e.getClass().getName() + " " + e.getMessage());
        }
        return context;
    }
}

