/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.loader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openejb.loader.Embedder;
import org.openejb.loader.Loader;
import org.openejb.loader.SystemInstance;

public class LoaderServlet
extends HttpServlet {
    private Loader loader;
    static /* synthetic */ Class class$javax$servlet$ServletConfig;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;

    public void init(ServletConfig config) throws ServletException {
        if (this.loader != null) {
            return;
        }
        Properties p = this.initParamsToProperties(config);
        String embeddingStyle = p.getProperty("openejb.loader");
        if (embeddingStyle.endsWith("tomcat-webapp")) {
            this.setPropertyIfNUll(p, "openejb.base", this.getWebappPath(config));
        }
        try {
            SystemInstance.init(p);
            Embedder embedder = new Embedder("org.openejb.tomcat.TomcatLoader");
            Class loaderClass = embedder.load();
            Object instance = loaderClass.newInstance();
            try {
                this.loader = (Loader)instance;
            }
            catch (ClassCastException e) {
                this.loader = new LoaderWrapper(instance);
            }
            this.loader.init(config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.loader.service(request, response);
    }

    private String getWebappPath(ServletConfig config) {
        ServletContext ctx = config.getServletContext();
        File webInf = new File(ctx.getRealPath("WEB-INF"));
        File webapp = webInf.getParentFile();
        String webappPath = webapp.getAbsolutePath();
        return webappPath;
    }

    private Properties initParamsToProperties(ServletConfig config) {
        Properties p = new Properties();
        p.setProperty("openejb.loader", "tomcat");
        Enumeration enumeration = config.getInitParameterNames();
        System.out.println("OpenEJB init-params:");
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = config.getInitParameter(name);
            p.put(name, value);
            System.out.println("\tparam-name: " + name + ", param-value: " + value);
        }
        return p;
    }

    private Object setPropertyIfNUll(Properties properties, String key, String value) {
        String currentValue = properties.getProperty(key);
        if (currentValue == null) {
            properties.setProperty(key, value);
        }
        return currentValue;
    }

    public static class LoaderWrapper
    implements Loader {
        private final Object loader;
        private final Method init;
        private final Method service;

        public LoaderWrapper(Object loader) {
            this.loader = loader;
            try {
                Class<?> loaderClass = loader.getClass();
                this.init = loaderClass.getMethod("init", class$javax$servlet$ServletConfig == null ? (class$javax$servlet$ServletConfig = LoaderServlet.class$("javax.servlet.ServletConfig")) : class$javax$servlet$ServletConfig);
                this.service = loaderClass.getMethod("service", class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = LoaderServlet.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest, class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = LoaderServlet.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse);
            }
            catch (NoSuchMethodException e) {
                throw (IllegalStateException)new IllegalStateException("Signatures for Loader are no longer correct.").initCause(e);
            }
        }

        public void init(ServletConfig servletConfig) throws ServletException {
            try {
                this.init.invoke(this.loader, servletConfig);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw (ServletException)cause;
            }
            catch (Exception e) {
                throw new RuntimeException("Loader.init: " + e.getMessage() + e.getClass().getName() + ": " + e.getMessage(), e);
            }
        }

        public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            try {
                this.service.invoke(this.loader, request, response);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw (ServletException)cause;
            }
            catch (Exception e) {
                throw new RuntimeException("Loader.service: " + e.getMessage() + e.getClass().getName() + ": " + e.getMessage(), e);
            }
        }
    }
}

