/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Random;

public class FileUtils {
    private static final Random _random = new Random();
    private File home;

    private FileUtils(String homeDir, String defaultDir) {
        this(homeDir, defaultDir, System.getProperties());
    }

    public FileUtils(String homeDir, String defaultDir, Hashtable env) {
        String homePath = null;
        try {
            homePath = (String)env.get(homeDir);
            if (homePath == null) {
                homePath = (String)env.get(defaultDir);
            }
            if (homePath == null) {
                homePath = System.getProperty("user.dir");
            }
            this.home = new File(homePath);
            if (!this.home.exists() || this.home.exists() && !this.home.isDirectory()) {
                homePath = System.getProperty("user.dir");
                this.home = new File(homePath);
            }
            this.home = this.home.getAbsoluteFile();
        }
        catch (SecurityException e) {
            // empty catch block
        }
    }

    public File getDirectory(String path) throws IOException {
        return this.getDirectory(path, false);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileUtils)) {
            return false;
        }
        FileUtils that = (FileUtils)obj;
        return this.getDirectory().equals(that.getDirectory());
    }

    public File getDirectory(String path, boolean create) throws IOException {
        File dir;
        block5: {
            dir = null;
            dir = new File(this.home, path);
            if (!(dir = dir.getCanonicalFile()).exists() && create) {
                try {
                    if (!dir.mkdirs()) {
                        throw new IOException("Cannot create the directory " + dir.getPath());
                    }
                    break block5;
                }
                catch (SecurityException e) {
                    throw new IOException("Permission denied: Cannot create the directory " + dir.getPath() + " : " + e.getMessage());
                }
            }
            if (dir.exists() && !dir.isDirectory()) {
                throw new IOException("The path specified is not a valid directory: " + dir.getPath());
            }
        }
        return dir;
    }

    public File getDirectory() {
        return this.home;
    }

    public void setDirectory(File dir) {
        this.home = dir;
    }

    public File getFile(String path) throws FileNotFoundException, IOException {
        return this.getFile(path, true);
    }

    public File getFile(String path, boolean validate) throws FileNotFoundException, IOException {
        File file = null;
        file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.home, path);
        }
        if (validate && !file.exists()) {
            throw new FileNotFoundException("The path specified is not a valid file: " + file.getPath());
        }
        if (validate && file.isDirectory()) {
            throw new FileNotFoundException("The path specified is a directory, not a file: " + file.getPath());
        }
        return file;
    }

    public static File createTempDirectory(String pathPrefix) throws IOException {
        for (int maxAttempts = 100; maxAttempts > 0; --maxAttempts) {
            String path = pathPrefix + _random.nextLong();
            File tmpDir = new File(path);
            if (tmpDir.exists()) continue;
            tmpDir.mkdir();
            return tmpDir;
        }
        throw new IOException("Can't create temporary directory.");
    }

    public static File createTempDirectory() throws IOException {
        String prefix = System.getProperty("java.io.tmpdir", File.separator + "tmp") + File.separator + "openejb";
        return FileUtils.createTempDirectory(prefix);
    }

    public static void copyFile(File destination, File source) throws IOException {
        FileUtils.copyFile(destination, source, false);
    }

    public static void copyFile(File destination, File source, boolean deleteSourceFile) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = new FileInputStream(source);
            out = new FileOutputStream(destination);
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            in.close();
            out.close();
        }
        if (deleteSourceFile) {
            source.delete();
        }
    }
}

