/*
 * Decompiled with CFR 0.152.
 */
package dynaop.remote;

import dynaop.ProxyFactory;
import dynaop.remote.InvocationHandle;
import dynaop.remote.PatchedObjectInputStream;
import dynaop.util.Classes;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Service
extends HttpServlet {
    Object serviceImplementation;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Object result;
            PatchedObjectInputStream in = new PatchedObjectInputStream((InputStream)request.getInputStream());
            InvocationHandle invocation = (InvocationHandle)in.readObject();
            in.close();
            try {
                result = invocation.invoke(this.serviceImplementation);
            }
            catch (Throwable t) {
                result = t;
            }
            ObjectOutputStream out = new ObjectOutputStream((OutputStream)response.getOutputStream());
            out.writeObject(result);
            out.close();
        }
        catch (ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String className = config.getInitParameter("class");
        if (className == null) {
            throw new ServletException("Specify service implementation class name in 'class' init param.");
        }
        try {
            Class clazz = Classes.forName(className);
            this.serviceImplementation = ProxyFactory.getInstance().wrap(clazz.newInstance());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

