/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObject;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.nanocontainer.NanoContainer;
import org.nanocontainer.reflection.DefaultNanoPicoContainer;
import org.nanocontainer.script.NanoContainerMarkupException;
import org.nanocontainer.script.ScriptedContainerBuilder;
import org.nanocontainer.script.groovy.GroovyCompilationException;
import org.nanocontainer.script.groovy.GroovyNodeBuilder;
import org.picocontainer.PicoContainer;
import org.picocontainer.alternatives.EmptyPicoContainer;

public class GroovyContainerBuilder
extends ScriptedContainerBuilder {
    private Class scriptClass;

    public GroovyContainerBuilder(Reader script, ClassLoader classLoader) {
        super(script, classLoader);
        this.createGroovyClass();
    }

    public GroovyContainerBuilder(URL script, ClassLoader classLoader) {
        super(script, classLoader);
        this.createGroovyClass();
    }

    protected PicoContainer createContainerFromScript(PicoContainer parentContainer, Object assemblyScope) {
        Binding binding = new Binding();
        if (parentContainer == null) {
            parentContainer = new DefaultNanoPicoContainer(this.getClassLoader(), (PicoContainer)new EmptyPicoContainer());
        }
        binding.setVariable("parent", (Object)parentContainer);
        binding.setVariable("builder", (Object)this.createGroovyNodeBuilder());
        binding.setVariable("assemblyScope", assemblyScope);
        this.handleBinding(binding);
        return this.runGroovyScript(binding);
    }

    protected GroovyObject createGroovyNodeBuilder() {
        return new GroovyNodeBuilder();
    }

    protected void handleBinding(Binding binding) {
    }

    private void createGroovyClass() {
        try {
            GroovyClassLoader loader = new GroovyClassLoader(this.getClassLoader());
            InputStream scriptIs = this.getScriptInputStream();
            GroovyCodeSource groovyCodeSource = new GroovyCodeSource(scriptIs, "nanocontainer.groovy", "groovyGeneratedForNanoContainer");
            this.scriptClass = loader.parseClass(groovyCodeSource);
        }
        catch (CompilationFailedException e) {
            throw new GroovyCompilationException("Compilation Failed '" + e.getMessage() + "'", e);
        }
        catch (IOException e) {
            throw new NanoContainerMarkupException((Throwable)e);
        }
    }

    private PicoContainer runGroovyScript(Binding binding) {
        Object picoVariable;
        Script script = this.createGroovyScript(binding);
        Object result = script.run();
        try {
            picoVariable = binding.getVariable("pico");
        }
        catch (MissingPropertyException e) {
            picoVariable = result;
        }
        if (picoVariable == null) {
            throw new NullPointerException("Groovy Script Variable: pico");
        }
        if (picoVariable instanceof PicoContainer) {
            return (PicoContainer)picoVariable;
        }
        if (picoVariable instanceof NanoContainer) {
            return ((NanoContainer)picoVariable).getPico();
        }
        throw new NanoContainerMarkupException("Bad type for pico:" + picoVariable.getClass().getName());
    }

    private Script createGroovyScript(Binding binding) {
        return InvokerHelper.createScript((Class)this.scriptClass, (Binding)binding);
    }
}

