/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script.xml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Permission;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.nanocontainer.ClassNameKey;
import org.nanocontainer.ClassPathElement;
import org.nanocontainer.DefaultNanoContainer;
import org.nanocontainer.NanoContainer;
import org.nanocontainer.integrationkit.ContainerPopulator;
import org.nanocontainer.integrationkit.PicoCompositionException;
import org.nanocontainer.reflection.DefaultNanoPicoContainer;
import org.nanocontainer.script.NanoContainerMarkupException;
import org.nanocontainer.script.ScriptedContainerBuilder;
import org.nanocontainer.script.xml.BeanComponentInstanceFactory;
import org.nanocontainer.script.xml.XMLComponentInstanceFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ComponentMonitorStrategy;
import org.picocontainer.defaults.ComponentParameter;
import org.picocontainer.defaults.ConstantParameter;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.DelegatingComponentMonitor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLContainerBuilder
extends ScriptedContainerBuilder
implements ContainerPopulator {
    private static final String DEFAULT_COMPONENT_ADAPTER_FACTORY = DefaultComponentAdapterFactory.class.getName();
    private static final String DEFAULT_COMPONENT_INSTANCE_FACTORY = BeanComponentInstanceFactory.class.getName();
    private static final String DEFAULT_COMPONENT_MONITOR = DelegatingComponentMonitor.class.getName();
    private static final String CONTAINER = "container";
    private static final String CLASSPATH = "classpath";
    private static final String CLASSLOADER = "classloader";
    private static final String CLASS_NAME_KEY = "class-name-key";
    private static final String COMPONENT = "component";
    private static final String COMPONENT_IMPLEMENTATION = "component-implementation";
    private static final String COMPONENT_INSTANCE = "component-instance";
    private static final String COMPONENT_ADAPTER = "component-adapter";
    private static final String COMPONENT_ADAPTER_FACTORY = "component-adapter-factory";
    private static final String COMPONENT_INSTANCE_FACTORY = "component-instance-factory";
    private static final String COMPONENT_MONITOR = "component-monitor";
    private static final String DECORATING_PICOCONTAINER = "decorating-picocontainer";
    private static final String CLASS = "class";
    private static final String FACTORY = "factory";
    private static final String FILE = "file";
    private static final String KEY = "key";
    private static final String EMPTY_COLLECTION = "empty-collection";
    private static final String COMPONENT_VALUE_TYPE = "component-value-type";
    private static final String COMPONENT_KEY_TYPE = "component-key-type";
    private static final String PARAMETER = "parameter";
    private static final String URL = "url";
    private static final String CLASSNAME = "classname";
    private static final String CONTEXT = "context";
    private static final String VALUE = "value";
    private static final String EMPTY = "";
    private Element rootElement;
    private XMLComponentInstanceFactory componentInstanceFactory;
    static /* synthetic */ Class class$java$security$Permission;

    public XMLContainerBuilder(Reader script, ClassLoader classLoader) {
        super(script, classLoader);
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.parse(documentBuilder, new InputSource(script));
        }
        catch (ParserConfigurationException e) {
            throw new NanoContainerMarkupException(e);
        }
    }

    public XMLContainerBuilder(final URL script, ClassLoader classLoader) {
        super(script, classLoader);
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws IOException {
                    URL url = new URL(script, systemId);
                    return new InputSource(url.openStream());
                }
            });
            this.parse(documentBuilder, new InputSource(script.toString()));
        }
        catch (ParserConfigurationException e) {
            throw new NanoContainerMarkupException(e);
        }
    }

    private void parse(DocumentBuilder documentBuilder, InputSource inputSource) {
        try {
            this.rootElement = documentBuilder.parse(inputSource).getDocumentElement();
        }
        catch (SAXException e) {
            throw new NanoContainerMarkupException(e);
        }
        catch (IOException e) {
            throw new NanoContainerMarkupException(e);
        }
    }

    protected PicoContainer createContainerFromScript(PicoContainer parentContainer, Object assemblyScope) {
        try {
            this.componentInstanceFactory = this.createComponentInstanceFactory(this.rootElement.getAttribute(COMPONENT_INSTANCE_FACTORY));
            MutablePicoContainer childContainer = this.createMutablePicoContainer(this.rootElement.getAttribute(COMPONENT_ADAPTER_FACTORY), this.rootElement.getAttribute(COMPONENT_MONITOR), parentContainer);
            this.populateContainer(childContainer);
            return childContainer;
        }
        catch (ClassNotFoundException e) {
            throw new NanoContainerMarkupException("Class not found:" + e.getMessage(), e);
        }
    }

    private MutablePicoContainer createMutablePicoContainer(String cafName, String monitorName, PicoContainer parentContainer) throws PicoCompositionException, ClassNotFoundException {
        DefaultNanoPicoContainer container = new DefaultNanoPicoContainer(this.getClassLoader(), this.createComponentAdapterFactory(cafName, new DefaultNanoContainer(this.getClassLoader())), parentContainer);
        if (!this.notSet(monitorName)) {
            ComponentMonitor monitor = this.createComponentMonitor(monitorName);
            ((ComponentMonitorStrategy)container).changeMonitor(monitor);
        }
        return container;
    }

    public void populateContainer(MutablePicoContainer container) {
        try {
            String parentClass = this.rootElement.getAttribute("parentclassloader");
            ClassLoader classLoader = this.getClassLoader();
            if (parentClass != null && !EMPTY.equals(parentClass)) {
                classLoader = classLoader.loadClass(parentClass).getClassLoader();
            }
            DefaultNanoContainer nanoContainer = new DefaultNanoContainer(classLoader, container);
            this.registerComponentsAndChildContainers(nanoContainer, this.rootElement, new DefaultNanoContainer(this.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new NanoContainerMarkupException("Class not found: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new NanoContainerMarkupException(e);
        }
        catch (SAXException e) {
            throw new NanoContainerMarkupException(e);
        }
    }

    private void registerComponentsAndChildContainers(NanoContainer parentContainer, Element containerElement, NanoContainer knownComponentAdapterFactories) throws ClassNotFoundException, IOException, SAXException {
        Element childElement;
        String name;
        int i;
        DefaultNanoContainer metaContainer = new DefaultNanoContainer(this.getClassLoader(), knownComponentAdapterFactories.getPico());
        NodeList children = containerElement.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element) || !CLASSPATH.equals(name = (childElement = (Element)children.item(i)).getNodeName())) continue;
            this.registerClasspath(parentContainer, childElement);
        }
        for (i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            childElement = (Element)children.item(i);
            name = childElement.getNodeName();
            if (CONTAINER.equals(name)) {
                MutablePicoContainer childContainer = parentContainer.getPico().makeChildContainer();
                DefaultNanoContainer childNanoContainer = new DefaultNanoContainer(parentContainer.getComponentClassLoader(), childContainer);
                this.registerComponentsAndChildContainers(childNanoContainer, childElement, metaContainer);
                continue;
            }
            if (COMPONENT_IMPLEMENTATION.equals(name) || COMPONENT.equals(name)) {
                this.registerComponentImplementation(parentContainer, childElement);
                continue;
            }
            if (COMPONENT_INSTANCE.equals(name)) {
                this.registerComponentInstance(parentContainer, childElement);
                continue;
            }
            if (COMPONENT_ADAPTER.equals(name)) {
                this.registerComponentAdapter(parentContainer, childElement, metaContainer);
                continue;
            }
            if (COMPONENT_ADAPTER_FACTORY.equals(name)) {
                this.addComponentAdapterFactory(childElement, metaContainer);
                continue;
            }
            if (CLASSLOADER.equals(name)) {
                this.registerClassLoader(parentContainer, childElement, metaContainer);
                continue;
            }
            if (DECORATING_PICOCONTAINER.equals(name)) {
                this.addDecoratingPicoContainer(parentContainer, childElement);
                continue;
            }
            if (CLASSPATH.equals(name)) continue;
            throw new NanoContainerMarkupException("Unsupported element:" + name);
        }
    }

    private void addComponentAdapterFactory(Element element, NanoContainer metaContainer) throws MalformedURLException, ClassNotFoundException {
        if (this.notSet(element.getAttribute(KEY))) {
            throw new NanoContainerMarkupException("'key' attribute not specified for " + element.getNodeName());
        }
        Element node = (Element)element.cloneNode(false);
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element childElement = (Element)children.item(i);
            String name = childElement.getNodeName();
            if (COMPONENT_ADAPTER_FACTORY.equals(name)) {
                if (!EMPTY.equals(childElement.getAttribute(KEY))) {
                    throw new NanoContainerMarkupException("'key' attribute must not be specified for nested " + element.getNodeName());
                }
                childElement = (Element)childElement.cloneNode(true);
                String key = String.valueOf(System.identityHashCode(childElement));
                childElement.setAttribute(KEY, key);
                this.addComponentAdapterFactory(childElement, metaContainer);
                Element parameter = node.getOwnerDocument().createElement(PARAMETER);
                parameter.setAttribute(KEY, key);
                node.appendChild(parameter);
                continue;
            }
            if (!PARAMETER.equals(name)) continue;
            node.appendChild(childElement.cloneNode(true));
        }
        this.registerComponentImplementation(metaContainer, node);
    }

    private void registerClassLoader(NanoContainer parentContainer, Element childElement, NanoContainer metaContainer) throws IOException, SAXException, ClassNotFoundException {
        String parentClass = childElement.getAttribute("parentclassloader");
        ClassLoader parentClassLoader = parentContainer.getComponentClassLoader();
        if (parentClass != null && !EMPTY.equals(parentClass)) {
            parentClassLoader = parentClassLoader.loadClass(parentClass).getClassLoader();
        }
        DefaultNanoContainer nano = new DefaultNanoContainer(parentClassLoader, parentContainer.getPico());
        this.registerComponentsAndChildContainers(nano, childElement, metaContainer);
    }

    private void registerClasspath(NanoContainer container, Element classpathElement) throws IOException, ClassNotFoundException {
        NodeList children = classpathElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element childElement = (Element)children.item(i);
            String fileName = childElement.getAttribute(FILE);
            String urlSpec = childElement.getAttribute(URL);
            URL url = null;
            if (urlSpec != null && !EMPTY.equals(urlSpec)) {
                url = new URL(urlSpec);
            } else {
                File file = new File(fileName);
                if (!file.exists()) {
                    throw new IOException(file.getAbsolutePath() + " doesn't exist");
                }
                url = file.toURL();
            }
            ClassPathElement cpe = container.addClassLoaderURL(url);
            this.registerPermissions(cpe, childElement);
        }
    }

    private void registerPermissions(ClassPathElement classPathElement, Element classPathXmlElement) throws ClassNotFoundException {
        NodeList children = classPathXmlElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element childElement = (Element)children.item(i);
            String permissionClassName = childElement.getAttribute(CLASSNAME);
            String action = childElement.getAttribute(CONTEXT);
            String value = childElement.getAttribute(VALUE);
            DefaultPicoContainer mpc = new DefaultPicoContainer();
            mpc.registerComponentImplementation((Object)(class$java$security$Permission == null ? XMLContainerBuilder.class$("java.security.Permission") : class$java$security$Permission), Class.forName(permissionClassName), new Parameter[]{new ConstantParameter((Object)action), new ConstantParameter((Object)value)});
            Permission permission = (Permission)mpc.getComponentInstanceOfType(class$java$security$Permission == null ? XMLContainerBuilder.class$("java.security.Permission") : class$java$security$Permission);
            classPathElement.grantPermission(permission);
        }
    }

    private void registerComponentImplementation(NanoContainer container, Element element) throws ClassNotFoundException, MalformedURLException {
        String className = element.getAttribute(CLASS);
        if (this.notSet(className)) {
            throw new NanoContainerMarkupException("'class' attribute not specified for " + element.getNodeName());
        }
        Parameter[] parameters = this.createChildParameters(container, element);
        Class<?> clazz = container.getComponentClassLoader().loadClass(className);
        Class<?> key = element.getAttribute(KEY);
        String classKey = element.getAttribute(CLASS_NAME_KEY);
        if (this.notSet(key)) {
            key = !this.notSet(classKey) ? this.getClassLoader().loadClass(classKey) : clazz;
        }
        if (parameters == null) {
            container.getPico().registerComponentImplementation((Object)key, clazz);
        } else {
            container.getPico().registerComponentImplementation((Object)key, clazz, parameters);
        }
    }

    private void addDecoratingPicoContainer(NanoContainer parentContainer, Element childElement) throws ClassNotFoundException {
        String className = childElement.getAttribute(CLASS);
        parentContainer.addDecoratingPicoContainer(this.getClassLoader().loadClass(className));
    }

    private Parameter[] createChildParameters(NanoContainer container, Element element) throws ClassNotFoundException, MalformedURLException {
        ArrayList<Parameter> parametersList = new ArrayList<Parameter>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElement;
            if (!(children.item(i) instanceof Element) || !PARAMETER.equals((childElement = (Element)children.item(i)).getNodeName())) continue;
            parametersList.add(this.createParameter((PicoContainer)container.getPico(), childElement));
        }
        Parameter[] parameters = null;
        if (!parametersList.isEmpty()) {
            parameters = parametersList.toArray(new Parameter[parametersList.size()]);
        }
        return parameters;
    }

    private Parameter createParameter(PicoContainer pico, Element element) throws ClassNotFoundException, MalformedURLException {
        ComponentParameter parameter;
        String key = element.getAttribute(KEY);
        String emptyCollectionString = element.getAttribute(EMPTY_COLLECTION);
        String componentValueTypeString = element.getAttribute(COMPONENT_VALUE_TYPE);
        String componentKeyTypeString = element.getAttribute(COMPONENT_KEY_TYPE);
        if (key != null && !EMPTY.equals(key)) {
            parameter = new ComponentParameter((Object)key);
        } else if (componentKeyTypeString != null && !EMPTY.equals(componentKeyTypeString)) {
            if (emptyCollectionString == null || componentValueTypeString == null || EMPTY.equals(emptyCollectionString) || EMPTY.equals(componentValueTypeString)) {
                throw new NanoContainerMarkupException("The componentKeyType attribute was specified (" + componentKeyTypeString + ") but one or both of the emptyCollection (" + emptyCollectionString + ") or componentValueType (" + componentValueTypeString + ") was empty or null.");
            }
            Class<?> componentKeyType = this.getClassLoader().loadClass(componentKeyTypeString);
            Class<?> componentValueType = this.getClassLoader().loadClass(componentValueTypeString);
            boolean emptyCollection = Boolean.valueOf(emptyCollectionString);
            parameter = new ComponentParameter(componentKeyType, componentValueType, emptyCollection);
        } else if (componentValueTypeString != null && !EMPTY.equals(componentValueTypeString)) {
            if (emptyCollectionString == null || EMPTY.equals(emptyCollectionString)) {
                throw new NanoContainerMarkupException("The componentValueType attribute was specified (" + componentValueTypeString + ") but the emptyCollection (" + emptyCollectionString + ") was empty or null.");
            }
            Class<?> componentValueType = this.getClassLoader().loadClass(componentValueTypeString);
            boolean emptyCollection = Boolean.valueOf(emptyCollectionString);
            parameter = new ComponentParameter(componentValueType, emptyCollection);
        } else if (emptyCollectionString != null && !EMPTY.equals(emptyCollectionString)) {
            boolean emptyCollection = Boolean.valueOf(emptyCollectionString);
            parameter = new ComponentParameter(emptyCollection);
        } else if (this.getFirstChildElement(element, false) == null) {
            parameter = new ComponentParameter();
        } else {
            Object instance = this.createInstance(pico, element);
            parameter = new ConstantParameter(instance);
        }
        return parameter;
    }

    private void registerComponentInstance(NanoContainer container, Element element) throws ClassNotFoundException, PicoCompositionException, MalformedURLException {
        Object instance = this.createInstance((PicoContainer)container.getPico(), element);
        String key = element.getAttribute(KEY);
        String classKey = element.getAttribute(CLASS_NAME_KEY);
        if (this.notSet(key)) {
            if (!this.notSet(classKey)) {
                container.getPico().registerComponentInstance(this.getClassLoader().loadClass(classKey), instance);
            } else {
                container.getPico().registerComponentInstance(instance);
            }
        } else {
            container.getPico().registerComponentInstance((Object)key, instance);
        }
    }

    private Object createInstance(PicoContainer pico, Element element) throws ClassNotFoundException, MalformedURLException {
        XMLComponentInstanceFactory factory = this.createComponentInstanceFactory(element.getAttribute(FACTORY));
        Element instanceElement = this.getFirstChildElement(element, true);
        return factory.makeInstance(pico, instanceElement, this.getClassLoader());
    }

    private Element getFirstChildElement(Element parent, boolean fail) {
        NodeList children = parent.getChildNodes();
        Element child = null;
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            child = (Element)children.item(i);
            break;
        }
        if (child == null && fail) {
            throw new NanoContainerMarkupException(parent.getNodeName() + " needs a child element");
        }
        return child;
    }

    private XMLComponentInstanceFactory createComponentInstanceFactory(String factoryClass) throws ClassNotFoundException {
        if (this.notSet(factoryClass)) {
            if (this.componentInstanceFactory != null) {
                return this.componentInstanceFactory;
            }
            factoryClass = DEFAULT_COMPONENT_INSTANCE_FACTORY;
        }
        DefaultNanoContainer adapter = new DefaultNanoContainer(this.getClassLoader());
        adapter.registerComponentImplementation(XMLComponentInstanceFactory.class.getName(), factoryClass);
        return (XMLComponentInstanceFactory)adapter.getPico().getComponentInstances().get(0);
    }

    private void registerComponentAdapter(NanoContainer container, Element element, NanoContainer metaContainer) throws ClassNotFoundException, PicoCompositionException, MalformedURLException {
        String className = element.getAttribute(CLASS);
        if (this.notSet(className)) {
            throw new NanoContainerMarkupException("'class' attribute not specified for " + element.getNodeName());
        }
        Class<?> implementationClass = this.getClassLoader().loadClass(className);
        Class<?> key = element.getAttribute(KEY);
        String classKey = element.getAttribute(CLASS_NAME_KEY);
        if (this.notSet(key)) {
            key = !this.notSet(classKey) ? this.getClassLoader().loadClass(classKey) : implementationClass;
        }
        Parameter[] parameters = this.createChildParameters(container, element);
        ComponentAdapterFactory componentAdapterFactory = this.createComponentAdapterFactory(element.getAttribute(FACTORY), metaContainer);
        container.getPico().registerComponent(componentAdapterFactory.createComponentAdapter(key, implementationClass, parameters));
    }

    private ComponentAdapterFactory createComponentAdapterFactory(String factoryName, NanoContainer metaContainer) throws ClassNotFoundException, PicoCompositionException {
        Object key;
        if (this.notSet(factoryName)) {
            factoryName = DEFAULT_COMPONENT_ADAPTER_FACTORY;
        }
        if (metaContainer.getPico().getComponentAdapter((Object)factoryName) != null) {
            key = factoryName;
        } else {
            metaContainer.registerComponentImplementation(new ClassNameKey(ComponentAdapterFactory.class.getName()), factoryName);
            key = ComponentAdapterFactory.class;
        }
        return (ComponentAdapterFactory)metaContainer.getPico().getComponentInstance(key);
    }

    private ComponentMonitor createComponentMonitor(String monitorName) throws ClassNotFoundException, PicoCompositionException {
        if (this.notSet(monitorName)) {
            monitorName = DEFAULT_COMPONENT_MONITOR;
        }
        Class<?> monitorClass = this.getClassLoader().loadClass(monitorName);
        try {
            return (ComponentMonitor)monitorClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new NanoContainerMarkupException(e);
        }
        catch (IllegalAccessException e) {
            throw new NanoContainerMarkupException(e);
        }
    }

    private boolean notSet(Object string) {
        return string == null || string.equals(EMPTY);
    }
}

