/*
 * Decompiled with CFR 0.152.
 */
package groovy.swing.factory;

import groovy.swing.SwingBuilder;
import groovy.swing.factory.Factory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;

public class RichActionWidgetFactory
implements Factory {
    static final Class[] ACTION_ARGS = new Class[]{Action.class};
    static final Class[] ICON_ARGS = new Class[]{Icon.class};
    static final Class[] STRING_ARGS = new Class[]{String.class};
    Constructor actionCtor;
    Constructor iconCtor;
    Constructor stringCtor;
    Class klass;

    public RichActionWidgetFactory(Class klass) {
        try {
            this.actionCtor = klass.getConstructor(ACTION_ARGS);
            this.iconCtor = klass.getConstructor(ICON_ARGS);
            this.stringCtor = klass.getConstructor(STRING_ARGS);
            this.klass = klass;
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger("global").log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger("global").log(Level.SEVERE, null, ex);
        }
    }

    public Object newInstance(SwingBuilder builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
        try {
            if (value == null) {
                return this.klass.newInstance();
            }
            if (value instanceof Action) {
                return this.actionCtor.newInstance(value);
            }
            if (value instanceof Icon) {
                return this.iconCtor.newInstance(value);
            }
            if (value instanceof String) {
                return this.stringCtor.newInstance(value);
            }
            if (this.klass.isAssignableFrom(value.getClass())) {
                return value;
            }
            throw new RuntimeException(name + " can only have a value argument of type javax.swing.Action, javax.swing.Icon, java.lang.String, or " + this.klass.getName());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed to create component for '" + name + "' reason: " + e, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to create component for '" + name + "' reason: " + e, e);
        }
    }
}

