/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.webcontainer;

import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.nio.BlockingChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.nanocontainer.webcontainer.JettyServerLifecycleException;
import org.nanocontainer.webcontainer.PicoContext;
import org.nanocontainer.webcontainer.PicoWebAppContext;
import org.picocontainer.PicoContainer;
import org.picocontainer.Startable;
import org.picocontainer.alternatives.EmptyPicoContainer;

public class PicoJettyServer
extends EmptyPicoContainer
implements PicoContainer,
Startable {
    private final Server server;
    private final PicoContainer parentContainer;

    public PicoJettyServer(PicoContainer parentContainer) {
        this.parentContainer = parentContainer;
        this.server = new Server();
        this.server.setHandler((Handler)new HandlerList());
    }

    public PicoJettyServer(String host, int port, PicoContainer parentContainer) {
        this(parentContainer);
        this.createBlockingChannelConnector(host, port);
    }

    public Connector createBlockingChannelConnector(String host, int port) {
        BlockingChannelConnector connector = new BlockingChannelConnector();
        connector.setHost(host);
        connector.setPort(port);
        this.server.addConnector((Connector)connector);
        return connector;
    }

    public PicoContext createContext(String contextPath, boolean withSessionHandler) {
        Context context = new Context((HandlerContainer)this.server, contextPath, 1);
        return new PicoContext(context, this.parentContainer, withSessionHandler);
    }

    public PicoWebAppContext addWebApplication(String contextPath, String warFile) {
        PicoWebAppContext context = new PicoWebAppContext(this.parentContainer);
        context.setContextPath(contextPath);
        context.setExtractWAR(true);
        context.setWar(warFile);
        context.setParentLoaderPriority(true);
        this.server.addHandler((Handler)context);
        return context;
    }

    public void start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new JettyServerLifecycleException("Jetty couldn't start", e);
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new JettyServerLifecycleException("Jetty couldn't stop", e);
        }
    }

    public void addRequestLog(RequestLog requestLog) {
        RequestLogHandler handler = new RequestLogHandler();
        handler.setRequestLog(requestLog);
        this.server.addHandler((Handler)handler);
    }
}

