/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.deployer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.nanocontainer.deployer.DeployingFolderListener;
import org.nanocontainer.deployer.FolderContentHandler;
import org.nanocontainer.deployer.FolderListener;

public class DifferenceAnalysingFolderContentHandler
implements FolderContentHandler {
    private final FileObject folder;
    private final FileSystemManager fileSystemManager;
    private FileObject[] lastChildren = new FileObject[0];
    private FolderListener folderListener;

    public DifferenceAnalysingFolderContentHandler(FileObject folder, FileSystemManager fileSystemManager) {
        this.folder = folder;
        this.fileSystemManager = fileSystemManager;
    }

    public void setCurrentChildren(FileObject[] currentChildren) {
        List<FileObject> current = Arrays.asList(currentChildren);
        List<FileObject> last = Arrays.asList(this.lastChildren);
        this.fireFolderAddedMaybe(current, last);
        this.fireFolderRemovedMaybe(current, last);
        this.lastChildren = currentChildren;
    }

    private void fireFolderAddedMaybe(List current, List last) {
        current = new ArrayList(current);
        last = new ArrayList(last);
        current.removeAll(last);
        Iterator iterator = current.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            FileObject folderObject = this.convertToFolder(fileObject);
            if (folderObject == null || this.folderListener == null) continue;
            this.folderListener.folderAdded(folderObject);
        }
    }

    private void fireFolderRemovedMaybe(List current, List last) {
        current = new ArrayList(current);
        last = new ArrayList(last);
        last.removeAll(current);
        Iterator iterator = last.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            FileObject folderObject = this.convertToFolder(fileObject);
            if (folderObject == null || this.folderListener == null) continue;
            this.folderListener.folderRemoved(fileObject);
        }
    }

    private FileObject convertToFolder(FileObject fileObject) {
        FileObject result = null;
        try {
            String extension;
            if (fileObject.getType().equals(FileType.FOLDER)) {
                result = fileObject;
            } else if (fileObject.getType().equals(FileType.FILE) && ((extension = fileObject.getName().getExtension()).equals("zip") || extension.equals("jar"))) {
                String url = "zip:" + fileObject.getURL().getFile();
                result = this.fileSystemManager.resolveFile(url);
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return result;
    }

    public FileObject getFolder() {
        return this.folder;
    }

    public void addFolderListener(FolderListener folderListener) {
        if (this.folderListener != null) {
            throw new IllegalStateException(FolderListener.class.getName() + " already added");
        }
        this.folderListener = folderListener;
    }

    public void removeFolderListener(DeployingFolderListener deployingFolderListener) {
        this.folderListener = null;
    }
}

