/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class ConstantParameter
implements Parameter,
Serializable {
    private final Object value;

    public ConstantParameter(Object value) {
        this.value = value;
    }

    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        return this.value;
    }

    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        try {
            this.verify(container, adapter, expectedType);
            return true;
        }
        catch (PicoIntrospectionException e) {
            return false;
        }
    }

    public void verify(PicoContainer container, ComponentAdapter adapter, Class expectedType) throws PicoException {
        if (!this.checkPrimitive(expectedType) && !expectedType.isInstance(this.value)) {
            throw new PicoIntrospectionException((expectedType != null ? expectedType.getClass().getName() : "null") + " is not assignable from " + (this.value != null ? this.value.getClass().getName() : "null"));
        }
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    private boolean checkPrimitive(Class expectedType) {
        try {
            if (expectedType.isPrimitive()) {
                Field field = this.value.getClass().getField("TYPE");
                Class type = (Class)field.get(this.value);
                return expectedType.isAssignableFrom(type);
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }
}

