/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callback;

import org.jruby.runtime.Arity;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.callback.ReflectionCallback;

public class ReflectionCallbackFactory
extends CallbackFactory {
    private final Class type;

    public ReflectionCallbackFactory(Class type) {
        this.type = type;
    }

    public Callback getMethod(String method) {
        return new ReflectionCallback(this.type, method, NULL_CLASS_ARRAY, false, false, Arity.noArguments(), false);
    }

    public Callback getFastMethod(String method) {
        return new ReflectionCallback(this.type, method, NULL_CLASS_ARRAY, false, false, Arity.noArguments(), true);
    }

    public Callback getMethod(String method, Class arg1) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1}, false, false, Arity.singleArgument(), false);
    }

    public Callback getFastMethod(String method, Class arg1) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1}, false, false, Arity.singleArgument(), true);
    }

    public Callback getMethod(String method, Class arg1, Class arg2) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2}, false, false, Arity.fixed(2), false);
    }

    public Callback getFastMethod(String method, Class arg1, Class arg2) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2}, false, false, Arity.fixed(2), true);
    }

    public Callback getMethod(String method, Class arg1, Class arg2, Class arg3) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2, arg3}, false, false, Arity.fixed(3), false);
    }

    public Callback getFastMethod(String method, Class arg1, Class arg2, Class arg3) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2, arg3}, false, false, Arity.fixed(3), true);
    }

    public Callback getSingletonMethod(String method) {
        return new ReflectionCallback(this.type, method, NULL_CLASS_ARRAY, false, true, Arity.noArguments(), false);
    }

    public Callback getFastSingletonMethod(String method) {
        return new ReflectionCallback(this.type, method, NULL_CLASS_ARRAY, false, true, Arity.noArguments(), true);
    }

    public Callback getSingletonMethod(String method, Class arg1) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1}, false, true, Arity.singleArgument(), false);
    }

    public Callback getFastSingletonMethod(String method, Class arg1) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1}, false, true, Arity.singleArgument(), true);
    }

    public Callback getSingletonMethod(String method, Class arg1, Class arg2) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2}, false, true, Arity.fixed(2), false);
    }

    public Callback getFastSingletonMethod(String method, Class arg1, Class arg2) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2}, false, true, Arity.fixed(2), true);
    }

    public Callback getSingletonMethod(String method, Class arg1, Class arg2, Class arg3) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2, arg3}, false, true, Arity.fixed(3), false);
    }

    public Callback getFastSingletonMethod(String method, Class arg1, Class arg2, Class arg3) {
        return new ReflectionCallback(this.type, method, new Class[]{arg1, arg2, arg3}, false, true, Arity.fixed(3), true);
    }

    public Callback getBlockMethod(String method) {
        return new ReflectionCallback(this.type, method, new Class[]{IRubyObject.class, IRubyObject.class}, false, true, Arity.fixed(2), false);
    }

    public CompiledBlockCallback getBlockCallback(String method) {
        throw new RuntimeException("not implemented");
    }

    public Callback getOptSingletonMethod(String method) {
        return new ReflectionCallback(this.type, method, new Class[]{IRubyObject[].class}, true, true, Arity.optional(), false);
    }

    public Callback getFastOptSingletonMethod(String method) {
        return new ReflectionCallback(this.type, method, new Class[]{IRubyObject[].class}, true, true, Arity.optional(), true);
    }

    public Callback getOptMethod(String method) {
        return new ReflectionCallback(this.type, method, new Class[]{IRubyObject[].class}, true, false, Arity.optional(), false);
    }

    public Callback getFastOptMethod(String method) {
        return new ReflectionCallback(this.type, method, new Class[]{IRubyObject[].class}, true, false, Arity.optional(), true);
    }
}

