/*
 * Decompiled with CFR 0.152.
 */
package dynaop.bsh;

import dynaop.Aspects;
import dynaop.ClassPointcut;
import dynaop.Interceptor;
import dynaop.InterceptorFactory;
import dynaop.MethodPointcut;
import dynaop.MixinFactory;
import dynaop.Pointcuts;
import dynaop.util.Closure;
import java.lang.reflect.Method;
import org.apache.oro.text.regex.MalformedPatternException;

public class BshHelper {
    Aspects aspects;

    public MethodPointcut declaringClass(Object o) throws MalformedPatternException {
        return Pointcuts.declaringClass(this.toClassPointcut(o));
    }

    public MethodPointcut returnType(Object o) throws MalformedPatternException {
        return Pointcuts.returnType(this.toClassPointcut(o));
    }

    public Object union(Object a, Object b) throws MalformedPatternException {
        if (this.ambiguousType(a) && this.ambiguousType(b)) {
            throw new RuntimeException("Can't differentiate between method and class regex.Please use methodSignature() or className().");
        }
        if (this.isClassPointcut(a) && this.isClassPointcut(b)) {
            return Pointcuts.union(this.toClassPointcut(a), this.toClassPointcut(b));
        }
        return Pointcuts.union(this.toMethodPointcut(a), this.toMethodPointcut(b));
    }

    public Object intersection(Object a, Object b) throws MalformedPatternException {
        if (this.ambiguousType(a) && this.ambiguousType(b)) {
            throw new RuntimeException("Can't differentiate between method and class regex.Please use methodSignature() or className().");
        }
        if (this.isClassPointcut(a) && this.isClassPointcut(b)) {
            return Pointcuts.intersection(this.toClassPointcut(a), this.toClassPointcut(b));
        }
        return Pointcuts.intersection(this.toMethodPointcut(a), this.toMethodPointcut(b));
    }

    boolean ambiguousType(Object o) {
        boolean bl = false;
        if (this.isClassPointcut(o) && this.isMethodPointcut(o)) {
            bl = true;
        }
        return bl;
    }

    boolean isClassPointcut(Object o) {
        boolean bl = false;
        if (o instanceof ClassPointcut || o instanceof Class || o instanceof String) {
            bl = true;
        }
        return bl;
    }

    boolean isMethodPointcut(Object o) {
        boolean bl = false;
        if (o instanceof MethodPointcut || o instanceof Method || o instanceof String) {
            bl = true;
        }
        return bl;
    }

    public void mixin(Object classPointcut, Class[] interfaces, Class mixin, Closure initializer) throws MalformedPatternException {
        this.aspects.mixin(this.toClassPointcut(classPointcut), interfaces, mixin, initializer);
    }

    public void mixin(Object classPointcut, Class[] interfaces, Class mixin) throws MalformedPatternException {
        this.aspects.mixin(this.toClassPointcut(classPointcut), interfaces, mixin, null);
    }

    public void mixin(Object classPointcut, Class[] interfaces, MixinFactory mixinFactory) throws MalformedPatternException {
        this.aspects.mixin(this.toClassPointcut(classPointcut), interfaces, mixinFactory);
    }

    public void mixin(Object classPointcut, Class mixin, Closure initializer) throws MalformedPatternException {
        this.aspects.mixin(this.toClassPointcut(classPointcut), mixin, initializer);
    }

    public void mixin(Object classPointcut, Class mixin) throws MalformedPatternException {
        this.aspects.mixin(this.toClassPointcut(classPointcut), mixin, null);
    }

    public void interfaces(Object classPointcut, Class[] interfaces) throws MalformedPatternException {
        this.aspects.interfaces(this.toClassPointcut(classPointcut), interfaces);
    }

    public void interceptor(Object classPointcut, Object methodPointcut, Class interceptorClass, Closure initializer) throws MalformedPatternException {
        this.aspects.interceptor(this.toClassPointcut(classPointcut), this.toMethodPointcut(methodPointcut), interceptorClass, initializer);
    }

    public void interceptor(Object classPointcut, Object methodPointcut, Class interceptorClass) throws MalformedPatternException {
        this.aspects.interceptor(this.toClassPointcut(classPointcut), this.toMethodPointcut(methodPointcut), interceptorClass, null);
    }

    public void interceptor(Object classPointcut, Object methodPointcut, Interceptor interceptor) throws MalformedPatternException {
        this.aspects.interceptor(this.toClassPointcut(classPointcut), this.toMethodPointcut(methodPointcut), interceptor);
    }

    public void interceptor(Object classPointcut, Object methodPointcut, InterceptorFactory interceptorFactory) throws MalformedPatternException {
        this.aspects.interceptor(this.toClassPointcut(classPointcut), this.toMethodPointcut(methodPointcut), interceptorFactory);
    }

    ClassPointcut toClassPointcut(Object o) throws MalformedPatternException {
        if (o instanceof ClassPointcut) {
            return (ClassPointcut)o;
        }
        if (o instanceof Class) {
            return Pointcuts.instancesOf((Class)o);
        }
        if (o instanceof String) {
            return Pointcuts.className((String)o);
        }
        throw new IllegalArgumentException("Can't convert " + o + " to ClassPointcut.");
    }

    MethodPointcut toMethodPointcut(Object o) throws MalformedPatternException {
        if (o instanceof MethodPointcut) {
            return (MethodPointcut)o;
        }
        if (o instanceof Method) {
            return Pointcuts.singleton((Method)o);
        }
        if (o instanceof String) {
            return Pointcuts.signature((String)o);
        }
        throw new IllegalArgumentException("Can't convert " + o + " to MethodPointcut.");
    }

    BshHelper(Aspects aspects) {
        this.aspects = aspects;
    }
}

