/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer;

import java.io.Serializable;
import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.List;

public class ClassPathElement
implements Serializable {
    private final URL url;
    private PermissionCollection permissionCollection;
    private final List permissions = new ArrayList();

    public ClassPathElement(URL url) {
        this.url = url;
    }

    public Permission grantPermission(Permission permission) {
        if (permission == null) {
            throw new NullPointerException();
        }
        this.permissions.add(permission);
        return permission;
    }

    public URL getUrl() {
        return this.url;
    }

    public PermissionCollection getPermissionCollection() {
        if (this.permissionCollection == null) {
            this.permissionCollection = new Permissions();
            for (int i = 0; i < this.permissions.size(); ++i) {
                Permission permission = (Permission)this.permissions.get(i);
                this.permissionCollection.add(permission);
            }
        }
        return this.permissionCollection;
    }

    public String toString() {
        return "[" + System.identityHashCode(this) + " " + this.url + " " + this.permissions.size() + "]";
    }
}

