/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script;

import org.picocontainer.PicoException;

public class UnsupportedScriptTypeException
extends PicoException {
    private final String specifiedFileExtension;
    private final String[] allSupportedFileExtensions;

    public UnsupportedScriptTypeException(String specifiedFileExtension, String[] allSupportedFileExtensions) {
        this.specifiedFileExtension = specifiedFileExtension;
        this.allSupportedFileExtensions = allSupportedFileExtensions;
    }

    private String buildExceptionMessage() {
        StringBuffer message = new StringBuffer(48);
        message.append("Unsupported file extension '");
        message.append(this.specifiedFileExtension);
        message.append("'.  Supported extensions are: [");
        if (this.allSupportedFileExtensions != null) {
            boolean needPipe = false;
            for (int i = 0; i < this.allSupportedFileExtensions.length; ++i) {
                if (needPipe) {
                    message.append("|");
                } else {
                    needPipe = true;
                }
                message.append(this.allSupportedFileExtensions[i]);
            }
            message.append("].");
        } else {
            message.append(" null ");
        }
        return message.toString();
    }

    public String getMessage() {
        return this.buildExceptionMessage();
    }

    public String[] getSystemSupportedExtensions() {
        return this.allSupportedFileExtensions;
    }

    public String getRequestedExtension() {
        return this.specifiedFileExtension;
    }
}

