/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ant;

import groovy.lang.GroovyClassLoader;
import groovyjarjarcommonscli.CommandLine;
import groovyjarjarcommonscli.OptionBuilder;
import groovyjarjarcommonscli.Options;
import groovyjarjarcommonscli.ParseException;
import groovyjarjarcommonscli.PosixParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.listener.AnsiColorLogger;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.codehaus.groovy.ant.LoggingHelper;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.tools.ErrorReporter;
import org.codehaus.groovy.tools.StringHelper;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;
import org.codehaus.groovy.tools.javac.JavaCompiler;
import org.codehaus.groovy.tools.javac.JavaCompilerFactory;

public class Groovyc
extends MatchingTask {
    private final LoggingHelper log = new LoggingHelper((Task)this);
    private Path compileClasspath;
    private Path compileSourcepath;
    private String encoding;
    private Javac javac;
    protected File destDir;
    protected Path src;
    protected CompilerConfiguration configuration = new CompilerConfiguration();
    protected boolean failOnError = true;
    protected boolean listFiles = false;
    protected File[] compileList = new File[0];
    private boolean jointCompilation;

    public static void main(String[] args) {
        String flag;
        Project project = new Project();
        AnsiColorLogger logger = new AnsiColorLogger();
        logger.setMessageOutputLevel(2);
        project.addBuildListener((BuildListener)logger);
        Groovyc compiler = new Groovyc();
        compiler.setProject(project);
        args = compiler.evalCompilerFlags(args);
        String dest = ".";
        String src = ".";
        boolean listFiles = false;
        if (args.length > 0) {
            dest = args[0];
        }
        if (args.length > 1) {
            src = args[1];
        }
        if (args.length > 2 && (flag = args[2]).equalsIgnoreCase("true")) {
            listFiles = true;
        }
        compiler.setSrcdir(new Path(project, src));
        compiler.setDestdir(project.resolveFile(dest));
        compiler.setListfiles(listFiles);
        compiler.execute();
    }

    private String[] evalCompilerFlags(String[] args) {
        CommandLine cli;
        Options options = new Options();
        OptionBuilder.withArgName("property=value");
        OptionBuilder.withValueSeparator('=');
        OptionBuilder.hasArgs(2);
        options.addOption(OptionBuilder.create("J"));
        OptionBuilder.withArgName("property=value");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("F"));
        OptionBuilder.withLongOpt("jointCompilation");
        options.addOption(OptionBuilder.create('j'));
        PosixParser cliParser = new PosixParser();
        try {
            cli = cliParser.parse(options, args);
        }
        catch (ParseException e) {
            throw new BuildException((Throwable)e);
        }
        this.jointCompilation = cli.hasOption('j');
        if (this.jointCompilation) {
            HashMap<String, Object> compilerOptions = new HashMap<String, Object>();
            String[] opts = cli.getOptionValues("J");
            compilerOptions.put("namedValues", opts);
            opts = cli.getOptionValues("F");
            compilerOptions.put("flags", opts);
            compilerOptions.put("stubDir", this.createTempDir());
            this.configuration.setJointCompilationOptions(compilerOptions);
        }
        return cli.getArgs();
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    protected Path recreateSrc() {
        this.src = null;
        return this.createSrc();
    }

    public void setSrcdir(Path srcDir) {
        if (this.src == null) {
            this.src = srcDir;
        } else {
            this.src.append(srcDir);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setVerbose(boolean verbose) {
        this.configuration.setVerbose(verbose);
    }

    public void setStacktrace(boolean stacktrace) {
        this.configuration.setDebug(stacktrace);
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setSourcepath(Path sourcepath) {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = sourcepath;
        } else {
            this.compileSourcepath.append(sourcepath);
        }
    }

    public Path getSourcepath() {
        return this.compileSourcepath;
    }

    public Path createSourcepath() {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = new Path(this.getProject());
        }
        return this.compileSourcepath.createPath();
    }

    public void setSourcepathRef(Reference r) {
        this.createSourcepath().setRefid(r);
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public String createEncoding() {
        if (this.encoding == null) {
            this.encoding = System.getProperty("file.encoding");
        }
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setListfiles(boolean list) {
        this.listFiles = list;
    }

    public boolean getListfiles() {
        return this.listFiles;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setProceed(boolean proceed) {
        this.failOnError = !proceed;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.resetFileLists();
        if (this.javac != null) {
            this.jointCompilation = true;
        }
        String[] list = this.src.list();
        for (int i = 0; i < list.length; ++i) {
            File srcDir = this.getProject().resolveFile(list[i]);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", this.getLocation());
            }
            DirectoryScanner ds = this.getDirectoryScanner(srcDir);
            String[] files = ds.getIncludedFiles();
            this.scanDir(srcDir, this.destDir != null ? this.destDir : srcDir, files);
        }
        this.compile();
    }

    protected void resetFileLists() {
        this.compileList = new File[0];
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        GlobPatternMapper m = new GlobPatternMapper();
        m.setFrom("*.groovy");
        m.setTo("*.class");
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        File[] newFiles = sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)m);
        this.addToCompileList(newFiles);
        if (this.jointCompilation) {
            m.setFrom("*.java");
            m.setTo("*.class");
            newFiles = sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)m);
            this.addToCompileList(newFiles);
        }
    }

    private void addToCompileList(File[] newFiles) {
        if (newFiles.length > 0) {
            File[] newCompileList = new File[this.compileList.length + newFiles.length];
            System.arraycopy(this.compileList, 0, newCompileList, 0, this.compileList.length);
            System.arraycopy(newFiles, 0, newCompileList, this.compileList.length, newFiles.length);
            this.compileList = newCompileList;
        }
    }

    public File[] getFileList() {
        return this.compileList;
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.src.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist or is not a directory", this.getLocation());
        }
        if (this.encoding != null && !Charset.isSupported(this.encoding)) {
            throw new BuildException("encoding \"\" not supported");
        }
    }

    protected void compile() {
        if (this.compileList.length == 0) {
            this.log.info("No sources to compile");
            return;
        }
        this.log.info("Compiling " + this.compileList.length + " source file" + (this.compileList.length == 1 ? "" : "s") + " to " + this.destDir);
        if (this.listFiles) {
            for (int i = 0; i < this.compileList.length; ++i) {
                String filename = this.compileList[i].getAbsolutePath();
                this.log.info("    " + filename);
            }
        }
        try {
            Path classpath = this.getClasspath();
            if (classpath != null) {
                this.configuration.setClasspath(classpath.toString());
            }
            this.configuration.setTargetDirectory(this.destDir);
            if (this.encoding != null) {
                this.configuration.setSourceEncoding(this.encoding);
            }
            CompilationUnit unit = this.makeCompileUnit();
            unit.addSources(this.compileList);
            unit.compile();
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            new ErrorReporter(e, false).write(new PrintWriter(writer));
            String message = writer.toString();
            if (this.failOnError) {
                throw new BuildException(message, (Throwable)e, this.getLocation());
            }
            this.log(message, 0);
        }
    }

    private CompilationUnit makeCompileUnit() {
        if (this.javac != null) {
            HashMap<String, File> compilerOptions = new HashMap<String, File>();
            compilerOptions.put("stubDir", this.createTempDir());
            this.configuration.setJointCompilationOptions(compilerOptions);
            this.jointCompilation = true;
        }
        if (this.jointCompilation) {
            JavaAwareCompilationUnit unit = new JavaAwareCompilationUnit(this.configuration, this.buildClassLoaderFor());
            if (this.javac != null) {
                final JavaCompiler compiler = new JavaCompiler(){

                    public void compile(List files, CompilationUnit cu) {
                        if (Groovyc.this.javac.getClasspath() == null) {
                            Groovyc.this.javac.setClasspath(Groovyc.this.compileClasspath);
                        }
                        if (Groovyc.this.javac.getSourcepath() == null && Groovyc.this.compileSourcepath != null) {
                            Groovyc.this.javac.createSourcepath().add(Groovyc.this.compileSourcepath);
                        }
                        if (Groovyc.this.javac.getEncoding() == null) {
                            Groovyc.this.javac.setEncoding(Groovyc.this.encoding);
                        }
                        Groovyc.this.javac.setDestdir(Groovyc.this.destDir);
                        Path p = Groovyc.this.javac.createSrc();
                        p.add(Groovyc.this.src);
                        Path tmpDir = new Path(Groovyc.this.getProject());
                        File dir = (File)cu.getConfiguration().getJointCompilationOptions().get("stubDir");
                        tmpDir.setLocation(dir);
                        p.add(tmpDir);
                        Groovyc.this.javac.execute();
                    }
                };
                unit.setCompilerFactory(new JavaCompilerFactory(){

                    public JavaCompiler createCompiler(CompilerConfiguration config) {
                        return compiler;
                    }
                });
            }
            return unit;
        }
        return new CompilationUnit(this.configuration, null, this.buildClassLoaderFor());
    }

    protected File createTempDir() {
        File tempFile;
        try {
            tempFile = File.createTempFile("generated-", "java-source");
            tempFile.delete();
            tempFile.mkdirs();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        return tempFile;
    }

    private GroovyClassLoader buildClassLoaderFor() {
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        if (parent instanceof AntClassLoader) {
            AntClassLoader antLoader = (AntClassLoader)parent;
            String[] pathElm = antLoader.getClasspath().split(File.pathSeparator);
            List classpath = this.configuration.getClasspath();
            Iterator iter = classpath.iterator();
            while (iter.hasNext()) {
                String cpEntry = (String)iter.next();
                boolean found = false;
                for (int i = 0; i < pathElm.length; ++i) {
                    if (!cpEntry.equals(pathElm[i])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                antLoader.addPathElement(cpEntry);
            }
        }
        return new GroovyClassLoader(parent, this.configuration);
    }

    public void setJointCompilationOptions(String options) {
        String[] args = StringHelper.tokenizeUnquoted(options);
        this.evalCompilerFlags(args);
    }

    public Javac createJavac() {
        if (this.javac != null) {
            throw new BuildException("nested javac element allowed only once");
        }
        this.javac = new Javac();
        return this.javac;
    }
}

