/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.reflection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nanocontainer.integrationkit.ContainerRecorder;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoException;

public class DefaultContainerRecorder
implements Serializable,
ContainerRecorder {
    private final List invocations = new ArrayList();
    private transient MutablePicoContainer container;
    private final InvocationHandler invocationRecorder = new InvocationRecorder();

    public DefaultContainerRecorder(MutablePicoContainer container) {
        this.container = container;
    }

    public MutablePicoContainer getContainerProxy() {
        return (MutablePicoContainer)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{MutablePicoContainer.class}, this.invocationRecorder);
    }

    public void replay(MutablePicoContainer target) {
        Iterator iter = this.invocations.iterator();
        while (iter.hasNext()) {
            Invocation invocation = (Invocation)iter.next();
            try {
                invocation.invoke(target);
            }
            catch (IllegalAccessException e) {
                throw new PicoException(e){};
            }
            catch (InvocationTargetException e) {
                throw new PicoException(e){};
            }
        }
    }

    private class InvocationRecorder
    implements InvocationHandler,
    Serializable {
        private InvocationRecorder() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
            DefaultContainerRecorder.this.invocations.add(new Invocation(method, args));
            return method.invoke((Object)DefaultContainerRecorder.this.container, args);
        }
    }

    private class Invocation
    implements Serializable {
        private transient Method method;
        private Object[] args;

        Invocation(Method method, Object[] args) {
            this.method = method;
            this.args = args;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeUTF(this.method.getName());
            out.writeObject(this.method.getDeclaringClass());
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            out.writeInt(parameterTypes.length);
            for (int i = 0; i < parameterTypes.length; ++i) {
                out.writeObject(parameterTypes[i]);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            String methodName = in.readUTF();
            Class declaringClass = (Class)in.readObject();
            int n = in.readInt();
            Class[] parameterTypes = new Class[n];
            for (int i = 0; i < n; ++i) {
                parameterTypes[i] = (Class)in.readObject();
            }
            try {
                this.method = declaringClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw new IOException("Couldn't load method " + methodName);
            }
        }

        public void invoke(Object target) throws IllegalAccessException, InvocationTargetException {
            this.method.invoke(target, this.args);
        }
    }
}

