/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.monitors;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.PicoException;
import org.picocontainer.monitors.NullComponentMonitor;

public class LifecycleComponentMonitor
implements ComponentMonitor {
    private final ComponentMonitor delegate;
    private final List lifecycleFailures = new ArrayList();

    public LifecycleComponentMonitor(ComponentMonitor delegate) {
        this.delegate = delegate;
    }

    public LifecycleComponentMonitor() {
        this.delegate = new NullComponentMonitor();
    }

    public void instantiating(Constructor constructor) {
        this.delegate.instantiating(constructor);
    }

    public void instantiated(Constructor constructor, long duration) {
        this.delegate.instantiated(constructor, duration);
    }

    public void instantiated(Constructor constructor, Object instantiated, Object[] parameters, long duration) {
        this.delegate.instantiated(constructor, instantiated, parameters, duration);
    }

    public void instantiationFailed(Constructor constructor, Exception cause) {
        this.delegate.instantiationFailed(constructor, cause);
    }

    public void invoking(Method method, Object instance) {
        this.delegate.invoking(method, instance);
    }

    public void invoked(Method method, Object instance, long duration) {
        this.delegate.invoked(method, instance, duration);
    }

    public void invocationFailed(Method method, Object instance, Exception cause) {
        this.delegate.invocationFailed(method, instance, cause);
    }

    public void lifecycleInvocationFailed(Method method, Object instance, RuntimeException cause) {
        this.lifecycleFailures.add(cause);
        this.delegate.lifecycleInvocationFailed(method, instance, cause);
    }

    public void rethrowLifecycleFailuresException() {
        throw new LifecycleFailuresException(this.lifecycleFailures);
    }

    public class LifecycleFailuresException
    extends PicoException {
        private List lifecycleFailures;

        public LifecycleFailuresException(List lifecycleFailures) {
            this.lifecycleFailures = lifecycleFailures;
        }

        public String getMessage() {
            StringBuffer message = new StringBuffer();
            Iterator i = this.lifecycleFailures.iterator();
            while (i.hasNext()) {
                Exception failure = (Exception)i.next();
                message.append(failure.getMessage()).append(";  ");
            }
            return message.toString();
        }

        public Collection getFailures() {
            return this.lifecycleFailures;
        }
    }
}

