/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.monitors;

import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.monitors.AbstractComponentMonitor;
import org.picocontainer.monitors.DefaultComponentMonitor;

public class WriterComponentMonitor
extends AbstractComponentMonitor {
    private PrintWriter out;
    private final ComponentMonitor delegate;

    public WriterComponentMonitor(Writer out) {
        this.out = new PrintWriter(out);
        this.delegate = new DefaultComponentMonitor();
    }

    public WriterComponentMonitor(Writer out, ComponentMonitor delegate) {
        this.out = new PrintWriter(out);
        this.delegate = delegate;
    }

    public void instantiating(Constructor constructor) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: instantiating {0}", new Object[]{WriterComponentMonitor.toString(constructor)}));
        this.delegate.instantiating(constructor);
    }

    public void instantiated(Constructor constructor, long duration) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: instantiated {0} [{1} ms]", new Object[]{WriterComponentMonitor.toString(constructor), new Long(duration)}));
        this.delegate.instantiated(constructor, duration);
    }

    public void instantiated(Constructor constructor, Object instantiated, Object[] injected, long duration) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: instantiated {0} [{1} ms], component {2}, injected [{3}]", new Object[]{WriterComponentMonitor.toString(constructor), new Long(duration), instantiated.getClass().getName(), WriterComponentMonitor.toString(injected)}));
        this.delegate.instantiated(constructor, instantiated, injected, duration);
    }

    public void instantiationFailed(Constructor constructor, Exception cause) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: instantiation failed: {0}, reason: {1}", new Object[]{WriterComponentMonitor.toString(constructor), cause.getMessage()}));
        this.delegate.instantiationFailed(constructor, cause);
    }

    public void invoking(Method method, Object instance) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: invoking {0} on {1}", new Object[]{WriterComponentMonitor.toString(method), instance}));
        this.delegate.invoking(method, instance);
    }

    public void invoked(Method method, Object instance, long duration) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: invoked {0} on {1} [{2} ms]", new Object[]{WriterComponentMonitor.toString(method), instance, new Long(duration)}));
        this.delegate.invoked(method, instance, duration);
    }

    public void invocationFailed(Method method, Object instance, Exception cause) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: invocation failed: {0} on {1}, reason: {2}", new Object[]{WriterComponentMonitor.toString(method), instance, cause.getMessage()}));
        this.delegate.invocationFailed(method, instance, cause);
    }

    public void lifecycleInvocationFailed(Method method, Object instance, RuntimeException cause) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: lifecycle invocation failed: {0} on {1}, reason: {2}", new Object[]{WriterComponentMonitor.toString(method), instance, cause.getMessage()}));
        this.delegate.lifecycleInvocationFailed(method, instance, cause);
    }
}

