/*
 * Decompiled with CFR 0.152.
 */
package com.ologix.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class PlainCharset
extends Charset {
    public PlainCharset() {
        super("PLAIN", new String[0]);
    }

    public boolean contains(Charset chs) {
        return chs instanceof PlainCharset;
    }

    public CharsetDecoder newDecoder() {
        return new PlainCharsetDecoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new PlainCharsetEncoder(this);
    }

    private static class PlainCharsetEncoder
    extends CharsetEncoder {
        PlainCharsetEncoder(PlainCharset charset) {
            super(charset, 1.0f, 1.0f);
        }

        public CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            while (in.remaining() > 0 && out.remaining() > 0) {
                out.put((byte)in.get());
            }
            if (in.remaining() > 0) {
                return CoderResult.OVERFLOW;
            }
            return CoderResult.UNDERFLOW;
        }
    }

    private static class PlainCharsetDecoder
    extends CharsetDecoder {
        PlainCharsetDecoder(PlainCharset charset) {
            super(charset, 1.0f, 1.0f);
        }

        public CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.remaining() > 0 && out.remaining() > 0) {
                out.put((char)in.get());
            }
            if (in.remaining() > 0) {
                return CoderResult.OVERFLOW;
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

