/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Map;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;

public final class IncludedModuleWrapper
extends RubyClass {
    private RubyModule delegate;

    public IncludedModuleWrapper(IRuby runtime, RubyClass superClass, RubyModule delegate) {
        super(runtime, superClass);
        this.delegate = delegate;
    }

    public IncludedModuleWrapper newIncludeClass(RubyClass superClass) {
        IncludedModuleWrapper includedModule = new IncludedModuleWrapper(this.getRuntime(), superClass, this.getNonIncludedClass());
        if (this.getSuperClass() != null) {
            includedModule.includeModule(this.getSuperClass());
        }
        return includedModule;
    }

    public boolean isModule() {
        return false;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isIncluded() {
        return true;
    }

    public boolean isImmediate() {
        return true;
    }

    public RubyClass getMetaClass() {
        return this.delegate.getMetaClass();
    }

    public void setMetaClass(RubyClass newRubyClass) {
        throw new UnsupportedOperationException("An included class is only a wrapper for a module");
    }

    public Map getMethods() {
        return this.delegate.getMethods();
    }

    public void setMethods(Map newMethods) {
        throw new UnsupportedOperationException("An included class is only a wrapper for a module");
    }

    public Map getInstanceVariables() {
        return this.delegate.getInstanceVariables();
    }

    public void setInstanceVariables(Map newMethods) {
        throw new UnsupportedOperationException("An included class is only a wrapper for a module");
    }

    public String getName() {
        return this.delegate.getName();
    }

    public RubyModule getNonIncludedClass() {
        return this.delegate;
    }

    public RubyClass getRealClass() {
        return this.getSuperClass().getRealClass();
    }

    public boolean isSame(RubyModule module) {
        return this.delegate.isSame(module);
    }

    public RubyFixnum id() {
        return this.delegate.id();
    }
}

