/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jruby.IRuby;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubyBignum
extends RubyInteger {
    private static final int BIT_SIZE = 64;
    private static final long MAX = 0x3FFFFFFFFFFFFFFFL;
    private static final BigInteger LONG_MAX;
    private static final BigInteger LONG_MIN;
    private final BigInteger value;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RubyBignum(IRuby runtime, BigInteger value) {
        super(runtime, runtime.getClass("Bignum"));
        this.value = value;
    }

    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    public long getLongValue() {
        long result = this.getTruncatedLongValue();
        if (!BigInteger.valueOf(result).equals(this.value)) {
            throw this.getRuntime().newRangeError("bignum too big to convert into 'int'");
        }
        return result;
    }

    public long getTruncatedLongValue() {
        return this.value.longValue();
    }

    public BigInteger getValue() {
        return this.value;
    }

    private static RubyInteger bigNorm(IRuby runtime, BigInteger bi) {
        if (bi.compareTo(LONG_MIN) < 0 || bi.compareTo(LONG_MAX) > 0) {
            return RubyBignum.newBignum(runtime, bi);
        }
        return runtime.newFixnum(bi.longValue());
    }

    public static BigInteger bigIntValue(RubyNumeric other) {
        if (!$assertionsDisabled && other instanceof RubyFloat) {
            throw new AssertionError((Object)"argument must be an integer");
        }
        return other instanceof RubyBignum ? ((RubyBignum)other).getValue() : BigInteger.valueOf(other.getLongValue());
    }

    protected int compareValue(RubyNumeric other) {
        if (other instanceof RubyFloat) {
            double otherVal = other.getDoubleValue();
            double thisVal = this.getDoubleValue();
            return thisVal > otherVal ? 1 : (thisVal < otherVal ? -1 : 0);
        }
        return this.getValue().compareTo(RubyBignum.bigIntValue(other));
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.hashCode());
    }

    public static RubyBignum newBignum(IRuby runtime, long value) {
        return RubyBignum.newBignum(runtime, BigInteger.valueOf(value));
    }

    public static RubyBignum newBignum(IRuby runtime, double value) {
        return RubyBignum.newBignum(runtime, new BigDecimal(value).toBigInteger());
    }

    public static RubyBignum newBignum(IRuby runtime, BigInteger value) {
        return new RubyBignum(runtime, value);
    }

    public IRubyObject remainder(IRubyObject other) {
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).remainder(other);
        }
        if (other instanceof RubyNumeric) {
            return RubyBignum.bigNorm(this.getRuntime(), this.getValue().remainder(RubyBignum.bigIntValue((RubyNumeric)other)));
        }
        return this.callCoerced("remainder", other);
    }

    public RubyNumeric multiplyWith(RubyInteger other) {
        return RubyBignum.bigNorm(this.getRuntime(), this.getValue().multiply(RubyBignum.bigIntValue(other)));
    }

    public RubyNumeric multiplyWith(RubyFloat other) {
        return other.multiplyWith(RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()));
    }

    public RubyNumeric quo(IRubyObject other) {
        return RubyFloat.newFloat(this.getRuntime(), ((RubyNumeric)this.op_div(other)).getDoubleValue());
    }

    public IRubyObject op_and(IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBignum.bigNorm(this.getRuntime(), this.value.and(((RubyBignum)other).value));
        }
        if (other instanceof RubyNumeric) {
            return RubyBignum.bigNorm(this.getRuntime(), this.getValue().and(RubyBignum.newBignum(this.getRuntime(), ((RubyNumeric)other).getLongValue()).getValue()));
        }
        return this.callCoerced("&", other);
    }

    public IRubyObject op_div(IRubyObject other) {
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_div(other);
        }
        if (other instanceof RubyNumeric) {
            BigInteger otherBig = RubyBignum.bigIntValue((RubyNumeric)other);
            if (otherBig.equals(BigInteger.ZERO)) {
                throw this.getRuntime().newZeroDivisionError();
            }
            BigInteger[] results = this.getValue().divideAndRemainder(otherBig);
            if (results[0].compareTo(BigInteger.ZERO) <= 0 && results[1].compareTo(BigInteger.ZERO) != 0) {
                return RubyBignum.bigNorm(this.getRuntime(), results[0].subtract(BigInteger.ONE));
            }
            return RubyBignum.bigNorm(this.getRuntime(), results[0]);
        }
        return this.callCoerced("/", other);
    }

    public IRubyObject op_invert() {
        return RubyBignum.bigNorm(this.getRuntime(), this.getValue().not());
    }

    public IRubyObject op_lshift(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            long shift = ((RubyNumeric)other).getLongValue();
            if (shift > Integer.MAX_VALUE || shift < Integer.MIN_VALUE) {
                throw this.getRuntime().newRangeError("bignum too big to convert into `int'");
            }
            return new RubyBignum(this.getRuntime(), this.value.shiftLeft((int)shift));
        }
        return this.callCoerced("<<", other);
    }

    public IRubyObject op_minus(IRubyObject other) {
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_minus(other);
        }
        if (other instanceof RubyNumeric) {
            return RubyBignum.bigNorm(this.getRuntime(), this.getValue().subtract(RubyBignum.bigIntValue((RubyNumeric)other)));
        }
        return this.callCoerced("-", other);
    }

    public IRubyObject op_mod(IRubyObject other) {
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).modulo(other);
        }
        if (other instanceof RubyNumeric) {
            BigInteger m = RubyBignum.bigIntValue((RubyNumeric)other);
            BigInteger result = this.getValue().mod(m.abs());
            if (m.compareTo(BigInteger.ZERO) < 0) {
                result = m.add(result);
            }
            return RubyBignum.bigNorm(this.getRuntime(), result);
        }
        return this.callCoerced("%", other);
    }

    public IRubyObject op_mul(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return ((RubyNumeric)other).multiplyWith(this);
        }
        return this.callCoerced("*", other);
    }

    public IRubyObject op_or(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return new RubyBignum(this.getRuntime(), this.value.or(RubyBignum.bigIntValue((RubyNumeric)other)));
        }
        return this.callCoerced("|", other);
    }

    public IRubyObject op_plus(IRubyObject other) {
        if (other instanceof RubyFloat) {
            return ((RubyFloat)other).op_plus(this);
        }
        if (other instanceof RubyNumeric) {
            return RubyBignum.bigNorm(this.getRuntime(), this.getValue().add(RubyBignum.bigIntValue((RubyNumeric)other)));
        }
        return this.callCoerced("+", other);
    }

    public IRubyObject op_pow(IRubyObject other) {
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_pow(other);
        }
        if (other instanceof RubyNumeric) {
            return RubyBignum.bigNorm(this.getRuntime(), this.getValue().pow((int)((RubyNumeric)other).getLongValue()));
        }
        return this.callCoerced("**", other);
    }

    public IRubyObject op_rshift(IRubyObject other) {
        long shift = ((RubyNumeric)other).getLongValue();
        if (shift > Integer.MAX_VALUE || shift < Integer.MIN_VALUE) {
            throw this.getRuntime().newRangeError("bignum too big to convert into `int'");
        }
        if (other instanceof RubyNumeric) {
            return new RubyBignum(this.getRuntime(), this.value.shiftRight((int)shift));
        }
        return this.callCoerced(">>", other);
    }

    public IRubyObject op_uminus() {
        return RubyBignum.bigNorm(this.getRuntime(), this.getValue().negate());
    }

    public IRubyObject op_xor(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return new RubyBignum(this.getRuntime(), this.value.xor(RubyBignum.bigIntValue((RubyNumeric)other)));
        }
        return this.callCoerced("^", other);
    }

    public RubyFixnum aref(IRubyObject other) {
        long pos = other.convertToInteger().getLongValue();
        boolean isSet = this.getValue().testBit((int)pos);
        return this.getRuntime().newFixnum(isSet ? 1L : 0L);
    }

    public IRubyObject to_s(IRubyObject[] args) {
        this.checkArgumentCount(args, 0, 1);
        int radix = args.length == 0 ? 10 : (int)args[0].convertToInteger().getLongValue();
        return this.getRuntime().newString(this.getValue().toString(radix));
    }

    public RubyFloat to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    public RubyNumeric[] getCoerce(RubyNumeric other) {
        if (!(other instanceof RubyInteger)) {
            return new RubyNumeric[]{other, this};
        }
        return new RubyNumeric[]{RubyFloat.newFloat(this.getRuntime(), other.getDoubleValue()), RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue())};
    }

    public RubyFixnum size() {
        int byteLength = this.value.bitLength() / 8;
        if (this.value.bitLength() % 8 != 0) {
            ++byteLength;
        }
        return this.getRuntime().newFixnum(byteLength);
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(108);
        output.write(this.value.signum() >= 0 ? 43 : 45);
        BigInteger absValue = this.value.abs();
        byte[] digits = absValue.toByteArray();
        boolean oddLengthNonzeroStart = digits.length % 2 != 0 && digits[0] != 0;
        int shortLength = digits.length / 2;
        if (oddLengthNonzeroStart) {
            ++shortLength;
        }
        output.dumpInt(shortLength);
        for (int i = 1; i <= shortLength * 2 && i <= digits.length; ++i) {
            output.write(digits[digits.length - i]);
        }
        if (oddLengthNonzeroStart) {
            output.write(0);
        }
    }

    public static RubyBignum unmarshalFrom(UnmarshalStream input) throws IOException {
        boolean positive = input.readUnsignedByte() == 43;
        int shortLength = input.unmarshalInt();
        byte[] digits = new byte[shortLength * 2 + 1];
        for (int i = digits.length - 1; i >= 1; --i) {
            digits[i] = input.readSignedByte();
        }
        BigInteger value = new BigInteger(digits);
        if (!positive) {
            value = value.negate();
        }
        RubyBignum result = RubyBignum.newBignum(input.getRuntime(), value);
        input.registerLinkTarget(result);
        return result;
    }

    public IRubyObject coerce(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.getRuntime().newArray(RubyBignum.newBignum(this.getRuntime(), ((RubyFixnum)other).getLongValue()), this);
        }
        throw this.getRuntime().newTypeError("Can't coerce " + other.getMetaClass().getName() + " to Bignum");
    }

    static {
        $assertionsDisabled = !RubyBignum.class.desiredAssertionStatus();
        LONG_MAX = BigInteger.valueOf(0x3FFFFFFFFFFFFFFFL);
        LONG_MIN = BigInteger.valueOf(-4611686018427387904L);
    }
}

