/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.internal.runtime.methods.MultiStub;
import org.jruby.internal.runtime.methods.MultiStubMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.Iter;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyEnumerable {
    public static IRubyObject callEach(ThreadContext context, IRubyObject self, RubyModule module, BlockCallback bc) {
        Iter bef = context.getFrameIter();
        context.preBlockPassEval(new CallBlock(self, module, Arity.noArguments(), bc, context));
        IRubyObject ret = self.callMethod(context, "each");
        context.postBlockPassEval();
        context.setFrameIter(bef);
        return ret;
    }

    public static List eachToList(ThreadContext context, IRubyObject self, RubyModule module) {
        ListAddBlockCallback ladc = new ListAddBlockCallback(context.getRuntime());
        RubyEnumerable.callEach(context, self, module, ladc);
        return ladc.getList();
    }

    public static RubyModule createEnumerableModule(IRuby runtime) {
        RubyModule enm = runtime.defineModule("Enumerable");
        RubyEnumerableStub0 stub0 = RubyEnumerableStub0.createStub(enm);
        RubyEnumerableStub1 stub1 = RubyEnumerableStub1.createStub(enm);
        enm.addModuleFunction("to_a", stub0.to_a);
        enm.addModuleFunction("entries", stub0.to_a);
        enm.addModuleFunction("sort", stub0.sort);
        enm.addModuleFunction("sort_by", stub0.sort_by);
        enm.addModuleFunction("grep", stub0.grep);
        enm.addModuleFunction("detect", stub0.detect);
        enm.addModuleFunction("find", stub0.detect);
        enm.addModuleFunction("select", stub0.select);
        enm.addModuleFunction("find_all", stub0.select);
        enm.addModuleFunction("reject", stub0.reject);
        enm.addModuleFunction("collect", stub0.collect);
        enm.addModuleFunction("map", stub0.collect);
        enm.addModuleFunction("inject", stub0.inject);
        enm.addModuleFunction("partition", stub0.partition);
        enm.addModuleFunction("each_with_index", stub1.each_with_index);
        enm.addModuleFunction("include?", stub1.include_p);
        enm.addModuleFunction("member?", stub1.include_p);
        enm.addModuleFunction("max", stub1.max);
        enm.addModuleFunction("min", stub1.min);
        enm.addModuleFunction("all?", stub1.all_p);
        enm.addModuleFunction("any?", stub1.any_p);
        enm.addModuleFunction("zip", stub1.zip);
        enm.addModuleFunction("group_by", stub1.group_by);
        return enm;
    }

    public static class RubyEnumerableStub1
    implements MultiStub {
        public final MultiStubMethod each_with_index;
        public final MultiStubMethod include_p;
        public final MultiStubMethod max;
        public final MultiStubMethod min;
        public final MultiStubMethod all_p;
        public final MultiStubMethod any_p;
        public final MultiStubMethod zip;
        public final MultiStubMethod group_by;
        private final RubyModule module;

        public static RubyEnumerableStub1 createStub(RubyModule recv) {
            return new RubyEnumerableStub1(recv);
        }

        private RubyEnumerableStub1(RubyModule recv) {
            this.module = recv;
            this.each_with_index = new MultiStubMethod(this, 0, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.include_p = new MultiStubMethod(this, 1, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.max = new MultiStubMethod(this, 2, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.min = new MultiStubMethod(this, 3, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.all_p = new MultiStubMethod(this, 4, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.any_p = new MultiStubMethod(this, 5, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.zip = new MultiStubMethod(this, 6, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.group_by = new MultiStubMethod(this, 7, recv, Arity.noArguments(), Visibility.PUBLIC);
        }

        public IRubyObject method0(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            int index = 0;
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            IRuby rt = context.getRuntime();
            Iterator iter = arr.iterator();
            while (iter.hasNext()) {
                context.yield(rt.newArray((IRubyObject)iter.next(), rt.newFixnum(index++)));
            }
            return self;
        }

        public IRubyObject method1(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            Iterator iter = arr.iterator();
            while (iter.hasNext()) {
                if (!args[0].callMethod(context, "==", (IRubyObject)iter.next()).isTrue()) continue;
                return context.getRuntime().getTrue();
            }
            return context.getRuntime().getFalse();
        }

        public IRubyObject method2(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            IRubyObject result = null;
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            if (context.isBlockGiven()) {
                Iterator iter = arr.iterator();
                while (iter.hasNext()) {
                    IRubyObject item = (IRubyObject)iter.next();
                    if (result != null && !context.yield(context.getRuntime().newArray(item, result)).callMethod(context, ">", RubyFixnum.zero(context.getRuntime())).isTrue()) continue;
                    result = item;
                }
            } else {
                Iterator iter = arr.iterator();
                while (iter.hasNext()) {
                    IRubyObject item = (IRubyObject)iter.next();
                    if (result != null && !item.callMethod(context, "<=>", result).callMethod(context, ">", RubyFixnum.zero(context.getRuntime())).isTrue()) continue;
                    result = item;
                }
            }
            if (null == result) {
                return context.getRuntime().getNil();
            }
            return result;
        }

        public IRubyObject method3(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            IRubyObject result = null;
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            if (context.isBlockGiven()) {
                Iterator iter = arr.iterator();
                while (iter.hasNext()) {
                    IRubyObject item = (IRubyObject)iter.next();
                    if (result != null && !context.yield(context.getRuntime().newArray(item, result)).callMethod(context, "<", RubyFixnum.zero(context.getRuntime())).isTrue()) continue;
                    result = item;
                }
            } else {
                Iterator iter = arr.iterator();
                while (iter.hasNext()) {
                    IRubyObject item = (IRubyObject)iter.next();
                    if (result != null && !item.callMethod(context, "<=>", result).callMethod(context, "<", RubyFixnum.zero(context.getRuntime())).isTrue()) continue;
                    result = item;
                }
            }
            if (null == result) {
                return context.getRuntime().getNil();
            }
            return result;
        }

        public IRubyObject method4(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            boolean all = true;
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            if (context.isBlockGiven()) {
                Iterator iter = arr.iterator();
                while (iter.hasNext()) {
                    if (context.yield((IRubyObject)iter.next()).isTrue()) continue;
                    all = false;
                    break;
                }
            } else {
                Iterator iter = arr.iterator();
                while (iter.hasNext()) {
                    if (((IRubyObject)iter.next()).isTrue()) continue;
                    all = false;
                    break;
                }
            }
            return all ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
        }

        public IRubyObject method5(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            boolean any = false;
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            if (context.isBlockGiven()) {
                Iterator iter = arr.iterator();
                while (iter.hasNext()) {
                    if (!context.yield((IRubyObject)iter.next()).isTrue()) continue;
                    any = true;
                    break;
                }
            } else {
                Iterator iter = arr.iterator();
                while (iter.hasNext()) {
                    if (!((IRubyObject)iter.next()).isTrue()) continue;
                    any = true;
                    break;
                }
            }
            return any ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
        }

        public IRubyObject method6(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            int ix = 0;
            ArrayList<RubyArray> zip = new ArrayList<RubyArray>(arr.size());
            int aLen = args.length + 1;
            if (context.isBlockGiven()) {
                Iterator iter = arr.iterator();
                while (iter.hasNext()) {
                    IRubyObject elem = (IRubyObject)iter.next();
                    ArrayList<IRubyObject> array = new ArrayList<IRubyObject>(aLen);
                    array.add(elem);
                    int j = args.length;
                    for (int i = 0; i < j; ++i) {
                        array.add(args[i].callMethod(context, "[]", context.getRuntime().newFixnum(ix)));
                    }
                    context.yield(context.getRuntime().newArray(array));
                    ++ix;
                }
                return context.getRuntime().getNil();
            }
            Iterator iter = arr.iterator();
            while (iter.hasNext()) {
                IRubyObject elem = (IRubyObject)iter.next();
                ArrayList<IRubyObject> array = new ArrayList<IRubyObject>(aLen);
                array.add(elem);
                int j = args.length;
                for (int i = 0; i < j; ++i) {
                    array.add(args[i].callMethod(context, "[]", context.getRuntime().newFixnum(ix)));
                }
                zip.add(context.getRuntime().newArray(array));
                ++ix;
            }
            return context.getRuntime().newArray(zip);
        }

        public IRubyObject method7(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            HashMap<IRubyObject, IRubyObject> results = new HashMap<IRubyObject, IRubyObject>(arr.size());
            Iterator iter = arr.iterator();
            while (iter.hasNext()) {
                IRubyObject item = (IRubyObject)iter.next();
                IRubyObject key = context.yield(item);
                IRubyObject curr = (IRubyObject)results.get(key);
                if (curr == null) {
                    curr = context.getRuntime().newArray();
                    results.put(key, curr);
                }
                curr.callMethod(context, "<<", item);
            }
            return new RubyHash(context.getRuntime(), results, context.getRuntime().getNil());
        }

        public IRubyObject method8(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            return null;
        }

        public IRubyObject method9(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            return null;
        }
    }

    public static class RubyEnumerableStub0
    implements MultiStub {
        public final MultiStubMethod to_a;
        public final MultiStubMethod sort;
        public final MultiStubMethod sort_by;
        public final MultiStubMethod grep;
        public final MultiStubMethod detect;
        public final MultiStubMethod select;
        public final MultiStubMethod reject;
        public final MultiStubMethod collect;
        public final MultiStubMethod inject;
        public final MultiStubMethod partition;
        private final RubyModule module;

        public static RubyEnumerableStub0 createStub(RubyModule recv) {
            return new RubyEnumerableStub0(recv);
        }

        private RubyEnumerableStub0(RubyModule recv) {
            this.module = recv;
            this.to_a = new MultiStubMethod(this, 0, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.sort = new MultiStubMethod(this, 1, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.sort_by = new MultiStubMethod(this, 2, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.grep = new MultiStubMethod(this, 3, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.detect = new MultiStubMethod(this, 4, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.select = new MultiStubMethod(this, 5, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.reject = new MultiStubMethod(this, 6, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.collect = new MultiStubMethod(this, 7, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.inject = new MultiStubMethod(this, 8, recv, Arity.noArguments(), Visibility.PUBLIC);
            this.partition = new MultiStubMethod(this, 9, recv, Arity.noArguments(), Visibility.PUBLIC);
        }

        public IRubyObject method0(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            return context.getRuntime().newArray(RubyEnumerable.eachToList(context, self, this.module));
        }

        public IRubyObject method1(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            if (!context.isBlockGiven()) {
                IRubyObject res = self.callMethod(context, "to_a");
                return res.callMethod(context, "sort");
            }
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            Collections.sort(arr, new RubyYieldComparator(context));
            return context.getRuntime().newArray(arr);
        }

        public IRubyObject method2(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            List result = RubyEnumerable.eachToList(context, self, this.module);
            IRubyObject[][] secResult = new IRubyObject[result.size()][2];
            int ix = 0;
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                IRubyObject iro = (IRubyObject)iter.next();
                secResult[ix][0] = context.yield(iro);
                secResult[ix][1] = iro;
                ++ix;
            }
            Arrays.sort(secResult, new RubyFirstArrayComparator());
            IRubyObject[] result2 = new IRubyObject[secResult.length];
            int j = result2.length;
            for (int i = 0; i < j; ++i) {
                result2[i] = secResult[i][1];
            }
            return context.getRuntime().newArray(result2);
        }

        public IRubyObject method3(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            self.checkArgumentCount(args, 1, 1);
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            ArrayList<IRubyObject> result = new ArrayList<IRubyObject>();
            IRubyObject pattern = args[0];
            if (!context.isBlockGiven()) {
                Iterator iter = arr.iterator();
                while (iter.hasNext()) {
                    IRubyObject item = (IRubyObject)iter.next();
                    if (!pattern.callMethod(context, "===", item).isTrue()) continue;
                    result.add(item);
                }
            } else {
                Iterator iter = arr.iterator();
                while (iter.hasNext()) {
                    IRubyObject item = (IRubyObject)iter.next();
                    if (!pattern.callMethod(context, "===", item).isTrue()) continue;
                    result.add(context.yield(item));
                }
            }
            return context.getRuntime().newArray(result);
        }

        public IRubyObject method4(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            Iterator iter = arr.iterator();
            while (iter.hasNext()) {
                IRubyObject element = (IRubyObject)iter.next();
                if (!context.yield(element).isTrue()) continue;
                return element;
            }
            if (args.length > 0 && args[0] instanceof RubyProc) {
                return ((RubyProc)args[0]).call(new IRubyObject[0]);
            }
            return context.getRuntime().getNil();
        }

        public IRubyObject method5(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            ArrayList<IRubyObject> result = new ArrayList<IRubyObject>(arr.size());
            Iterator iter = arr.iterator();
            while (iter.hasNext()) {
                IRubyObject element = (IRubyObject)iter.next();
                if (!context.yield(element).isTrue()) continue;
                result.add(element);
            }
            return context.getRuntime().newArray(result);
        }

        public IRubyObject method6(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            ArrayList<IRubyObject> result = new ArrayList<IRubyObject>(arr.size());
            Iterator iter = arr.iterator();
            while (iter.hasNext()) {
                IRubyObject element = (IRubyObject)iter.next();
                if (context.yield(element).isTrue()) continue;
                result.add(element);
            }
            return context.getRuntime().newArray(result);
        }

        public IRubyObject method7(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            IRubyObject[] result = new IRubyObject[arr.size()];
            if (context.isBlockGiven()) {
                int i = 0;
                Iterator iter = arr.iterator();
                while (iter.hasNext()) {
                    result[i++] = context.yield((IRubyObject)iter.next());
                }
            } else {
                int i = 0;
                Iterator iter = arr.iterator();
                while (iter.hasNext()) {
                    result[i++] = (IRubyObject)iter.next();
                }
            }
            return context.getRuntime().newArray(result);
        }

        public IRubyObject method8(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            IRubyObject result = null;
            if (args.length > 0) {
                result = args[0];
            }
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            Iterator iter = arr.iterator();
            while (iter.hasNext()) {
                IRubyObject item = (IRubyObject)iter.next();
                if (result == null) {
                    result = item;
                    continue;
                }
                result = context.yield(context.getRuntime().newArray(result, item));
            }
            if (null == result) {
                return context.getRuntime().getNil();
            }
            return result;
        }

        public IRubyObject method9(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            List arr = RubyEnumerable.eachToList(context, self, this.module);
            ArrayList<IRubyObject> arr_true = new ArrayList<IRubyObject>(arr.size() / 2);
            ArrayList<IRubyObject> arr_false = new ArrayList<IRubyObject>(arr.size() / 2);
            Iterator iter = arr.iterator();
            while (iter.hasNext()) {
                IRubyObject item = (IRubyObject)iter.next();
                if (context.yield(item).isTrue()) {
                    arr_true.add(item);
                    continue;
                }
                arr_false.add(item);
            }
            return context.getRuntime().newArray(context.getRuntime().newArray(arr_true), context.getRuntime().newArray(arr_false));
        }
    }

    private static class RubyYieldComparator
    implements Comparator {
        private final ThreadContext context;
        private final IRuby runtime;

        public RubyYieldComparator(ThreadContext context) {
            this.context = context;
            this.runtime = context.getRuntime();
        }

        public int compare(Object o1, Object o2) {
            return RubyFixnum.fix2int(this.context.yield(this.runtime.newArray((IRubyObject)o1, (IRubyObject)o2)));
        }
    }

    private static class RubyFirstArrayComparator
    implements Comparator {
        private RubyFirstArrayComparator() {
        }

        public int compare(Object o1, Object o2) {
            IRubyObject obj1 = ((IRubyObject[])o1)[0];
            return RubyFixnum.fix2int(((IRubyObject[])o1)[0].callMethod(obj1.getRuntime().getCurrentContext(), "<=>", ((IRubyObject[])o2)[0]));
        }
    }

    private static class ListAddBlockCallback
    implements BlockCallback {
        private final List arr = new ArrayList();
        private final IRuby runtime;

        public ListAddBlockCallback(IRuby runtime) {
            this.runtime = runtime;
        }

        public IRubyObject call(IRubyObject[] iargs, IRubyObject iself) {
            if (iargs.length > 1) {
                this.arr.add(this.runtime.newArray(iargs));
            } else {
                this.arr.add(iargs[0]);
            }
            return this.runtime.getNil();
        }

        public List getList() {
            return this.arr;
        }
    }
}

