/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerable;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.internal.runtime.methods.MultiStubMethod;
import org.jruby.internal.runtime.methods.NoopMultiStub;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyEnumerator
extends RubyObject {
    private IRubyObject object;
    private IRubyObject method;
    private IRubyObject[] methodArgs;

    public static void defineEnumerator(IRuby runtime) {
        RubyModule enumerableModule = runtime.getModule("Enumerable");
        RubyClass object = runtime.getObject();
        RubyClass enumeratorClass = enumerableModule.defineClassUnder("Enumerator", object);
        RubyEnumeratorStub0 enumeratorStub = RubyEnumeratorStub0.createStub(enumeratorClass, object, enumerableModule);
        enumeratorClass.includeModule(enumerableModule);
        enumeratorClass.addSingletonMethod("new", enumeratorStub.enumerator__new);
        enumeratorClass.addMethod("initialize", enumeratorStub.enumerator__initialize);
        enumeratorClass.addMethod("each", enumeratorStub.enumerator__each);
        object.addMethod("to_enum", enumeratorStub.object__to_enum);
        object.addMethod("enum_for", enumeratorStub.object__to_enum);
        enumerableModule.addMethod("enum_with_index", enumeratorStub.enumerable__enum_with_index);
        enumerableModule.addMethod("each_slice", enumeratorStub.enumerable__each_slice);
        enumerableModule.addMethod("enum_slice", enumeratorStub.enumerable__enum_slice);
        enumerableModule.addMethod("each_cons", enumeratorStub.enumerable__each_cons);
        enumerableModule.addMethod("enum_cons", enumeratorStub.enumerable__enum_cons);
    }

    private RubyEnumerator(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    private IRubyObject initialize(ThreadContext tc, IRubyObject[] args) {
        this.checkArgumentCount(args, 1, -1);
        this.object = args[0];
        this.methodArgs = new IRubyObject[Math.max(0, args.length - 2)];
        this.method = args.length >= 2 ? args[1] : RubySymbol.newSymbol(tc.getRuntime(), "each");
        if (args.length >= 3) {
            System.arraycopy(args, 2, this.methodArgs, 0, args.length - 2);
        } else {
            this.methodArgs = new IRubyObject[0];
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject each(ThreadContext tc, IRubyObject[] args) {
        this.checkArgumentCount(args, 0, 0);
        boolean blockGiven = tc.isBlockGiven();
        if (blockGiven) {
            tc.setBlockAvailable();
        }
        try {
            IRubyObject iRubyObject = this.object.callMethod(tc, this.method.asSymbol(), this.methodArgs);
            return iRubyObject;
        }
        finally {
            if (blockGiven) {
                tc.clearInBlock();
            }
        }
    }

    public static class RubyEnumeratorStub0
    extends NoopMultiStub {
        private final RubyModule enumerator;
        private final IRuby runtime;
        public final MultiStubMethod enumerator__new;
        public final MultiStubMethod enumerator__initialize;
        public final MultiStubMethod enumerator__each;
        public final MultiStubMethod object__to_enum;
        public final MultiStubMethod enumerable__each_slice;
        public final MultiStubMethod enumerable__each_cons;
        public final MultiStubMethod enumerable__enum_with_index;
        public final MultiStubMethod enumerable__enum_slice;
        public final MultiStubMethod enumerable__enum_cons;

        public static RubyEnumeratorStub0 createStub(RubyClass enumeratorClass, RubyClass objectClass, RubyModule enumerableModule) {
            return new RubyEnumeratorStub0(enumeratorClass, objectClass, enumerableModule);
        }

        private RubyEnumeratorStub0(RubyClass enumeratorClass, RubyClass objectClass, RubyModule enumerableModule) {
            this.enumerator = enumeratorClass;
            this.runtime = enumeratorClass.getRuntime();
            this.enumerator__new = new MultiStubMethod(this, 0, enumeratorClass, Arity.required(1), Visibility.PUBLIC);
            this.enumerator__initialize = new MultiStubMethod(this, 1, enumeratorClass, Arity.required(1), Visibility.PRIVATE);
            this.enumerator__each = new MultiStubMethod(this, 2, enumeratorClass, Arity.optional(), Visibility.PUBLIC);
            this.object__to_enum = new MultiStubMethod(this, 3, objectClass, Arity.optional(), Visibility.PUBLIC);
            this.enumerable__each_slice = new MultiStubMethod(this, 4, enumerableModule, Arity.singleArgument(), Visibility.PUBLIC);
            this.enumerable__each_cons = new MultiStubMethod(this, 5, enumerableModule, Arity.singleArgument(), Visibility.PUBLIC);
            this.enumerable__enum_with_index = new MultiStubMethod(this, 6, enumerableModule, Arity.noArguments(), Visibility.PUBLIC);
            this.enumerable__enum_slice = new MultiStubMethod(this, 7, enumerableModule, Arity.singleArgument(), Visibility.PUBLIC);
            this.enumerable__enum_cons = new MultiStubMethod(this, 8, enumerableModule, Arity.singleArgument(), Visibility.PUBLIC);
        }

        public IRubyObject method0(ThreadContext tc, IRubyObject self, IRubyObject[] args) {
            RubyEnumerator result = new RubyEnumerator(this.runtime, (RubyClass)self);
            result.callMethod(tc, "initialize", args);
            return result;
        }

        public IRubyObject method1(ThreadContext tc, IRubyObject self, IRubyObject[] args) {
            return ((RubyEnumerator)self).initialize(tc, args);
        }

        public IRubyObject method2(ThreadContext tc, IRubyObject self, IRubyObject[] args) {
            return ((RubyEnumerator)self).each(tc, args);
        }

        public IRubyObject method3(ThreadContext tc, IRubyObject self, IRubyObject[] args) {
            IRubyObject[] newArgs = new IRubyObject[args.length + 1];
            newArgs[0] = self;
            System.arraycopy(args, 0, newArgs, 1, args.length);
            return this.enumerator.callMethod(tc, "new", newArgs);
        }

        public IRubyObject method4(ThreadContext tc, IRubyObject self, IRubyObject[] args) {
            self.checkArgumentCount(args, 1, 1);
            long sliceSize = args[0].convertToInteger().getLongValue();
            if (sliceSize <= 0L) {
                throw this.runtime.newArgumentError("invalid slice size");
            }
            SlicedBlockCallback sliceBlock = new SlicedBlockCallback(this.runtime, tc.getCurrentBlock(), sliceSize);
            RubyEnumerable.callEach(tc, self, self.getMetaClass(), sliceBlock);
            if (sliceBlock.hasLeftovers()) {
                sliceBlock.yieldLeftovers();
            }
            return this.runtime.getNil();
        }

        public IRubyObject method5(ThreadContext tc, IRubyObject self, IRubyObject[] args) {
            self.checkArgumentCount(args, 1, 1);
            long consecutiveSize = args[0].convertToInteger().getLongValue();
            if (consecutiveSize <= 0L) {
                throw this.runtime.newArgumentError("invalid size");
            }
            RubyEnumerable.callEach(tc, self, self.getMetaClass(), new ConsecutiveBlockCallback(this.runtime, tc.getCurrentBlock(), consecutiveSize));
            return this.runtime.getNil();
        }

        public IRubyObject method6(ThreadContext tc, IRubyObject self, IRubyObject[] args) {
            self.checkArgumentCount(args, 0, 0);
            return this.enumerator.callMethod(tc, "new", new IRubyObject[]{self, this.runtime.newSymbol("each_with_index")});
        }

        public IRubyObject method7(ThreadContext tc, IRubyObject self, IRubyObject[] args) {
            self.checkArgumentCount(args, 1, 1);
            return this.enumerator.callMethod(tc, "new", new IRubyObject[]{self, this.runtime.newSymbol("each_slice"), args[0]});
        }

        public IRubyObject method8(ThreadContext tc, IRubyObject self, IRubyObject[] args) {
            self.checkArgumentCount(args, 1, 1);
            return this.enumerator.callMethod(tc, "new", new IRubyObject[]{self, this.runtime.newSymbol("each_cons"), args[0]});
        }
    }

    public static class ConsecutiveBlockCallback
    implements BlockCallback {
        protected final RubyArray cont;
        protected final long contSize;
        protected final Block clientBlock;
        protected final IRuby runtime;

        public ConsecutiveBlockCallback(IRuby runtime, Block clientBlock, long contSize) {
            this.runtime = runtime;
            this.clientBlock = clientBlock;
            this.contSize = contSize;
            this.cont = RubyArray.newArray(runtime, contSize);
        }

        public IRubyObject call(IRubyObject[] args, IRubyObject replacementSelf) {
            if ((long)this.cont.getLength() == this.contSize) {
                this.cont.shift();
            }
            if (args.length > 1) {
                this.cont.append(RubyArray.newArray(this.runtime, args));
            } else {
                this.cont.append(args[0]);
            }
            if ((long)this.cont.getLength() == this.contSize) {
                this.clientBlock.call(new IRubyObject[]{this.cont.dup()}, null);
            }
            return this.runtime.getNil();
        }
    }

    public static class SlicedBlockCallback
    implements BlockCallback {
        protected RubyArray slice;
        protected final long sliceSize;
        protected final Block clientBlock;
        protected final IRuby runtime;

        public SlicedBlockCallback(IRuby runtime, Block clientBlock, long sliceSize) {
            this.runtime = runtime;
            this.clientBlock = clientBlock;
            this.sliceSize = sliceSize;
            this.slice = RubyArray.newArray(runtime, sliceSize);
        }

        public IRubyObject call(IRubyObject[] args, IRubyObject replacementSelf) {
            if (args.length > 1) {
                this.slice.append(RubyArray.newArray(this.runtime, args));
            } else {
                this.slice.append(args[0]);
            }
            if ((long)this.slice.getLength() == this.sliceSize) {
                this.clientBlock.call(new IRubyObject[]{this.slice}, null);
                this.slice = RubyArray.newArray(this.runtime, this.sliceSize);
            }
            return this.runtime.getNil();
        }

        public boolean hasLeftovers() {
            return this.slice.getLength() > 0 && (long)this.slice.getLength() < this.sliceSize;
        }

        public void yieldLeftovers() {
            this.clientBlock.call(new IRubyObject[]{this.slice}, null);
        }
    }
}

