/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.IRuby;
import org.jruby.RubyBignum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubyFixnum
extends RubyInteger {
    private long value;
    private static final int BIT_SIZE = 64;
    public static final long MAX = 0x3FFFFFFFFFFFFFFFL;
    public static final long MIN = -4611686018427387904L;
    private static final long MAX_MARSHAL_FIXNUM = 0x3FFFFFFFL;

    public RubyFixnum(IRuby runtime) {
        this(runtime, 0L);
    }

    public RubyFixnum(IRuby runtime, long value) {
        super(runtime, runtime.getFixnum());
        this.value = value;
    }

    public boolean isImmediate() {
        return true;
    }

    public Class getJavaClass() {
        return Long.TYPE;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public long getLongValue() {
        return this.value;
    }

    public static RubyFixnum zero(IRuby runtime) {
        return RubyFixnum.newFixnum(runtime, 0L);
    }

    public static RubyFixnum one(IRuby runtime) {
        return RubyFixnum.newFixnum(runtime, 1L);
    }

    public static RubyFixnum minus_one(IRuby runtime) {
        return RubyFixnum.newFixnum(runtime, -1L);
    }

    protected int compareValue(RubyNumeric other) {
        if (other instanceof RubyBignum) {
            return -other.compareValue(this);
        }
        if (other instanceof RubyFloat) {
            double otherVal = other.getDoubleValue();
            return (double)this.value > otherVal ? 1 : ((double)this.value < otherVal ? -1 : 0);
        }
        long otherVal = other.getLongValue();
        return this.value > otherVal ? 1 : (this.value < otherVal ? -1 : 0);
    }

    public RubyFixnum hash() {
        return this.newFixnum(this.hashCode());
    }

    public int hashCode() {
        return (int)this.value ^ (int)(this.value >> 32);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RubyFixnum) {
            RubyFixnum num = (RubyFixnum)other;
            if (num.value == this.value) {
                return true;
            }
        }
        return false;
    }

    public static RubyFixnum newFixnum(IRuby runtime, long value) {
        RubyFixnum fixnum;
        RubyFixnum[] fixnumCache = runtime.getFixnumCache();
        if (value >= 0L && value < (long)fixnumCache.length) {
            fixnum = fixnumCache[(int)value];
            if (fixnum == null) {
                fixnumCache[(int)value] = fixnum = new RubyFixnum(runtime, value);
            }
        } else {
            fixnum = new RubyFixnum(runtime, value);
        }
        return fixnum;
    }

    public RubyFixnum newFixnum(long newValue) {
        return RubyFixnum.newFixnum(this.getRuntime(), newValue);
    }

    public boolean singletonMethodsAllowed() {
        return false;
    }

    public RubyNumeric multiplyWith(RubyFixnum other) {
        long otherValue = other.getLongValue();
        if (otherValue == 0L) {
            return RubyFixnum.zero(this.getRuntime());
        }
        long result = this.value * otherValue;
        if (result > 0x3FFFFFFFFFFFFFFFL || result < -4611686018427387904L || result / otherValue != this.value) {
            return (RubyNumeric)RubyBignum.newBignum(this.getRuntime(), this.getLongValue()).op_mul(other);
        }
        return this.newFixnum(result);
    }

    public RubyNumeric multiplyWith(RubyInteger other) {
        return other.multiplyWith(this);
    }

    public RubyNumeric multiplyWith(RubyFloat other) {
        return other.multiplyWith(RubyFloat.newFloat(this.getRuntime(), this.getLongValue()));
    }

    public RubyNumeric quo(IRubyObject other) {
        return new RubyFloat(this.getRuntime(), ((RubyNumeric)this.op_div(other)).getDoubleValue());
    }

    public IRubyObject op_and(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return this.newFixnum(this.value & ((RubyNumeric)other).getTruncatedLongValue());
        }
        return this.callCoerced("&", other);
    }

    public IRubyObject op_div(IRubyObject other) {
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_div(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuntime(), this.getLongValue()).op_div(other);
        }
        if (other instanceof RubyNumeric) {
            long x = this.getLongValue();
            long y = ((RubyNumeric)other).getLongValue();
            if (y == 0L) {
                throw this.getRuntime().newZeroDivisionError();
            }
            long div = x / y;
            long mod = x % y;
            if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
                --div;
            }
            return this.getRuntime().newFixnum(div);
        }
        return this.callCoerced("/", other);
    }

    public IRubyObject op_lshift(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            long width = ((RubyNumeric)other).getLongValue();
            if (width < 0L) {
                return this.op_rshift(((RubyNumeric)other).op_uminus());
            }
            if (this.value > 0L) {
                if (width >= 62L || this.value >> (int)(64L - width) > 0L) {
                    RubyBignum bigValue = RubyBignum.newBignum(this.getRuntime(), RubyBignum.bigIntValue(this));
                    return bigValue.op_lshift(other);
                }
            } else if (width >= 63L || this.value >> (int)(64L - width) < -1L) {
                RubyBignum bigValue = RubyBignum.newBignum(this.getRuntime(), RubyBignum.bigIntValue(this));
                return bigValue.op_lshift(other);
            }
            return this.newFixnum(this.value << (int)width);
        }
        return this.callCoerced("<<", other);
    }

    public IRubyObject op_minus(IRubyObject other) {
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_minus(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_minus(other);
        }
        if (other instanceof RubyNumeric) {
            long otherValue = ((RubyNumeric)other).getLongValue();
            long result = this.value - otherValue;
            if (this.value <= 0L && otherValue >= 0L && (result > 0L || result < -4611686018427387903L) || this.value >= 0L && otherValue <= 0L && (result < 0L || result > 0x3FFFFFFFFFFFFFFFL)) {
                return RubyBignum.newBignum(this.getRuntime(), this.value).op_minus(other);
            }
            return this.newFixnum(result);
        }
        return this.callCoerced("-", other);
    }

    public IRubyObject op_mod(IRubyObject other) {
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_mod(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuntime(), this.getLongValue()).op_mod(other);
        }
        if (other instanceof RubyNumeric) {
            long y;
            long x = this.getLongValue();
            long mod = x % (y = ((RubyNumeric)other).getLongValue());
            if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
                mod += y;
            }
            return this.getRuntime().newFixnum(mod);
        }
        return (RubyNumeric)this.callCoerced("%", other);
    }

    public IRubyObject op_mul(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return ((RubyNumeric)other).multiplyWith(this);
        }
        return this.callCoerced("*", other);
    }

    public IRubyObject op_or(IRubyObject other) {
        if (other instanceof RubyBignum) {
            return (RubyInteger)other.callMethod(this.getRuntime().getCurrentContext(), "|", this);
        }
        if (other instanceof RubyNumeric) {
            return this.newFixnum(this.value | ((RubyNumeric)other).getLongValue());
        }
        return (RubyInteger)this.callCoerced("|", other);
    }

    public IRubyObject op_plus(IRubyObject other) {
        if (other instanceof RubyFloat) {
            return this.getRuntime().newFloat(this.getDoubleValue() + ((RubyFloat)other).getDoubleValue());
        }
        if (other instanceof RubyFixnum) {
            long otherValue = ((RubyFixnum)other).getLongValue();
            long result = this.value + otherValue;
            if (other instanceof RubyBignum || this.value < 0L && otherValue < 0L && (result > 0L || result < -4611686018427387903L) || this.value > 0L && otherValue > 0L && (result < 0L || result > 0x3FFFFFFFFFFFFFFFL)) {
                return RubyBignum.newBignum(this.getRuntime(), this.value).op_plus(other);
            }
            return this.newFixnum(result);
        }
        return this.callCoerced("+", other);
    }

    public IRubyObject op_pow(IRubyObject other) {
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_pow(other);
        }
        if (other instanceof RubyNumeric) {
            long longValue = ((RubyNumeric)other).getLongValue();
            if (longValue == 0L) {
                return this.getRuntime().newFixnum(1L);
            }
            if (longValue == 1L) {
                return this;
            }
            if (longValue > 1L) {
                return RubyBignum.newBignum(this.getRuntime(), this.getLongValue()).op_pow(other);
            }
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_pow(other);
        }
        return this.callCoerced("**", other);
    }

    public IRubyObject op_rshift(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            long width = ((RubyNumeric)other).getLongValue();
            if (width < 0L) {
                return this.op_lshift(((RubyNumeric)other).op_uminus());
            }
            return this.newFixnum(this.value >> (int)width);
        }
        return this.callCoerced(">>", other);
    }

    public IRubyObject op_xor(IRubyObject other) {
        if (other instanceof RubyBignum) {
            return (RubyInteger)other.callMethod(this.getRuntime().getCurrentContext(), "^", this);
        }
        if (other instanceof RubyNumeric) {
            return this.newFixnum(this.value ^ ((RubyNumeric)other).getLongValue());
        }
        return this.callCoerced("^", other);
    }

    public RubyString to_s(IRubyObject[] args) {
        this.checkArgumentCount(args, 0, 1);
        int radix = args.length == 0 ? 10 : (int)args[0].convertToInteger().getLongValue();
        return this.getRuntime().newString(Long.toString(this.getLongValue(), radix));
    }

    public RubyFloat to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    public RubyFixnum size() {
        return this.newFixnum((long)Math.ceil(8.0));
    }

    public RubyFixnum aref(IRubyObject other) {
        long position = other.convertToInteger().getLongValue();
        if (position > 64L) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).aref(other);
        }
        return this.newFixnum((this.value & 1L << (int)position) == 0L ? 0L : 1L);
    }

    public IRubyObject id2name() {
        String symbol = RubySymbol.getSymbol(this.getRuntime(), this.value);
        if (symbol != null) {
            return this.getRuntime().newString(symbol);
        }
        return this.getRuntime().getNil();
    }

    public RubyFixnum invert() {
        return this.newFixnum(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public RubyFixnum id() {
        return this.newFixnum(this.value * 2L + 1L);
    }

    public IRubyObject taint() {
        return this;
    }

    public IRubyObject freeze() {
        return this;
    }

    public IRubyObject times() {
        IRuby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        for (long i = 0L; i < this.value; ++i) {
            context.yield(RubyFixnum.newFixnum(runtime, i));
        }
        return this;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        if (this.value <= 0x3FFFFFFFL) {
            output.write(105);
            output.dumpInt((int)this.value);
        } else {
            output.dumpObject(RubyBignum.newBignum(this.getRuntime(), this.value));
        }
    }

    public static RubyFixnum unmarshalFrom(UnmarshalStream input) throws IOException {
        return input.getRuntime().newFixnum(input.unmarshalInt());
    }
}

