/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jruby.IRuby;
import org.jruby.Main;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.FileMetaClass;
import org.jruby.runtime.builtin.meta.IOMetaClass;
import org.jruby.runtime.builtin.meta.StringMetaClass;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.PrintfFormat;
import org.jruby.util.UnsynchronizedStack;

public class RubyKernel {
    private static final Pattern PATH_SEPARATORS = Pattern.compile("[/\\\\]");

    public static RubyModule createKernelModule(IRuby runtime) {
        RubyModule module = runtime.defineModule("Kernel");
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyKernel.class);
        CallbackFactory objectCallbackFactory = runtime.callbackFactory(RubyObject.class);
        module.defineModuleFunction("Array", callbackFactory.getSingletonMethod("new_array", IRubyObject.class));
        module.defineModuleFunction("Float", callbackFactory.getSingletonMethod("new_float", IRubyObject.class));
        module.defineModuleFunction("Integer", callbackFactory.getSingletonMethod("new_integer", IRubyObject.class));
        module.defineModuleFunction("String", callbackFactory.getSingletonMethod("new_string", IRubyObject.class));
        module.defineModuleFunction("`", callbackFactory.getSingletonMethod("backquote", IRubyObject.class));
        module.defineModuleFunction("abort", callbackFactory.getOptSingletonMethod("abort"));
        module.defineModuleFunction("at_exit", callbackFactory.getSingletonMethod("at_exit"));
        module.defineModuleFunction("autoload", callbackFactory.getSingletonMethod("autoload", IRubyObject.class, IRubyObject.class));
        module.definePublicModuleFunction("autoload?", callbackFactory.getSingletonMethod("autoload_p", IRubyObject.class));
        module.defineModuleFunction("binding", callbackFactory.getSingletonMethod("binding"));
        module.defineModuleFunction("block_given?", callbackFactory.getSingletonMethod("block_given"));
        module.defineModuleFunction("caller", callbackFactory.getOptSingletonMethod("caller"));
        module.defineModuleFunction("catch", callbackFactory.getSingletonMethod("rbCatch", IRubyObject.class));
        module.defineModuleFunction("chomp", callbackFactory.getOptSingletonMethod("chomp"));
        module.defineModuleFunction("chomp!", callbackFactory.getOptSingletonMethod("chomp_bang"));
        module.defineModuleFunction("chop", callbackFactory.getSingletonMethod("chop"));
        module.defineModuleFunction("chop!", callbackFactory.getSingletonMethod("chop_bang"));
        module.defineModuleFunction("eval", callbackFactory.getOptSingletonMethod("eval"));
        module.defineModuleFunction("exit", callbackFactory.getOptSingletonMethod("exit"));
        module.defineModuleFunction("exit!", callbackFactory.getOptSingletonMethod("exit_bang"));
        module.defineModuleFunction("fail", callbackFactory.getOptSingletonMethod("raise"));
        module.defineModuleFunction("format", callbackFactory.getOptSingletonMethod("sprintf"));
        module.defineModuleFunction("gets", callbackFactory.getOptSingletonMethod("gets"));
        module.defineModuleFunction("global_variables", callbackFactory.getSingletonMethod("global_variables"));
        module.defineModuleFunction("gsub", callbackFactory.getOptSingletonMethod("gsub"));
        module.defineModuleFunction("gsub!", callbackFactory.getOptSingletonMethod("gsub_bang"));
        module.defineModuleFunction("iterator?", callbackFactory.getSingletonMethod("block_given"));
        module.defineModuleFunction("lambda", callbackFactory.getSingletonMethod("proc"));
        module.defineModuleFunction("load", callbackFactory.getOptSingletonMethod("load"));
        module.defineModuleFunction("local_variables", callbackFactory.getSingletonMethod("local_variables"));
        module.defineModuleFunction("loop", callbackFactory.getSingletonMethod("loop"));
        module.defineModuleFunction("method_missing", callbackFactory.getOptSingletonMethod("method_missing"));
        module.defineModuleFunction("open", callbackFactory.getOptSingletonMethod("open"));
        module.defineModuleFunction("p", callbackFactory.getOptSingletonMethod("p"));
        module.defineModuleFunction("print", callbackFactory.getOptSingletonMethod("print"));
        module.defineModuleFunction("printf", callbackFactory.getOptSingletonMethod("printf"));
        module.defineModuleFunction("proc", callbackFactory.getSingletonMethod("proc"));
        module.defineModuleFunction("puts", callbackFactory.getOptSingletonMethod("puts"));
        module.defineModuleFunction("raise", callbackFactory.getOptSingletonMethod("raise"));
        module.defineModuleFunction("rand", callbackFactory.getOptSingletonMethod("rand"));
        module.defineModuleFunction("readline", callbackFactory.getOptSingletonMethod("readline"));
        module.defineModuleFunction("readlines", callbackFactory.getOptSingletonMethod("readlines"));
        module.defineModuleFunction("require", callbackFactory.getSingletonMethod("require", IRubyObject.class));
        module.defineModuleFunction("scan", callbackFactory.getSingletonMethod("scan", IRubyObject.class));
        module.defineModuleFunction("select", callbackFactory.getOptSingletonMethod("select"));
        module.defineModuleFunction("set_trace_func", callbackFactory.getSingletonMethod("set_trace_func", IRubyObject.class));
        module.defineModuleFunction("sleep", callbackFactory.getSingletonMethod("sleep", IRubyObject.class));
        module.defineModuleFunction("split", callbackFactory.getOptSingletonMethod("split"));
        module.defineModuleFunction("sprintf", callbackFactory.getOptSingletonMethod("sprintf"));
        module.defineModuleFunction("srand", callbackFactory.getOptSingletonMethod("srand"));
        module.defineModuleFunction("sub", callbackFactory.getOptSingletonMethod("sub"));
        module.defineModuleFunction("sub!", callbackFactory.getOptSingletonMethod("sub_bang"));
        module.defineModuleFunction("system", callbackFactory.getOptSingletonMethod("system"));
        module.defineModuleFunction("exec", callbackFactory.getOptSingletonMethod("system"));
        module.defineModuleFunction("throw", callbackFactory.getOptSingletonMethod("rbThrow"));
        module.defineModuleFunction("trap", callbackFactory.getOptSingletonMethod("trap"));
        module.defineModuleFunction("warn", callbackFactory.getSingletonMethod("warn", IRubyObject.class));
        module.defineModuleFunction("singleton_method_added", callbackFactory.getSingletonMethod("singleton_method_added", IRubyObject.class));
        module.definePublicModuleFunction("==", objectCallbackFactory.getMethod("equal", IRubyObject.class));
        module.defineAlias("===", "==");
        module.defineAlias("eql?", "==");
        module.definePublicModuleFunction("to_s", objectCallbackFactory.getMethod("to_s"));
        module.definePublicModuleFunction("nil?", objectCallbackFactory.getMethod("nil_p"));
        module.definePublicModuleFunction("to_a", callbackFactory.getSingletonMethod("to_a"));
        module.definePublicModuleFunction("hash", objectCallbackFactory.getMethod("hash"));
        module.definePublicModuleFunction("id", objectCallbackFactory.getMethod("id"));
        module.defineAlias("__id__", "id");
        module.defineAlias("object_id", "id");
        module.definePublicModuleFunction("is_a?", objectCallbackFactory.getMethod("kind_of", IRubyObject.class));
        module.defineAlias("kind_of?", "is_a?");
        module.definePublicModuleFunction("dup", objectCallbackFactory.getMethod("dup"));
        module.definePublicModuleFunction("equal?", objectCallbackFactory.getMethod("same", IRubyObject.class));
        module.definePublicModuleFunction("type", objectCallbackFactory.getMethod("type_deprecated"));
        module.definePublicModuleFunction("class", objectCallbackFactory.getMethod("type"));
        module.definePublicModuleFunction("inspect", objectCallbackFactory.getMethod("inspect"));
        module.definePublicModuleFunction("=~", objectCallbackFactory.getMethod("match", IRubyObject.class));
        module.definePublicModuleFunction("clone", objectCallbackFactory.getMethod("rbClone"));
        module.definePublicModuleFunction("display", objectCallbackFactory.getOptMethod("display"));
        module.definePublicModuleFunction("extend", objectCallbackFactory.getOptMethod("extend"));
        module.definePublicModuleFunction("freeze", objectCallbackFactory.getMethod("freeze"));
        module.definePublicModuleFunction("frozen?", objectCallbackFactory.getMethod("frozen"));
        module.defineModuleFunction("initialize_copy", objectCallbackFactory.getMethod("initialize_copy", IRubyObject.class));
        module.definePublicModuleFunction("instance_eval", objectCallbackFactory.getOptMethod("instance_eval"));
        module.definePublicModuleFunction("instance_of?", objectCallbackFactory.getMethod("instance_of", IRubyObject.class));
        module.definePublicModuleFunction("instance_variables", objectCallbackFactory.getMethod("instance_variables"));
        module.definePublicModuleFunction("instance_variable_get", objectCallbackFactory.getMethod("instance_variable_get", IRubyObject.class));
        module.definePublicModuleFunction("instance_variable_set", objectCallbackFactory.getMethod("instance_variable_set", IRubyObject.class, IRubyObject.class));
        module.definePublicModuleFunction("method", objectCallbackFactory.getMethod("method", IRubyObject.class));
        module.definePublicModuleFunction("methods", objectCallbackFactory.getOptMethod("methods"));
        module.definePublicModuleFunction("private_methods", objectCallbackFactory.getMethod("private_methods"));
        module.definePublicModuleFunction("protected_methods", objectCallbackFactory.getMethod("protected_methods"));
        module.definePublicModuleFunction("public_methods", objectCallbackFactory.getOptMethod("public_methods"));
        module.defineModuleFunction("remove_instance_variable", objectCallbackFactory.getMethod("remove_instance_variable", IRubyObject.class));
        module.definePublicModuleFunction("respond_to?", objectCallbackFactory.getOptMethod("respond_to"));
        module.definePublicModuleFunction("send", objectCallbackFactory.getOptMethod("send"));
        module.defineAlias("__send__", "send");
        module.definePublicModuleFunction("singleton_methods", objectCallbackFactory.getOptMethod("singleton_methods"));
        module.definePublicModuleFunction("taint", objectCallbackFactory.getMethod("taint"));
        module.definePublicModuleFunction("tainted?", objectCallbackFactory.getMethod("tainted"));
        module.definePublicModuleFunction("untaint", objectCallbackFactory.getMethod("untaint"));
        return module;
    }

    public static IRubyObject at_exit(IRubyObject recv) {
        return recv.getRuntime().pushExitBlock(recv.getRuntime().newProc());
    }

    public static IRubyObject autoload_p(IRubyObject recv, IRubyObject symbol) {
        IAutoloadMethod m;
        String name = symbol.asSymbol();
        if (recv instanceof RubyModule) {
            name = ((RubyModule)recv).getName() + "::" + name;
        }
        if ((m = recv.getRuntime().getLoadService().autoloadFor(name)) == null) {
            return recv.getRuntime().getNil();
        }
        return recv.getRuntime().newString(m.file());
    }

    public static IRubyObject autoload(final IRubyObject recv, IRubyObject symbol, final IRubyObject file) {
        String baseName;
        final LoadService loadService = recv.getRuntime().getLoadService();
        String nm = baseName = symbol.asSymbol();
        if (recv instanceof RubyModule) {
            nm = ((RubyModule)recv).getName() + "::" + nm;
        }
        loadService.addAutoload(nm, new IAutoloadMethod(){

            public String file() {
                return file.toString();
            }

            public IRubyObject load(IRuby runtime, String name) {
                loadService.require(file.toString());
                if (recv instanceof RubyModule) {
                    return ((RubyModule)recv).getConstant(baseName);
                }
                return runtime.getObject().getConstant(baseName);
            }
        });
        return recv;
    }

    public static IRubyObject method_missing(IRubyObject recv, IRubyObject[] args) {
        IRuby runtime = recv.getRuntime();
        if (args.length == 0) {
            throw recv.getRuntime().newArgumentError("no id given");
        }
        String name = args[0].asSymbol();
        String description = recv.callMethod(runtime.getCurrentContext(), "inspect").toString();
        boolean noClass = description.length() > 0 && description.charAt(0) == '#';
        ThreadContext tc = runtime.getCurrentContext();
        Visibility lastVis = tc.getLastVisibility();
        CallType lastCallType = tc.getLastCallType();
        String format = lastVis.errorMessageFormat(lastCallType, name);
        String msg = new PrintfFormat(format).sprintf(new Object[]{name, description, noClass ? "" : ":", noClass ? "" : recv.getType().getName()});
        throw lastCallType == CallType.VARIABLE ? runtime.newNameError(msg, name) : runtime.newNoMethodError(msg, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args) {
        IRubyObject iRubyObject;
        String arg = args[0].convertToString().toString();
        if (!arg.startsWith("|")) return ((FileMetaClass)recv.getRuntime().getClass("File")).open(args);
        String command = arg.substring(1);
        Process p = Runtime.getRuntime().exec(command);
        RubyIO io = new RubyIO(recv.getRuntime(), p);
        ThreadContext tc = recv.getRuntime().getCurrentContext();
        if (!tc.isBlockGiven()) return io;
        try {
            tc.yield(io);
            iRubyObject = recv.getRuntime().getNil();
            io.close();
        }
        catch (Throwable throwable) {
            try {
                io.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw recv.getRuntime().newIOErrorFromException(ioe);
            }
        }
        return iRubyObject;
    }

    public static IRubyObject gets(IRubyObject recv, IRubyObject[] args) {
        RubyArgsFile argsFile = (RubyArgsFile)recv.getRuntime().getGlobalVariables().get("$<");
        IRubyObject line = argsFile.internalGets(args);
        recv.getRuntime().getCurrentContext().setLastline(line);
        return line;
    }

    public static IRubyObject abort(IRubyObject recv, IRubyObject[] args) {
        if (recv.checkArgumentCount(args, 0, 1) == 1) {
            recv.getRuntime().getGlobalVariables().get("$stderr").callMethod(recv.getRuntime().getCurrentContext(), "puts", args[0]);
        }
        throw new MainExitException(1, true);
    }

    public static IRubyObject new_array(IRubyObject recv, IRubyObject object) {
        IRubyObject value = object.convertToTypeWithCheck("Array", "to_ary");
        if (value.isNil()) {
            ICallable method = object.getMetaClass().searchMethod("to_a");
            if (method.getImplementationClass() == recv.getRuntime().getKernel()) {
                return recv.getRuntime().newArray(object);
            }
            value = object.callMethod(recv.getRuntime().getCurrentContext(), "to_a");
            if (value.getMetaClass() != recv.getRuntime().getClass("Array")) {
                throw recv.getRuntime().newTypeError("`to_a' did not return Array");
            }
        }
        return value;
    }

    public static IRubyObject new_float(IRubyObject recv, IRubyObject object) {
        if (object instanceof RubyString) {
            return RubyNumeric.str2fnum(recv.getRuntime(), (RubyString)object, true);
        }
        return object.callMethod(recv.getRuntime().getCurrentContext(), "to_f");
    }

    public static IRubyObject new_integer(IRubyObject recv, IRubyObject object) {
        ThreadContext context = recv.getRuntime().getCurrentContext();
        if (object instanceof RubyString) {
            String val = object.toString();
            if (val.length() > 0 && val.charAt(0) == '0' && val.length() > 1) {
                if (val.charAt(1) == 'x') {
                    return RubyNumeric.str2inum(recv.getRuntime(), recv.getRuntime().newString(val.substring(2)), 16, true);
                }
                if (val.charAt(1) == 'b') {
                    return RubyNumeric.str2inum(recv.getRuntime(), recv.getRuntime().newString(val.substring(2)), 2, true);
                }
                return RubyNumeric.str2inum(recv.getRuntime(), recv.getRuntime().newString(val.substring(1)), 8, true);
            }
            return RubyNumeric.str2inum(recv.getRuntime(), (RubyString)object, 10, true);
        }
        return object.callMethod(context, "to_i");
    }

    public static IRubyObject new_string(IRubyObject recv, IRubyObject object) {
        return object.callMethod(recv.getRuntime().getCurrentContext(), "to_s");
    }

    public static IRubyObject p(IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
        ThreadContext context = recv.getRuntime().getCurrentContext();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            defout.callMethod(context, "write", args[i].callMethod(context, "inspect"));
            defout.callMethod(context, "write", recv.getRuntime().newString("\n"));
        }
        return recv.getRuntime().getNil();
    }

    public static IRubyObject puts(IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
        ThreadContext context = recv.getRuntime().getCurrentContext();
        defout.callMethod(context, "puts", args);
        return recv.getRuntime().getNil();
    }

    public static IRubyObject print(IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
        ThreadContext context = recv.getRuntime().getCurrentContext();
        defout.callMethod(context, "print", args);
        return recv.getRuntime().getNil();
    }

    public static IRubyObject printf(IRubyObject recv, IRubyObject[] args) {
        if (args.length != 0) {
            IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
            if (!(args[0] instanceof RubyString)) {
                defout = args[0];
                args = ArgsUtil.popArray(args);
            }
            ThreadContext context = recv.getRuntime().getCurrentContext();
            defout.callMethod(context, "write", RubyKernel.sprintf(recv, args));
        }
        return recv.getRuntime().getNil();
    }

    public static IRubyObject readline(IRubyObject recv, IRubyObject[] args) {
        IRubyObject line = RubyKernel.gets(recv, args);
        if (line.isNil()) {
            throw recv.getRuntime().newEOFError();
        }
        return line;
    }

    public static RubyArray readlines(IRubyObject recv, IRubyObject[] args) {
        RubyArgsFile argsFile = (RubyArgsFile)recv.getRuntime().getGlobalVariables().get("$<");
        RubyArray lines = recv.getRuntime().newArray();
        IRubyObject line = argsFile.internalGets(args);
        while (!line.isNil()) {
            lines.append(line);
            line = argsFile.internalGets(args);
        }
        return lines;
    }

    private static RubyString getLastlineString(IRuby runtime) {
        IRubyObject line = runtime.getCurrentContext().getLastline();
        if (line.isNil()) {
            throw runtime.newTypeError("$_ value need to be String (nil given).");
        }
        if (!(line instanceof RubyString)) {
            throw runtime.newTypeError("$_ value need to be String (" + line.getMetaClass().getName() + " given).");
        }
        return (RubyString)line;
    }

    public static IRubyObject sub_bang(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.getLastlineString(recv.getRuntime()).sub_bang(args);
    }

    public static IRubyObject sub(IRubyObject recv, IRubyObject[] args) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(recv.getRuntime()).dup();
        if (!str.sub_bang(args).isNil()) {
            recv.getRuntime().getCurrentContext().setLastline(str);
        }
        return str;
    }

    public static IRubyObject gsub_bang(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.getLastlineString(recv.getRuntime()).gsub_bang(args);
    }

    public static IRubyObject gsub(IRubyObject recv, IRubyObject[] args) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(recv.getRuntime()).dup();
        if (!str.gsub_bang(args).isNil()) {
            recv.getRuntime().getCurrentContext().setLastline(str);
        }
        return str;
    }

    public static IRubyObject chop_bang(IRubyObject recv) {
        return RubyKernel.getLastlineString(recv.getRuntime()).chop_bang();
    }

    public static IRubyObject chop(IRubyObject recv) {
        RubyString str = RubyKernel.getLastlineString(recv.getRuntime());
        if (str.getValue().length() > 0) {
            str = (RubyString)str.dup();
            str.chop_bang();
            recv.getRuntime().getCurrentContext().setLastline(str);
        }
        return str;
    }

    public static IRubyObject chomp_bang(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.getLastlineString(recv.getRuntime()).chomp_bang(args);
    }

    public static IRubyObject chomp(IRubyObject recv, IRubyObject[] args) {
        RubyString str = RubyKernel.getLastlineString(recv.getRuntime());
        RubyString dup = (RubyString)str.dup();
        if (dup.chomp_bang(args).isNil()) {
            return str;
        }
        recv.getRuntime().getCurrentContext().setLastline(dup);
        return dup;
    }

    public static IRubyObject split(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.getLastlineString(recv.getRuntime()).split(args);
    }

    public static IRubyObject scan(IRubyObject recv, IRubyObject pattern) {
        return RubyKernel.getLastlineString(recv.getRuntime()).scan(pattern);
    }

    public static IRubyObject select(IRubyObject recv, IRubyObject[] args) {
        return IOMetaClass.select_static(recv.getRuntime(), args);
    }

    public static IRubyObject sleep(IRubyObject recv, IRubyObject seconds) {
        long milliseconds = (long)(seconds.convertToFloat().getDoubleValue() * 1000.0);
        long startTime = System.currentTimeMillis();
        RubyThread rubyThread = recv.getRuntime().getThreadService().getCurrentContext().getThread();
        try {
            rubyThread.sleep(milliseconds);
        }
        catch (InterruptedException iExcptn) {
            // empty catch block
        }
        return recv.getRuntime().newFixnum(Math.round((double)(System.currentTimeMillis() - startTime) / 1000.0));
    }

    public static IRubyObject exit(IRubyObject recv, IRubyObject[] args) {
        recv.getRuntime().secure(4);
        int status = 1;
        if (args.length > 0) {
            RubyObject argument = (RubyObject)args[0];
            status = argument instanceof RubyFixnum ? RubyNumeric.fix2int(argument) : (argument.isFalse() ? 1 : 0);
        }
        throw recv.getRuntime().newSystemExit(status);
    }

    public static IRubyObject exit_bang(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.exit(recv, args);
    }

    public static RubyArray global_variables(IRubyObject recv) {
        RubyArray globalVariables = recv.getRuntime().newArray();
        Iterator iter = recv.getRuntime().getGlobalVariables().getNames();
        while (iter.hasNext()) {
            String globalVariableName = (String)iter.next();
            globalVariables.append(recv.getRuntime().newString(globalVariableName));
        }
        return globalVariables;
    }

    public static RubyArray local_variables(IRubyObject recv) {
        IRuby runtime = recv.getRuntime();
        RubyArray localVariables = runtime.newArray();
        String[] names = runtime.getCurrentContext().getCurrentScope().getAllNamesInScope();
        for (int i = 0; i < names.length; ++i) {
            localVariables.append(runtime.newString(names[i]));
        }
        return localVariables;
    }

    public static RubyBinding binding(IRubyObject recv) {
        return recv.getRuntime().newBinding();
    }

    public static RubyBoolean block_given(IRubyObject recv) {
        return recv.getRuntime().newBoolean(recv.getRuntime().getCurrentContext().isFBlockGiven());
    }

    public static IRubyObject sprintf(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            throw recv.getRuntime().newArgumentError("sprintf must have at least one argument");
        }
        RubyString str = RubyString.stringValue(args[0]);
        RubyArray newArgs = recv.getRuntime().newArray(args);
        newArgs.shift();
        return ((StringMetaClass)str.getMetaClass()).format.call(recv.getRuntime().getCurrentContext(), str, str.getMetaClass(), "%", new IRubyObject[]{newArgs}, false);
    }

    public static IRubyObject raise(IRubyObject recv, IRubyObject[] args) {
        IRubyObject exception;
        recv.checkArgumentCount(args, 0, 3);
        IRuby runtime = recv.getRuntime();
        if (args.length == 0) {
            IRubyObject lastException = runtime.getGlobalVariables().get("$!");
            if (lastException.isNil()) {
                throw new RaiseException(runtime, runtime.getClass("RuntimeError"), "", false);
            }
            throw new RaiseException((RubyException)lastException);
        }
        ThreadContext context = recv.getRuntime().getCurrentContext();
        if (args.length == 1) {
            if (args[0] instanceof RubyString) {
                throw new RaiseException(RubyException.newInstance(runtime.getClass("RuntimeError"), args));
            }
            if (!args[0].respondsTo("exception")) {
                throw runtime.newTypeError("exception class/object expected");
            }
            exception = args[0].callMethod(context, "exception");
        } else {
            if (!args[0].respondsTo("exception")) {
                throw runtime.newTypeError("exception class/object expected");
            }
            exception = args[0].callMethod(context, "exception", args[1]);
        }
        if (!exception.isKindOf(runtime.getClass("Exception"))) {
            throw runtime.newTypeError("exception object expected");
        }
        if (args.length == 3) {
            ((RubyException)exception).set_backtrace(args[2]);
        }
        throw new RaiseException((RubyException)exception);
    }

    public static IRubyObject require(IRubyObject recv, IRubyObject name) {
        if (recv.getRuntime().getLoadService().require(name.toString())) {
            return recv.getRuntime().getTrue();
        }
        return recv.getRuntime().getFalse();
    }

    public static IRubyObject load(IRubyObject recv, IRubyObject[] args) {
        RubyString file = args[0].convertToString();
        recv.getRuntime().getLoadService().load(file.toString());
        return recv.getRuntime().getTrue();
    }

    public static IRubyObject eval(IRubyObject recv, IRubyObject[] args) {
        RubyString src = args[0].convertToString();
        IRubyObject scope = null;
        String file = "(eval)";
        if (args.length > 1) {
            if (!args[1].isNil()) {
                scope = args[1];
            }
            if (args.length > 2) {
                file = args[2].toString();
            }
        }
        src.checkSafeString();
        ThreadContext context = recv.getRuntime().getCurrentContext();
        if (scope == null) {
            scope = recv.getRuntime().newBinding();
        }
        return recv.evalWithBinding(context, src, scope, file);
    }

    public static IRubyObject caller(IRubyObject recv, IRubyObject[] args) {
        int level;
        int n = level = args.length > 0 ? RubyNumeric.fix2int(args[0]) : 1;
        if (level < 0) {
            throw recv.getRuntime().newArgumentError("negative level(" + level + ')');
        }
        return recv.getRuntime().getCurrentContext().createBacktrace(level, false);
    }

    public static IRubyObject rbCatch(IRubyObject recv, IRubyObject tag) {
        ThreadContext context = recv.getRuntime().getCurrentContext();
        try {
            context.pushCatch(tag.asSymbol());
            IRubyObject iRubyObject = context.yield(tag);
            return iRubyObject;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.ThrowJump && je.getPrimaryData().equals(tag.asSymbol())) {
                IRubyObject iRubyObject = (IRubyObject)je.getSecondaryData();
                return iRubyObject;
            }
            throw je;
        }
        finally {
            context.popCatch();
        }
    }

    public static IRubyObject rbThrow(IRubyObject recv, IRubyObject[] args) {
        IRuby runtime = recv.getRuntime();
        String tag = args[0].asSymbol();
        String[] catches = runtime.getCurrentContext().getActiveCatches();
        String message = "uncaught throw '" + tag + '\'';
        for (int i = catches.length - 1; i >= 0; --i) {
            if (!tag.equals(catches[i])) continue;
            JumpException je = new JumpException(JumpException.JumpType.ThrowJump);
            je.setPrimaryData(tag);
            je.setSecondaryData(args.length > 1 ? args[1] : runtime.getNil());
            throw je;
        }
        throw runtime.newNameError(message, tag);
    }

    public static IRubyObject trap(IRubyObject recv, IRubyObject[] args) {
        return recv.getRuntime().getNil();
    }

    public static IRubyObject warn(IRubyObject recv, IRubyObject message) {
        IRubyObject out = recv.getRuntime().getObject().getConstant("STDERR");
        RubyIO io = (RubyIO)out.convertToType("IO", "to_io", true);
        io.puts(new IRubyObject[]{message});
        return recv.getRuntime().getNil();
    }

    public static IRubyObject set_trace_func(IRubyObject recv, IRubyObject trace_func) {
        if (trace_func.isNil()) {
            recv.getRuntime().setTraceFunction(null);
        } else {
            if (!(trace_func instanceof RubyProc)) {
                throw recv.getRuntime().newTypeError("trace_func needs to be Proc.");
            }
            recv.getRuntime().setTraceFunction((RubyProc)trace_func);
        }
        return trace_func;
    }

    public static IRubyObject singleton_method_added(IRubyObject recv, IRubyObject symbolId) {
        return recv.getRuntime().getNil();
    }

    public static RubyProc proc(IRubyObject recv) {
        return RubyProc.newProc(recv.getRuntime(), true);
    }

    public static IRubyObject loop(IRubyObject recv) {
        ThreadContext context = recv.getRuntime().getCurrentContext();
        while (true) {
            context.yield(recv.getRuntime().getNil());
            Thread.yield();
        }
    }

    public static IRubyObject backquote(IRubyObject recv, IRubyObject aString) {
        IRuby runtime = recv.getRuntime();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int resultCode = RubyKernel.runInShell(runtime, new IRubyObject[]{aString}, output);
        recv.getRuntime().getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime, resultCode));
        return recv.getRuntime().newString(output.toString());
    }

    private static String repairDirSeps(String command) {
        String[] tokens;
        String executable = "";
        String remainder = "";
        if ((command = command.trim()).startsWith("'")) {
            tokens = command.split("'", 3);
            executable = "'" + tokens[1] + "'";
            if (tokens.length > 2) {
                remainder = tokens[2];
            }
        } else if (command.startsWith("\"")) {
            tokens = command.split("\"", 3);
            executable = "\"" + tokens[1] + "\"";
            if (tokens.length > 2) {
                remainder = tokens[2];
            }
        } else {
            tokens = command.split(" ", 2);
            executable = tokens[0];
            if (tokens.length > 1) {
                remainder = " " + tokens[1];
            }
        }
        String replacement = File.separator;
        if (File.separatorChar == '\\') {
            replacement = "\\\\";
        }
        return PATH_SEPARATORS.matcher(executable).replaceAll(replacement) + remainder;
    }

    private static List parseCommandLine(IRubyObject[] rawArgs) {
        String command = rawArgs[0].toString();
        UnsynchronizedStack args = new UnsynchronizedStack();
        StringTokenizer st = new StringTokenizer(command, " ");
        String quoteChar = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (quoteChar == null) {
                if (token.startsWith("'") || token.startsWith("\"")) {
                    quoteChar = token.substring(0, 1);
                    token = token.substring(1);
                }
                if (quoteChar != null && token.endsWith(quoteChar)) {
                    token = token.substring(0, token.length() - 1);
                    quoteChar = null;
                }
                args.push(token);
                continue;
            }
            if (token.endsWith(quoteChar)) {
                token = token.substring(0, token.length() - 1);
                quoteChar = null;
            }
            token = args.pop() + " " + token;
            args.push(token);
        }
        for (int i = 1; i < rawArgs.length; ++i) {
            args.push(rawArgs[i].toString());
        }
        return args;
    }

    private static boolean isRubyCommand(String command) {
        String[] spaceDelimitedTokens = (command = command.trim()).split(" ", 2);
        String[] slashDelimitedTokens = spaceDelimitedTokens[0].split("/");
        String finalToken = slashDelimitedTokens[slashDelimitedTokens.length - 1];
        return finalToken.indexOf("ruby") != -1 || finalToken.endsWith(".rb") || finalToken.indexOf("irb") != -1;
    }

    public static int runInShell(IRuby runtime, IRubyObject[] rawArgs) {
        return RubyKernel.runInShell(runtime, rawArgs, runtime.getOutputStream());
    }

    public static int runInShell(IRuby runtime, IRubyObject[] rawArgs, OutputStream output) {
        PrintStream error = runtime.getErrorStream();
        InputStream input = runtime.getInputStream();
        try {
            String shell = System.getProperty("jruby.shell");
            rawArgs[0] = runtime.newString(RubyKernel.repairDirSeps(rawArgs[0].toString()));
            Process aProcess = null;
            InProcessScript ipScript = null;
            File pwd = new File(runtime.evalScript("Dir.pwd").toString());
            if (RubyKernel.isRubyCommand(rawArgs[0].toString())) {
                int startIndex;
                List args = RubyKernel.parseCommandLine(rawArgs);
                String command = (String)args.get(0);
                int n = startIndex = command.endsWith(".rb") ? 0 : 1;
                if (command.trim().endsWith("irb")) {
                    startIndex = 0;
                    args.set(0, System.getProperty("jruby.home") + File.separator + "bin" + File.separator + "jirb");
                }
                String[] argArray = args.subList(startIndex, args.size()).toArray(new String[0]);
                ipScript = new InProcessScript(argArray, runtime.getInputStream(), new PrintStream(output), new PrintStream(runtime.getErrorStream()), pwd);
                ipScript.start();
                ipScript.join();
            } else if (shell != null && rawArgs.length == 1) {
                String shellSwitch = shell.endsWith("sh") ? "-c" : "/c";
                String[] argArray = new String[]{shell, shellSwitch, rawArgs[0].toString()};
                aProcess = Runtime.getRuntime().exec(argArray, new String[0], pwd);
            } else if (rawArgs.length > 1) {
                String[] argArray = new String[rawArgs.length];
                for (int i = 0; i < rawArgs.length; ++i) {
                    argArray[i] = rawArgs[i].toString();
                }
                aProcess = Runtime.getRuntime().exec(argArray, new String[0], pwd);
            } else {
                aProcess = Runtime.getRuntime().exec(rawArgs[0].toString(), new String[0], pwd);
            }
            if (aProcess != null) {
                RubyKernel.handleStreams(aProcess, input, output, error);
                return aProcess.waitFor();
            }
            if (ipScript != null) {
                return ipScript.getResult();
            }
            return 0;
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw runtime.newThreadError("unexpected interrupt");
        }
    }

    private static void handleStreams(Process p, InputStream in, OutputStream out, OutputStream err) throws IOException {
        InputStream pOut = p.getInputStream();
        InputStream pErr = p.getErrorStream();
        OutputStream pIn = p.getOutputStream();
        boolean done = false;
        boolean proc = false;
        while (!done) {
            int b;
            byte[] input;
            if (pOut.available() > 0) {
                input = new byte[pOut.available()];
                b = pOut.read(input);
                if (b == -1) {
                    done = true;
                } else {
                    out.write(input);
                }
                proc = true;
            }
            if (pErr.available() > 0) {
                input = new byte[pErr.available()];
                b = pErr.read(input);
                if (b != -1) {
                    err.write(input);
                }
                proc = true;
            }
            if (in.available() > 0) {
                input = new byte[in.available()];
                b = in.read(input);
                if (b != -1) {
                    pIn.write(input);
                }
                proc = true;
            }
            if (!proc) {
                b = pOut.read();
                if (b == -1) {
                    b = pErr.read();
                    if (b == -1) {
                        done = true;
                    } else {
                        err.write(b);
                    }
                } else {
                    out.write(b);
                }
            }
            proc = false;
        }
        pOut.close();
        pErr.close();
        pIn.close();
    }

    public static RubyInteger srand(IRubyObject recv, IRubyObject[] args) {
        IRuby runtime = recv.getRuntime();
        long oldRandomSeed = runtime.getRandomSeed();
        if (args.length > 0) {
            RubyInteger integerSeed = (RubyInteger)args[0].convertToType("Integer", "to_i", true);
            runtime.setRandomSeed(integerSeed.getLongValue());
        } else {
            runtime.setRandomSeed(System.currentTimeMillis() ^ (long)recv.hashCode() ^ runtime.incrementRandomSeedSequence() ^ (long)runtime.getRandom().nextInt(Math.abs((int)runtime.getRandomSeed())));
        }
        runtime.getRandom().setSeed(runtime.getRandomSeed());
        return runtime.newFixnum(oldRandomSeed);
    }

    public static RubyNumeric rand(IRubyObject recv, IRubyObject[] args) {
        long ceil;
        if (args.length == 0) {
            ceil = 0L;
        } else if (args.length == 1) {
            RubyInteger integerCeil = (RubyInteger)args[0].convertToType("Integer", "to_i", true);
            ceil = integerCeil.getLongValue();
            if ((ceil = Math.abs(ceil)) > Integer.MAX_VALUE) {
                throw recv.getRuntime().newNotImplementedError("Random values larger than Integer.MAX_VALUE not supported");
            }
        } else {
            throw recv.getRuntime().newArgumentError("wrong # of arguments(" + args.length + " for 1)");
        }
        if (ceil == 0L) {
            double result = recv.getRuntime().getRandom().nextDouble();
            return RubyFloat.newFloat(recv.getRuntime(), result);
        }
        return recv.getRuntime().newFixnum(recv.getRuntime().getRandom().nextInt((int)ceil));
    }

    public static RubyBoolean system(IRubyObject recv, IRubyObject[] args) {
        IRuby runtime = recv.getRuntime();
        int resultCode = RubyKernel.runInShell(runtime, args);
        recv.getRuntime().getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime, resultCode));
        return runtime.newBoolean(resultCode == 0);
    }

    public static RubyArray to_a(IRubyObject recv) {
        recv.getRuntime().getWarnings().warn("default 'to_a' will be obsolete");
        return recv.getRuntime().newArray(recv);
    }

    private static class InProcessScript
    extends Thread {
        private String[] argArray;
        private InputStream in;
        private PrintStream out;
        private PrintStream err;
        private int result;
        private File dir;

        public InProcessScript(String[] argArray, InputStream in, PrintStream out, PrintStream err, File dir) {
            this.argArray = argArray;
            this.in = in;
            this.out = out;
            this.err = err;
            this.dir = dir;
        }

        public int getResult() {
            return this.result;
        }

        public void setResult(int result) {
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String oldDir = System.getProperty("user.dir");
            try {
                System.setProperty("user.dir", this.dir.getAbsolutePath());
                this.result = new Main(this.in, this.out, this.err).run(this.argArray);
            }
            finally {
                System.setProperty("user.dir", oldDir);
            }
        }
    }
}

