/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyMatchData
extends RubyObject {
    private String str;
    private int[] begin;
    private int[] end;

    public RubyMatchData(IRuby runtime, String str, int[] begin, int[] end) {
        super(runtime, runtime.getClass("MatchData"));
        this.str = str;
        this.begin = begin;
        this.end = end;
    }

    public static RubyClass createMatchDataClass(IRuby runtime) {
        RubyClass matchDataClass = runtime.defineClass("MatchData", runtime.getObject());
        runtime.defineGlobalConstant("MatchingData", matchDataClass);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyMatchData.class);
        matchDataClass.defineMethod("captures", callbackFactory.getMethod("captures"));
        matchDataClass.defineMethod("clone", callbackFactory.getMethod("rbClone"));
        matchDataClass.defineMethod("inspect", callbackFactory.getMethod("inspect"));
        matchDataClass.defineMethod("size", callbackFactory.getMethod("size"));
        matchDataClass.defineMethod("length", callbackFactory.getMethod("size"));
        matchDataClass.defineMethod("offset", callbackFactory.getMethod("offset", RubyFixnum.class));
        matchDataClass.defineMethod("begin", callbackFactory.getMethod("begin", RubyFixnum.class));
        matchDataClass.defineMethod("end", callbackFactory.getMethod("end", RubyFixnum.class));
        matchDataClass.defineMethod("to_a", callbackFactory.getMethod("to_a"));
        matchDataClass.defineMethod("[]", callbackFactory.getOptMethod("aref"));
        matchDataClass.defineMethod("pre_match", callbackFactory.getMethod("pre_match"));
        matchDataClass.defineMethod("post_match", callbackFactory.getMethod("post_match"));
        matchDataClass.defineMethod("to_s", callbackFactory.getMethod("to_s"));
        matchDataClass.defineMethod("string", callbackFactory.getMethod("string"));
        matchDataClass.getMetaClass().undefineMethod("new");
        return matchDataClass;
    }

    public IRubyObject captures() {
        RubyArray arr = this.getRuntime().newArray(this.begin.length);
        for (long i = 1L; i < (long)this.begin.length; ++i) {
            arr.append(this.group(i));
        }
        return arr;
    }

    public IRubyObject subseq(long beg, long len) {
        if (beg < 0L || beg > this.getSize() || len < 0L) {
            this.getRuntime().getNil();
        }
        if (beg + len > this.getSize()) {
            len = this.getSize() - beg;
        }
        if (len < 0L) {
            len = 0L;
        }
        if (len == 0L) {
            return this.getRuntime().newArray();
        }
        RubyArray arr = this.getRuntime().newArray(0);
        for (long i = beg; i < beg + len; ++i) {
            arr.append(this.group(i));
        }
        return arr;
    }

    public long getSize() {
        return this.begin.length;
    }

    public IRubyObject group(long n) {
        if (n < 0L || n >= this.getSize() || this.begin[(int)n] == -1) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newString(this.str.substring(this.begin[(int)n], this.end[(int)n]));
    }

    public int matchStartPosition() {
        return this.begin[0];
    }

    public int matchEndPosition() {
        return this.end[0];
    }

    private boolean outOfBounds(RubyFixnum index) {
        return this.outOfBounds(index.getLongValue());
    }

    private boolean outOfBounds(long n) {
        return n < 0L || n >= this.getSize();
    }

    public IRubyObject aref(IRubyObject[] args) {
        int argc = this.checkArgumentCount(args, 1, 2);
        if (argc == 2) {
            int beg = RubyNumeric.fix2int(args[0]);
            int len = RubyNumeric.fix2int(args[1]);
            if (beg < 0) {
                beg = (int)((long)beg + this.getSize());
            }
            return this.subseq(beg, len);
        }
        if (args[0] instanceof RubyFixnum) {
            return this.group(RubyNumeric.fix2int(args[0]));
        }
        if (args[0] instanceof RubyBignum) {
            throw this.getRuntime().newIndexError("index too big");
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getSize(), true, false);
            if (begLen == null) {
                return this.getRuntime().getNil();
            }
            return this.subseq(begLen[0], begLen[1]);
        }
        return this.group(RubyNumeric.num2long(args[0]));
    }

    public IRubyObject begin(RubyFixnum index) {
        long lIndex = index.getLongValue();
        long answer = this.begin(lIndex);
        return answer == -1L ? this.getRuntime().getNil() : this.getRuntime().newFixnum(answer);
    }

    public long begin(long index) {
        return this.outOfBounds(index) ? -1L : (long)this.begin[(int)index];
    }

    public IRubyObject end(RubyFixnum index) {
        int lIndex = RubyNumeric.fix2int(index);
        long answer = this.end(lIndex);
        return answer == -1L ? this.getRuntime().getNil() : this.getRuntime().newFixnum(answer);
    }

    public long end(long index) {
        return this.outOfBounds(index) ? -1L : (long)this.end[(int)index];
    }

    public IRubyObject inspect() {
        return this.anyToString();
    }

    public RubyFixnum size() {
        return this.getRuntime().newFixnum(this.getSize());
    }

    public IRubyObject offset(RubyFixnum index) {
        if (this.outOfBounds(index)) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newArray(new IRubyObject[]{this.begin(index), this.end(index)});
    }

    public RubyString pre_match() {
        return this.getRuntime().newString(this.str.substring(0, this.begin[0]));
    }

    public RubyString post_match() {
        return this.getRuntime().newString(this.str.substring(this.end[0]));
    }

    public RubyString string() {
        RubyString frozenString = this.getRuntime().newString(this.str);
        frozenString.freeze();
        return frozenString;
    }

    public RubyArray to_a() {
        RubyArray arr = this.getRuntime().newArray(this.begin.length);
        for (long i = 0L; i < (long)this.begin.length; ++i) {
            arr.append(this.group(i));
        }
        return arr;
    }

    public IRubyObject to_s() {
        return this.getRuntime().newString(this.str.substring(this.begin[0], this.end[0]));
    }

    public IRubyObject rbClone() {
        int len = (int)this.getSize();
        int[] begin_p = new int[len];
        int[] end_p = new int[len];
        System.arraycopy(this.begin, 0, begin_p, 0, len);
        System.arraycopy(this.end, 0, end_p, 0, len);
        return new RubyMatchData(this.getRuntime(), this.str, begin_p, end_p);
    }
}

