/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyNameError
extends RubyException {
    private IRubyObject name;

    public static RubyClass createNameErrorClass(IRuby runtime, RubyClass standardErrorClass) {
        RubyClass nameErrorClass = runtime.defineClass("NameError", standardErrorClass);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyNameError.class);
        nameErrorClass.defineSingletonMethod("new", callbackFactory.getOptSingletonMethod("newRubyNameError"));
        nameErrorClass.defineSingletonMethod("exception", callbackFactory.getOptSingletonMethod("newRubyNameError"));
        nameErrorClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        nameErrorClass.defineMethod("name", callbackFactory.getMethod("name"));
        return nameErrorClass;
    }

    protected RubyNameError(IRuby runtime, RubyClass exceptionClass) {
        this(runtime, exceptionClass, exceptionClass.getName().toString());
    }

    public RubyNameError(IRuby runtime, RubyClass exceptionClass, String message) {
        this(runtime, exceptionClass, message, null);
    }

    public RubyNameError(IRuby runtime, RubyClass exceptionClass, String message, String name) {
        super(runtime, exceptionClass, message);
        this.name = name == null ? runtime.getNil() : runtime.newString(name);
    }

    public static RubyNameError newRubyNameError(IRubyObject recv, IRubyObject[] args) {
        IRuby runtime = recv.getRuntime();
        RubyNameError newError = new RubyNameError(runtime, (RubyClass)recv);
        newError.callInit(args);
        return newError;
    }

    public IRubyObject initialize(IRubyObject[] args) {
        super.initialize(args);
        if (args.length > 1) {
            this.name = args[1];
        }
        return this;
    }

    public IRubyObject name() {
        return this.name;
    }
}

