/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyRange
extends RubyObject {
    private IRubyObject begin;
    private IRubyObject end;
    private boolean isExclusive;

    public RubyRange(IRuby runtime) {
        super(runtime, runtime.getClass("Range"));
    }

    public void init(IRubyObject aBegin, IRubyObject aEnd, RubyBoolean aIsExclusive) {
        if (!(aBegin instanceof RubyFixnum) || !(aEnd instanceof RubyFixnum)) {
            try {
                aBegin.callMethod(this.getRuntime().getCurrentContext(), "<=>", aEnd);
            }
            catch (RaiseException rExcptn) {
                throw this.getRuntime().newArgumentError("bad value for range");
            }
        }
        this.begin = aBegin;
        this.end = aEnd;
        this.isExclusive = aIsExclusive.isTrue();
    }

    public static RubyClass createRangeClass(IRuby runtime) {
        RubyClass result = runtime.defineClass("Range", runtime.getObject());
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyRange.class);
        result.includeModule(runtime.getModule("Enumerable"));
        result.defineMethod("==", callbackFactory.getMethod("equal", IRubyObject.class));
        result.defineMethod("begin", callbackFactory.getMethod("first"));
        result.defineMethod("each", callbackFactory.getMethod("each"));
        result.defineMethod("end", callbackFactory.getMethod("last"));
        result.defineMethod("exclude_end?", callbackFactory.getMethod("exclude_end_p"));
        result.defineMethod("first", callbackFactory.getMethod("first"));
        result.defineMethod("hash", callbackFactory.getMethod("hash"));
        result.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        result.defineMethod("inspect", callbackFactory.getMethod("inspect"));
        result.defineMethod("last", callbackFactory.getMethod("last"));
        result.defineMethod("length", callbackFactory.getMethod("length"));
        result.defineMethod("size", callbackFactory.getMethod("length"));
        result.defineMethod("step", callbackFactory.getOptMethod("step"));
        result.defineMethod("to_s", callbackFactory.getMethod("to_s"));
        result.defineMethod("to_a", callbackFactory.getMethod("to_a"));
        result.defineMethod("include?", callbackFactory.getMethod("include_p", IRubyObject.class));
        result.defineAlias("member?", "include?");
        result.defineAlias("===", "include?");
        result.defineSingletonMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
        return result;
    }

    public long[] getBeginLength(long limit, boolean truncate, boolean isStrict) {
        long beginLong = RubyNumeric.num2long(this.begin);
        long endLong = RubyNumeric.num2long(this.end);
        if (!this.isExclusive) {
            ++endLong;
        }
        if (beginLong < 0L && (beginLong += limit) < 0L) {
            if (isStrict) {
                throw this.getRuntime().newRangeError(this.inspect().toString() + " out of range.");
            }
            return null;
        }
        if (truncate && beginLong > limit) {
            if (isStrict) {
                throw this.getRuntime().newRangeError(this.inspect().toString() + " out of range.");
            }
            return null;
        }
        if (truncate && endLong > limit) {
            endLong = limit;
        }
        if ((endLong < 0L || !this.isExclusive && endLong == 0L) && (endLong += limit) < 0L) {
            if (isStrict) {
                throw this.getRuntime().newRangeError(this.inspect().toString() + " out of range.");
            }
            return null;
        }
        return new long[]{beginLong, Math.max(endLong - beginLong, 0L)};
    }

    public static RubyRange newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyRange range = new RubyRange(recv.getRuntime());
        range.initialize(args);
        return range;
    }

    public static RubyRange newRange(IRuby runtime, IRubyObject begin, IRubyObject end, boolean isExclusive) {
        RubyRange range = new RubyRange(runtime);
        range.init(begin, end, isExclusive ? runtime.getTrue() : runtime.getFalse());
        return range;
    }

    public IRubyObject initialize(IRubyObject[] args) {
        if (args.length == 3) {
            this.init(args[0], args[1], (RubyBoolean)args[2]);
        } else if (args.length == 2) {
            this.init(args[0], args[1], this.getRuntime().getFalse());
        } else {
            throw this.getRuntime().newArgumentError("Wrong arguments. (anObject, anObject, aBoolean = false) expected");
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject first() {
        return this.begin;
    }

    public IRubyObject last() {
        return this.end;
    }

    public RubyFixnum hash() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        long baseHash = this.isExclusive ? 1 : 0;
        long beginHash = ((RubyFixnum)this.begin.callMethod(context, "hash")).getLongValue();
        long endHash = ((RubyFixnum)this.end.callMethod(context, "hash")).getLongValue();
        long hash = baseHash;
        hash ^= beginHash << 1;
        hash ^= endHash << 9;
        return this.getRuntime().newFixnum(hash ^= baseHash << 24);
    }

    private IRubyObject asString(String stringMethod) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        RubyString begStr = (RubyString)this.begin.callMethod(context, stringMethod);
        RubyString endStr = (RubyString)this.end.callMethod(context, stringMethod);
        return begStr.cat(this.isExclusive ? "..." : "..").concat(endStr);
    }

    public IRubyObject inspect() {
        return this.asString("inspect");
    }

    public IRubyObject to_s() {
        return this.asString("to_s");
    }

    public RubyBoolean exclude_end_p() {
        return this.getRuntime().newBoolean(this.isExclusive);
    }

    public RubyFixnum length() {
        long size = 0L;
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (this.begin.callMethod(context, ">", this.end).isTrue()) {
            return this.getRuntime().newFixnum(0L);
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            size = ((RubyNumeric)this.end).getLongValue() - ((RubyNumeric)this.begin).getLongValue();
            if (!this.isExclusive) {
                ++size;
            }
        } else {
            String compareMethod;
            IRubyObject currentObject = this.begin;
            String string = compareMethod = this.isExclusive ? "<" : "<=";
            while (currentObject.callMethod(context, compareMethod, this.end).isTrue()) {
                ++size;
                if (currentObject.equals(this.end)) break;
                currentObject = currentObject.callMethod(context, "succ");
            }
        }
        return this.getRuntime().newFixnum(size);
    }

    public IRubyObject equal(IRubyObject obj) {
        if (!(obj instanceof RubyRange)) {
            return this.getRuntime().getFalse();
        }
        RubyRange otherRange = (RubyRange)obj;
        boolean result = this.begin.equals(otherRange.begin) && this.end.equals(otherRange.end) && this.isExclusive == otherRange.isExclusive;
        return this.getRuntime().newBoolean(result);
    }

    public IRubyObject each() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            long endLong = ((RubyNumeric)this.end).getLongValue();
            long i = ((RubyNumeric)this.begin).getLongValue();
            if (!this.isExclusive) {
                ++endLong;
            }
            while (i < endLong) {
                context.yield(this.getRuntime().newFixnum(i));
                ++i;
            }
        } else if (this.begin instanceof RubyString) {
            ((RubyString)this.begin).upto(this.end, this.isExclusive);
        } else if (this.begin.isKindOf(this.getRuntime().getClass("Numeric"))) {
            if (!this.isExclusive) {
                this.end = this.end.callMethod(context, "+", RubyFixnum.one(this.getRuntime()));
            }
            while (this.begin.callMethod(context, "<", this.end).isTrue()) {
                context.yield(this.begin);
                this.begin = this.begin.callMethod(context, "+", RubyFixnum.one(this.getRuntime()));
            }
        } else {
            IRubyObject v = this.begin;
            if (this.isExclusive) {
                while (v.callMethod(context, "<", this.end).isTrue() && !v.equals(this.end)) {
                    context.yield(v);
                    v = v.callMethod(context, "succ");
                }
            } else {
                while (v.callMethod(context, "<=", this.end).isTrue()) {
                    context.yield(v);
                    if (!v.equals(this.end)) {
                        v = v.callMethod(context, "succ");
                        continue;
                    }
                    break;
                }
            }
        }
        return this;
    }

    public IRubyObject step(IRubyObject[] args) {
        this.checkArgumentCount(args, 0, 1);
        IRubyObject currentObject = this.begin;
        String compareMethod = this.isExclusive ? "<" : "<=";
        int stepSize = (int)(args.length == 0 ? 1L : args[0].convertToInteger().getLongValue());
        if (stepSize <= 0) {
            throw this.getRuntime().newArgumentError("step can't be negative");
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (this.begin instanceof RubyNumeric && this.end instanceof RubyNumeric) {
            RubyFixnum stepNum = this.getRuntime().newFixnum(stepSize);
            while (currentObject.callMethod(context, compareMethod, this.end).isTrue()) {
                context.yield(currentObject);
                currentObject = currentObject.callMethod(context, "+", stepNum);
            }
        } else {
            while (currentObject.callMethod(context, compareMethod, this.end).isTrue()) {
                context.yield(currentObject);
                for (int i = 0; i < stepSize; ++i) {
                    currentObject = currentObject.callMethod(context, "succ");
                }
            }
        }
        return this;
    }

    public RubyArray to_a() {
        IRubyObject currentObject = this.begin;
        String compareMethod = this.isExclusive ? "<" : "<=";
        RubyArray array = this.getRuntime().newArray();
        ThreadContext context = this.getRuntime().getCurrentContext();
        while (currentObject.callMethod(context, compareMethod, this.end).isTrue()) {
            array.append(currentObject);
            if (currentObject.equals(this.end)) break;
            currentObject = currentObject.callMethod(context, "succ");
        }
        return array;
    }

    public RubyBoolean include_p(IRubyObject obj) {
        String compareMethod = this.isExclusive ? ">" : ">=";
        IRubyObject[] arg = new IRubyObject[]{obj};
        RubyBoolean f = obj.getRuntime().getFalse();
        ThreadContext context = this.getRuntime().getCurrentContext();
        return f.getRuntime().newBoolean(f != this.first().callMethod(context, "<=", arg) && f != this.last().callMethod(context, compareMethod, arg));
    }
}

