/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyStringIO
extends RubyObject {
    private long pos = 0L;
    private int lineno = 0;
    private boolean eof = false;
    private StringBuffer internal;
    private boolean closedRead = false;
    private boolean closedWrite = false;

    public static RubyClass createStringIOClass(IRuby runtime) {
        RubyClass stringIOClass = runtime.defineClass("StringIO", runtime.getObject());
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyStringIO.class);
        stringIOClass.defineSingletonMethod("open", callbackFactory.getOptSingletonMethod("open"));
        stringIOClass.defineSingletonMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
        stringIOClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        stringIOClass.defineMethod("<<", callbackFactory.getMethod("append", IRubyObject.class));
        stringIOClass.defineMethod("binmode", callbackFactory.getMethod("binmode"));
        stringIOClass.defineMethod("close", callbackFactory.getMethod("close"));
        stringIOClass.defineMethod("closed?", callbackFactory.getMethod("closed_p"));
        stringIOClass.defineMethod("close_read", callbackFactory.getMethod("close_read"));
        stringIOClass.defineMethod("closed_read?", callbackFactory.getMethod("closed_read_p"));
        stringIOClass.defineMethod("close_write", callbackFactory.getMethod("close_write"));
        stringIOClass.defineMethod("closed_write?", callbackFactory.getMethod("closed_write_p"));
        stringIOClass.defineMethod("each", callbackFactory.getOptMethod("each"));
        stringIOClass.defineMethod("each_byte", callbackFactory.getMethod("each_byte"));
        stringIOClass.defineMethod("each_line", callbackFactory.getMethod("each_line"));
        stringIOClass.defineMethod("eof", callbackFactory.getMethod("eof"));
        stringIOClass.defineMethod("eof?", callbackFactory.getMethod("eof_p"));
        stringIOClass.defineMethod("fcntl", callbackFactory.getMethod("fcntl"));
        stringIOClass.defineMethod("fileno", callbackFactory.getMethod("fileno"));
        stringIOClass.defineMethod("flush", callbackFactory.getMethod("flush"));
        stringIOClass.defineMethod("fsync", callbackFactory.getMethod("fsync"));
        stringIOClass.defineMethod("getc", callbackFactory.getMethod("getc"));
        stringIOClass.defineMethod("gets", callbackFactory.getOptMethod("gets"));
        stringIOClass.defineMethod("isatty", callbackFactory.getMethod("isatty"));
        stringIOClass.defineMethod("tty?", callbackFactory.getMethod("tty_p"));
        stringIOClass.defineMethod("length", callbackFactory.getMethod("length"));
        stringIOClass.defineMethod("lineno", callbackFactory.getMethod("lineno"));
        stringIOClass.defineMethod("lineno=", callbackFactory.getMethod("set_lineno", RubyFixnum.class));
        stringIOClass.defineMethod("path", callbackFactory.getMethod("path"));
        stringIOClass.defineMethod("pid", callbackFactory.getMethod("pid"));
        stringIOClass.defineMethod("pos", callbackFactory.getMethod("pos"));
        stringIOClass.defineMethod("tell", callbackFactory.getMethod("tell"));
        stringIOClass.defineMethod("pos=", callbackFactory.getMethod("set_pos", RubyFixnum.class));
        stringIOClass.defineMethod("print", callbackFactory.getOptMethod("print"));
        stringIOClass.defineMethod("printf", callbackFactory.getOptMethod("printf"));
        stringIOClass.defineMethod("putc", callbackFactory.getMethod("putc", IRubyObject.class));
        stringIOClass.defineMethod("puts", callbackFactory.getOptMethod("puts"));
        stringIOClass.defineMethod("read", callbackFactory.getOptMethod("read"));
        stringIOClass.defineMethod("readchar", callbackFactory.getMethod("readchar"));
        stringIOClass.defineMethod("readline", callbackFactory.getOptMethod("readline"));
        stringIOClass.defineMethod("readlines", callbackFactory.getOptMethod("readlines"));
        stringIOClass.defineMethod("reopen", callbackFactory.getMethod("reopen", IRubyObject.class));
        stringIOClass.defineMethod("rewind", callbackFactory.getMethod("rewind"));
        stringIOClass.defineMethod("seek", callbackFactory.getOptMethod("seek"));
        stringIOClass.defineMethod("size", callbackFactory.getMethod("size"));
        stringIOClass.defineMethod("string", callbackFactory.getMethod("string"));
        stringIOClass.defineMethod("string=", callbackFactory.getMethod("set_string", RubyString.class));
        stringIOClass.defineMethod("sync", callbackFactory.getMethod("sync"));
        stringIOClass.defineMethod("sync=", callbackFactory.getMethod("set_sync", IRubyObject.class));
        stringIOClass.defineMethod("syswrite", callbackFactory.getMethod("syswrite", IRubyObject.class));
        stringIOClass.defineMethod("truncate", callbackFactory.getMethod("truncate", RubyFixnum.class));
        stringIOClass.defineMethod("ungetc", callbackFactory.getMethod("ungetc", RubyFixnum.class));
        stringIOClass.defineMethod("write", callbackFactory.getMethod("write", IRubyObject.class));
        return stringIOClass;
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyStringIO result = new RubyStringIO(recv.getRuntime());
        result.callInit(args);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args) {
        RubyStringIO strio;
        RubyString str = recv.getRuntime().newString("");
        IRubyObject mode = recv.getRuntime().getNil();
        if (args.length > 0) {
            str = args[0].convertToString();
            if (args.length > 1) {
                mode = args[1];
            }
        }
        IRubyObject val = strio = (RubyStringIO)RubyStringIO.newInstance(recv, new IRubyObject[]{str, mode});
        ThreadContext tc = recv.getRuntime().getCurrentContext();
        if (tc.isBlockGiven()) {
            try {
                val = tc.yield(strio);
            }
            finally {
                strio.close();
            }
        }
        return val;
    }

    protected RubyStringIO(IRuby runtime) {
        super(runtime, runtime.getClass("StringIO"));
    }

    public IRubyObject initialize(IRubyObject[] args) {
        this.internal = new StringBuffer();
        if (this.checkArgumentCount(args, 0, 2) > 0) {
            this.internal.append(args[0].convertToString().getValue());
        }
        return this;
    }

    public IRubyObject append(IRubyObject obj) {
        String val = obj.toString();
        this.internal.replace((int)this.pos, (int)(this.pos + (long)val.length()), val);
        this.pos += (long)val.length();
        return this;
    }

    public IRubyObject binmode() {
        return this.getRuntime().getTrue();
    }

    public IRubyObject close() {
        this.closedRead = true;
        this.closedWrite = true;
        return this.getRuntime().getNil();
    }

    public IRubyObject closed_p() {
        return this.closedRead && this.closedWrite ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject close_read() {
        this.closedRead = true;
        return this.getRuntime().getNil();
    }

    public IRubyObject closed_read_p() {
        return this.closedRead ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject close_write() {
        this.closedWrite = true;
        return this.getRuntime().getNil();
    }

    public IRubyObject closed_write_p() {
        return this.closedWrite ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject each(IRubyObject[] args) {
        IRubyObject line = this.gets(args);
        ThreadContext context = this.getRuntime().getCurrentContext();
        while (!line.isNil()) {
            context.yield(line);
            line = this.gets(args);
        }
        return this;
    }

    public IRubyObject each_byte() {
        this.getRuntime().newString(this.internal.substring((int)this.pos)).each_byte();
        return this;
    }

    public IRubyObject each_line() {
        return this.each(new RubyObject[0]);
    }

    public IRubyObject eof() {
        return this.pos >= (long)this.internal.length() || this.eof ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject eof_p() {
        return this.pos >= (long)this.internal.length() || this.eof ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject fcntl() {
        throw this.getRuntime().newNotImplementedError("fcntl not implemented");
    }

    public IRubyObject fileno() {
        return this.getRuntime().getNil();
    }

    public IRubyObject flush() {
        return this;
    }

    public IRubyObject fsync() {
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject getc() {
        return this.getRuntime().newFixnum(this.internal.charAt((int)this.pos++));
    }

    public IRubyObject internalGets(IRubyObject[] args) {
        if (this.pos < (long)this.internal.length() && !this.eof) {
            String sep = ((Object)((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getValue()).toString();
            if (args.length > 0) {
                if (args[0].isNil()) {
                    String buf = this.internal.substring((int)this.pos);
                    this.pos += (long)buf.length();
                    return this.getRuntime().newString(buf);
                }
                sep = args[0].toString();
            }
            int ix = this.internal.indexOf(sep, (int)this.pos);
            String add = sep;
            if (-1 == ix) {
                ix = this.internal.length();
                add = "";
            }
            String line = this.internal.substring((int)this.pos, ix) + add;
            this.pos = ix + add.length();
            ++this.lineno;
            return this.getRuntime().newString(line);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject gets(IRubyObject[] args) {
        IRubyObject result = this.internalGets(args);
        if (!result.isNil()) {
            this.getRuntime().getCurrentContext().setLastline(result);
        }
        return result;
    }

    public IRubyObject isatty() {
        return this.getRuntime().getNil();
    }

    public IRubyObject tty_p() {
        return this.getRuntime().getNil();
    }

    public IRubyObject length() {
        return this.getRuntime().newFixnum(this.internal.length());
    }

    public IRubyObject lineno() {
        return this.getRuntime().newFixnum(this.lineno);
    }

    public IRubyObject set_lineno(RubyFixnum val) {
        this.lineno = (int)val.getLongValue();
        return this.getRuntime().getNil();
    }

    public IRubyObject path() {
        return this.getRuntime().getNil();
    }

    public IRubyObject pid() {
        return this.getRuntime().getNil();
    }

    public IRubyObject pos() {
        return this.getRuntime().newFixnum(this.pos);
    }

    public IRubyObject tell() {
        return this.getRuntime().newFixnum(this.pos);
    }

    public IRubyObject set_pos(RubyFixnum val) {
        this.pos = (int)val.getLongValue();
        return this.getRuntime().getNil();
    }

    public IRubyObject print(IRubyObject[] args) {
        IRubyObject sep;
        if (args.length != 0) {
            int j = args.length;
            for (int i = 0; i < j; ++i) {
                this.append(args[i]);
            }
        }
        if (!(sep = this.getRuntime().getGlobalVariables().get("$\\")).isNil()) {
            this.append(sep);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject printf(IRubyObject[] args) {
        this.append(RubyKernel.sprintf(this, args));
        return this.getRuntime().getNil();
    }

    public IRubyObject putc(IRubyObject obj) {
        this.append(obj);
        return obj;
    }

    public IRubyObject puts(IRubyObject[] obj) {
        if (obj.length == 0) {
            this.append(this.getRuntime().newString("\n"));
        }
        int j = obj.length;
        for (int i = 0; i < j; ++i) {
            this.append(obj[i]);
            this.internal.replace((int)this.pos, (int)(++this.pos), "\n");
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject read(IRubyObject[] args) {
        String buf = null;
        if (this.pos < (long)this.internal.length() && !this.eof) {
            int end;
            buf = args.length > 0 && !args[0].isNil() ? ((end = (int)this.pos + RubyNumeric.fix2int(args[0])) > this.internal.length() ? this.internal.substring((int)this.pos) : this.internal.substring((int)this.pos, end)) : this.internal.substring((int)this.pos);
            this.pos += (long)buf.length();
        }
        RubyString ret = null;
        if (buf == null) {
            if (args.length > 0) {
                return this.getRuntime().getNil();
            }
            return this.getRuntime().newString("");
        }
        if (args.length > 1) {
            ret = args[1].convertToString();
            ret.setValue(buf);
        } else {
            ret = this.getRuntime().newString(buf);
        }
        return ret;
    }

    public IRubyObject readchar() {
        return this.getc();
    }

    public IRubyObject readline(IRubyObject[] args) {
        return this.gets(args);
    }

    public IRubyObject readlines(IRubyObject[] arg) {
        ArrayList<IRubyObject> lns = new ArrayList<IRubyObject>();
        while (this.pos < (long)this.internal.length() && !this.eof) {
            lns.add(this.gets(arg));
        }
        return this.getRuntime().newArray(lns);
    }

    public IRubyObject reopen(IRubyObject str) {
        if (str instanceof RubyStringIO) {
            this.pos = ((RubyStringIO)str).pos;
            this.lineno = ((RubyStringIO)str).lineno;
            this.eof = ((RubyStringIO)str).eof;
            this.closedRead = ((RubyStringIO)str).closedRead;
            this.closedWrite = ((RubyStringIO)str).closedWrite;
            this.internal = new StringBuffer(((RubyStringIO)str).internal.toString());
        } else {
            this.pos = 0L;
            this.lineno = 0;
            this.eof = false;
            this.closedRead = false;
            this.closedWrite = false;
            this.internal = new StringBuffer();
            this.internal.append(str.convertToString().getValue());
        }
        return this;
    }

    public IRubyObject rewind() {
        this.pos = 0L;
        this.lineno = 0;
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject seek(IRubyObject[] args) {
        long amount = ((RubyNumeric)args[0]).getLongValue();
        int whence = 0;
        if (args.length > 1) {
            whence = (int)((RubyNumeric)args[1]).getLongValue();
        }
        this.pos = whence == 1 ? (this.pos += amount) : (whence == 2 ? (long)this.internal.length() + amount : amount);
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.internal.length());
    }

    public IRubyObject string() {
        return this.getRuntime().newString(this.internal.toString());
    }

    public IRubyObject set_string(RubyString arg) {
        return this.reopen(arg);
    }

    public IRubyObject sync() {
        return this.getRuntime().getTrue();
    }

    public IRubyObject set_sync(IRubyObject args) {
        return args;
    }

    public IRubyObject syswrite(IRubyObject args) {
        return this.write(args);
    }

    public IRubyObject truncate(RubyFixnum args) {
        int len = (int)args.getLongValue();
        this.internal.delete(len, this.internal.length());
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject ungetc(RubyFixnum args) {
        char val = (char)args.getLongValue();
        this.internal.insert((int)this.pos, val);
        return this.getRuntime().getNil();
    }

    public IRubyObject write(IRubyObject args) {
        String obj = args.toString();
        this.append(args);
        return this.getRuntime().newFixnum(obj.length());
    }
}

