/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyStringIO;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Adler32Ext;
import org.jruby.util.CRC32Ext;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;
import org.jruby.util.ZlibDeflate;
import org.jruby.util.ZlibInflate;

public class RubyZlib {
    private static final long[] crctab = new long[]{0L, 1996959894L, 3993919788L, 2567524794L, 124634137L, 1886057615L, 3915621685L, 2657392035L, 249268274L, 2044508324L, 3772115230L, 2547177864L, 162941995L, 2125561021L, 3887607047L, 2428444049L, 498536548L, 1789927666L, 4089016648L, 2227061214L, 450548861L, 1843258603L, 4107580753L, 2211677639L, 325883990L, 1684777152L, 4251122042L, 2321926636L, 335633487L, 1661365465L, 4195302755L, 2366115317L, 997073096L, 1281953886L, 3579855332L, 2724688242L, 1006888145L, 1258607687L, 3524101629L, 2768942443L, 901097722L, 1119000684L, 3686517206L, 2898065728L, 853044451L, 1172266101L, 3705015759L, 2882616665L, 651767980L, 1373503546L, 3369554304L, 3218104598L, 565507253L, 1454621731L, 3485111705L, 3099436303L, 671266974L, 1594198024L, 3322730930L, 2970347812L, 795835527L, 1483230225L, 3244367275L, 3060149565L, 1994146192L, 31158534L, 2563907772L, 4023717930L, 1907459465L, 112637215L, 2680153253L, 3904427059L, 2013776290L, 251722036L, 2517215374L, 3775830040L, 2137656763L, 141376813L, 2439277719L, 3865271297L, 1802195444L, 476864866L, 2238001368L, 4066508878L, 1812370925L, 453092731L, 2181625025L, 4111451223L, 1706088902L, 314042704L, 2344532202L, 4240017532L, 1658658271L, 366619977L, 2362670323L, 4224994405L, 1303535960L, 984961486L, 2747007092L, 3569037538L, 1256170817L, 1037604311L, 2765210733L, 3554079995L, 1131014506L, 879679996L, 2909243462L, 3663771856L, 1141124467L, 855842277L, 2852801631L, 3708648649L, 1342533948L, 654459306L, 3188396048L, 3373015174L, 1466479909L, 544179635L, 3110523913L, 3462522015L, 1591671054L, 702138776L, 2966460450L, 3352799412L, 1504918807L, 783551873L, 3082640443L, 3233442989L, 3988292384L, 2596254646L, 62317068L, 1957810842L, 3939845945L, 2647816111L, 81470997L, 1943803523L, 3814918930L, 2489596804L, 225274430L, 2053790376L, 3826175755L, 2466906013L, 167816743L, 2097651377L, 4027552580L, 2265490386L, 503444072L, 1762050814L, 4150417245L, 2154129355L, 426522225L, 1852507879L, 4275313526L, 2312317920L, 282753626L, 1742555852L, 4189708143L, 2394877945L, 397917763L, 1622183637L, 3604390888L, 2714866558L, 953729732L, 1340076626L, 3518719985L, 2797360999L, 1068828381L, 1219638859L, 3624741850L, 2936675148L, 906185462L, 1090812512L, 3747672003L, 2825379669L, 829329135L, 1181335161L, 3412177804L, 3160834842L, 628085408L, 1382605366L, 3423369109L, 3138078467L, 570562233L, 1426400815L, 3317316542L, 2998733608L, 733239954L, 1555261956L, 3268935591L, 3050360625L, 752459403L, 1541320221L, 2607071920L, 3965973030L, 1969922972L, 40735498L, 2617837225L, 3943577151L, 1913087877L, 83908371L, 2512341634L, 3803740692L, 2075208622L, 213261112L, 2463272603L, 3855990285L, 2094854071L, 198958881L, 2262029012L, 4057260610L, 1759359992L, 534414190L, 2176718541L, 4139329115L, 1873836001L, 414664567L, 2282248934L, 4279200368L, 1711684554L, 285281116L, 2405801727L, 4167216745L, 1634467795L, 376229701L, 2685067896L, 3608007406L, 1308918612L, 956543938L, 2808555105L, 3495958263L, 1231636301L, 1047427035L, 2932959818L, 3654703836L, 1088359270L, 936918000L, 2847714899L, 3736837829L, 1202900863L, 817233897L, 3183342108L, 3401237130L, 1404277552L, 615818150L, 3134207493L, 3453421203L, 1423857449L, 601450431L, 3009837614L, 3294710456L, 1567103746L, 711928724L, 3020668471L, 3272380065L, 1510334235L, 755167117L};

    public static RubyModule createZlibModule(IRuby runtime) {
        RubyModule result = runtime.defineModule("Zlib");
        RubyClass gzfile = result.defineClassUnder("GzipFile", runtime.getObject());
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyGzipFile.class);
        gzfile.defineSingletonMethod("wrap", callbackFactory.getSingletonMethod("wrap", RubyGzipFile.class, IRubyObject.class));
        gzfile.defineSingletonMethod("new", callbackFactory.getSingletonMethod("newCreate"));
        gzfile.defineMethod("os_code", callbackFactory.getMethod("os_code"));
        gzfile.defineMethod("closed?", callbackFactory.getMethod("closed_p"));
        gzfile.defineMethod("orig_name", callbackFactory.getMethod("orig_name"));
        gzfile.defineMethod("to_io", callbackFactory.getMethod("to_io"));
        gzfile.defineMethod("finish", callbackFactory.getMethod("finish"));
        gzfile.defineMethod("comment", callbackFactory.getMethod("comment"));
        gzfile.defineMethod("crc", callbackFactory.getMethod("crc"));
        gzfile.defineMethod("mtime", callbackFactory.getMethod("mtime"));
        gzfile.defineMethod("sync", callbackFactory.getMethod("sync"));
        gzfile.defineMethod("close", callbackFactory.getMethod("close"));
        gzfile.defineMethod("level", callbackFactory.getMethod("level"));
        gzfile.defineMethod("sync=", callbackFactory.getMethod("set_sync", IRubyObject.class));
        RubyClass gzreader = result.defineClassUnder("GzipReader", gzfile);
        gzreader.includeModule(runtime.getModule("Enumerable"));
        CallbackFactory callbackFactory2 = runtime.callbackFactory(RubyGzipReader.class);
        gzreader.defineSingletonMethod("open", callbackFactory2.getSingletonMethod("open", RubyString.class));
        gzreader.defineSingletonMethod("new", callbackFactory2.getOptSingletonMethod("newCreate"));
        gzreader.defineMethod("initialize", callbackFactory2.getMethod("initialize", IRubyObject.class));
        gzreader.defineMethod("rewind", callbackFactory2.getMethod("rewind"));
        gzreader.defineMethod("lineno", callbackFactory2.getMethod("lineno"));
        gzreader.defineMethod("readline", callbackFactory2.getMethod("readline"));
        gzreader.defineMethod("read", callbackFactory2.getOptMethod("read"));
        gzreader.defineMethod("lineno=", callbackFactory2.getMethod("set_lineno", RubyNumeric.class));
        gzreader.defineMethod("pos", callbackFactory2.getMethod("pos"));
        gzreader.defineMethod("readchar", callbackFactory2.getMethod("readchar"));
        gzreader.defineMethod("readlines", callbackFactory2.getOptMethod("readlines"));
        gzreader.defineMethod("each_byte", callbackFactory2.getMethod("each_byte"));
        gzreader.defineMethod("getc", callbackFactory2.getMethod("getc"));
        gzreader.defineMethod("eof", callbackFactory2.getMethod("eof"));
        gzreader.defineMethod("ungetc", callbackFactory2.getMethod("ungetc", RubyNumeric.class));
        gzreader.defineMethod("each", callbackFactory2.getOptMethod("each"));
        gzreader.defineMethod("unused", callbackFactory2.getMethod("unused"));
        gzreader.defineMethod("eof?", callbackFactory2.getMethod("eof_p"));
        gzreader.defineMethod("gets", callbackFactory2.getOptMethod("gets"));
        gzreader.defineMethod("tell", callbackFactory2.getMethod("tell"));
        RubyClass zlibError = result.defineClassUnder("Error", runtime.getClass("StandardError"));
        gzreader.defineClassUnder("Error", zlibError);
        RubyClass gzwriter = result.defineClassUnder("GzipWriter", gzfile);
        CallbackFactory callbackFactory3 = runtime.callbackFactory(RubyGzipWriter.class);
        gzwriter.defineSingletonMethod("open", callbackFactory3.getOptSingletonMethod("open"));
        gzwriter.defineSingletonMethod("new", callbackFactory3.getOptSingletonMethod("newCreate"));
        gzwriter.defineMethod("initialize", callbackFactory3.getOptMethod("initialize2"));
        gzwriter.defineMethod("<<", callbackFactory3.getMethod("append", IRubyObject.class));
        gzwriter.defineMethod("printf", callbackFactory3.getOptMethod("printf"));
        gzwriter.defineMethod("pos", callbackFactory3.getMethod("pos"));
        gzwriter.defineMethod("orig_name=", callbackFactory3.getMethod("set_orig_name", RubyString.class));
        gzwriter.defineMethod("putc", callbackFactory3.getMethod("putc", RubyNumeric.class));
        gzwriter.defineMethod("comment=", callbackFactory3.getMethod("set_comment", RubyString.class));
        gzwriter.defineMethod("puts", callbackFactory3.getOptMethod("puts"));
        gzwriter.defineMethod("flush", callbackFactory3.getOptMethod("flush"));
        gzwriter.defineMethod("mtime=", callbackFactory3.getMethod("set_mtime", IRubyObject.class));
        gzwriter.defineMethod("tell", callbackFactory3.getMethod("tell"));
        gzwriter.defineMethod("write", callbackFactory3.getMethod("write", IRubyObject.class));
        result.defineConstant("ZLIB_VERSION", runtime.newString("1.2.1"));
        result.defineConstant("VERSION", runtime.newString("0.6.0"));
        result.defineConstant("BINARY", runtime.newFixnum(0L));
        result.defineConstant("ASCII", runtime.newFixnum(1L));
        result.defineConstant("UNKNOWN", runtime.newFixnum(2L));
        result.defineConstant("DEF_MEM_LEVEL", runtime.newFixnum(8L));
        result.defineConstant("MAX_MEM_LEVEL", runtime.newFixnum(9L));
        result.defineConstant("OS_UNIX", runtime.newFixnum(3L));
        result.defineConstant("OS_UNKNOWN", runtime.newFixnum(255L));
        result.defineConstant("OS_CODE", runtime.newFixnum(11L));
        result.defineConstant("OS_ZSYSTEM", runtime.newFixnum(8L));
        result.defineConstant("OS_VMCMS", runtime.newFixnum(4L));
        result.defineConstant("OS_VMS", runtime.newFixnum(2L));
        result.defineConstant("OS_RISCOS", runtime.newFixnum(13L));
        result.defineConstant("OS_MACOS", runtime.newFixnum(7L));
        result.defineConstant("OS_OS2", runtime.newFixnum(6L));
        result.defineConstant("OS_AMIGA", runtime.newFixnum(1L));
        result.defineConstant("OS_QDOS", runtime.newFixnum(12L));
        result.defineConstant("OS_WIN32", runtime.newFixnum(11L));
        result.defineConstant("OS_ATARI", runtime.newFixnum(5L));
        result.defineConstant("OS_MSDOS", runtime.newFixnum(0L));
        result.defineConstant("OS_CPM", runtime.newFixnum(9L));
        result.defineConstant("OS_TOPS20", runtime.newFixnum(10L));
        result.defineConstant("DEFAULT_STRATEGY", runtime.newFixnum(0L));
        result.defineConstant("FILTERED", runtime.newFixnum(1L));
        result.defineConstant("HUFFMAN_ONLY", runtime.newFixnum(2L));
        result.defineConstant("NO_FLUSH", runtime.newFixnum(0L));
        result.defineConstant("SYNC_FLUSH", runtime.newFixnum(2L));
        result.defineConstant("FULL_FLUSH", runtime.newFixnum(3L));
        result.defineConstant("FINISH", runtime.newFixnum(4L));
        result.defineConstant("NO_COMPRESSION", runtime.newFixnum(0L));
        result.defineConstant("BEST_SPEED", runtime.newFixnum(1L));
        result.defineConstant("DEFAULT_COMPRESSION", runtime.newFixnum(-1L));
        result.defineConstant("BEST_COMPRESSION", runtime.newFixnum(9L));
        result.defineConstant("MAX_WBITS", runtime.newFixnum(15L));
        CallbackFactory cf = runtime.callbackFactory(RubyZlib.class);
        result.defineModuleFunction("zlib_version", cf.getSingletonMethod("zlib_version"));
        result.defineModuleFunction("version", cf.getSingletonMethod("version"));
        result.defineModuleFunction("adler32", cf.getOptSingletonMethod("adler32"));
        result.defineModuleFunction("crc32", cf.getOptSingletonMethod("crc32"));
        result.defineModuleFunction("crc_table", cf.getSingletonMethod("crc_table"));
        result.defineClassUnder("StreamEnd", zlibError);
        result.defineClassUnder("StreamError", zlibError);
        result.defineClassUnder("BufError", zlibError);
        result.defineClassUnder("NeedDict", zlibError);
        result.defineClassUnder("MemError", zlibError);
        result.defineClassUnder("VersionError", zlibError);
        result.defineClassUnder("DataError", zlibError);
        RubyClass gzError = gzfile.defineClassUnder("Error", zlibError);
        gzfile.defineClassUnder("CRCError", gzError);
        gzfile.defineClassUnder("NoFooter", gzError);
        gzfile.defineClassUnder("LengthError", gzError);
        RubyClass zstream = result.defineClassUnder("ZStream", runtime.getObject());
        CallbackFactory zstreamcb = runtime.callbackFactory(ZStream.class);
        zstream.defineMethod("initialize", zstreamcb.getMethod("initialize"));
        zstream.defineMethod("flush_next_out", zstreamcb.getMethod("flush_next_out"));
        zstream.defineMethod("total_out", zstreamcb.getMethod("total_out"));
        zstream.defineMethod("stream_end?", zstreamcb.getMethod("stream_end_p"));
        zstream.defineMethod("data_type", zstreamcb.getMethod("data_type"));
        zstream.defineMethod("closed?", zstreamcb.getMethod("closed_p"));
        zstream.defineMethod("ended?", zstreamcb.getMethod("ended_p"));
        zstream.defineMethod("end", zstreamcb.getMethod("end"));
        zstream.defineMethod("reset", zstreamcb.getMethod("reset"));
        zstream.defineMethod("avail_out", zstreamcb.getMethod("avail_out"));
        zstream.defineMethod("avail_out=", zstreamcb.getMethod("set_avail_out", IRubyObject.class));
        zstream.defineMethod("adler", zstreamcb.getMethod("adler"));
        zstream.defineMethod("finish", zstreamcb.getMethod("finish"));
        zstream.defineMethod("avail_in", zstreamcb.getMethod("avail_in"));
        zstream.defineMethod("flush_next_in", zstreamcb.getMethod("flush_next_in"));
        zstream.defineMethod("total_in", zstreamcb.getMethod("total_in"));
        zstream.defineMethod("finished?", zstreamcb.getMethod("finished_p"));
        zstream.defineMethod("close", zstreamcb.getMethod("close"));
        RubyClass infl = result.defineClassUnder("Inflate", zstream);
        CallbackFactory inflcb = runtime.callbackFactory(Inflate.class);
        infl.defineSingletonMethod("new", inflcb.getOptSingletonMethod("newInstance"));
        infl.defineSingletonMethod("inflate", inflcb.getSingletonMethod("s_inflate", IRubyObject.class));
        infl.defineMethod("initialize", inflcb.getOptMethod("_initialize"));
        infl.defineMethod("<<", inflcb.getMethod("append", IRubyObject.class));
        infl.defineMethod("sync_point?", inflcb.getMethod("sync_point_p"));
        infl.defineMethod("set_dictionary", inflcb.getMethod("set_dictionary", IRubyObject.class));
        infl.defineMethod("inflate", inflcb.getMethod("inflate", IRubyObject.class));
        infl.defineMethod("sync", inflcb.getMethod("sync", IRubyObject.class));
        RubyClass defl = result.defineClassUnder("Deflate", zstream);
        CallbackFactory deflcb = runtime.callbackFactory(Deflate.class);
        defl.defineSingletonMethod("new", deflcb.getOptSingletonMethod("newInstance"));
        defl.defineSingletonMethod("deflate", deflcb.getOptSingletonMethod("s_deflate"));
        defl.defineMethod("initialize", deflcb.getOptMethod("_initialize"));
        defl.defineMethod("<<", deflcb.getMethod("append", IRubyObject.class));
        defl.defineMethod("params", deflcb.getMethod("params", IRubyObject.class, IRubyObject.class));
        defl.defineMethod("set_dictionary", deflcb.getMethod("set_dictionary", IRubyObject.class));
        defl.defineMethod("flush", deflcb.getOptMethod("flush"));
        defl.defineMethod("deflate", deflcb.getOptMethod("deflate"));
        runtime.getModule("Kernel").callMethod(runtime.getCurrentContext(), "require", runtime.newString("stringio"));
        return result;
    }

    public static IRubyObject zlib_version(IRubyObject recv) {
        return ((RubyModule)recv).getConstant("ZLIB_VERSION");
    }

    public static IRubyObject version(IRubyObject recv) {
        return ((RubyModule)recv).getConstant("VERSION");
    }

    public static IRubyObject crc32(IRubyObject recv, IRubyObject[] args) throws Exception {
        args = recv.scanArgs(args, 0, 2);
        int crc = 0;
        String str = null;
        if (!args[0].isNil()) {
            str = args[0].toString();
        }
        if (!args[1].isNil()) {
            crc = RubyNumeric.fix2int(args[1]);
        }
        CRC32Ext ext = new CRC32Ext(crc);
        if (str != null) {
            ext.update(str.getBytes("PLAIN"));
        }
        return recv.getRuntime().newFixnum(ext.getValue());
    }

    public static IRubyObject adler32(IRubyObject recv, IRubyObject[] args) throws Exception {
        args = recv.scanArgs(args, 0, 2);
        int adler = 1;
        String str = null;
        if (!args[0].isNil()) {
            str = args[0].toString();
        }
        if (!args[1].isNil()) {
            adler = RubyNumeric.fix2int(args[1]);
        }
        Adler32Ext ext = new Adler32Ext(adler);
        if (str != null) {
            ext.update(str.getBytes("PLAIN"));
        }
        return recv.getRuntime().newFixnum(ext.getValue());
    }

    public static IRubyObject crc_table(IRubyObject recv) {
        ArrayList<RubyFixnum> ll = new ArrayList<RubyFixnum>(crctab.length);
        for (int i = 0; i < crctab.length; ++i) {
            ll.add(recv.getRuntime().newFixnum(crctab[i]));
        }
        return recv.getRuntime().newArray(ll);
    }

    public static class RubyGzipWriter
    extends RubyGzipFile {
        private GZIPOutputStream io;

        private static RubyGzipWriter newInstance(IRubyObject recv, IRubyObject[] args) {
            RubyGzipWriter result = new RubyGzipWriter(recv.getRuntime(), recv.getRuntime().getModule("Zlib").getClass("GzipWriter"));
            result.callInit(args);
            return result;
        }

        public static RubyGzipWriter newCreate(IRubyObject recv, IRubyObject[] args) {
            RubyGzipWriter result = new RubyGzipWriter(recv.getRuntime(), (RubyClass)recv);
            result.callInit(args);
            return result;
        }

        public static IRubyObject open(IRubyObject recv, IRubyObject[] args) throws IOException {
            IRubyObject level = recv.getRuntime().getNil();
            IRubyObject strategy = recv.getRuntime().getNil();
            ThreadContext context = recv.getRuntime().getCurrentContext();
            if (args.length > 1) {
                level = args[1];
                if (args.length > 2) {
                    strategy = args[2];
                }
            }
            RubyObject proc = context.isBlockGiven() ? recv.getRuntime().newProc() : (RubyObject)recv.getRuntime().getNil();
            RubyGzipWriter io = RubyGzipWriter.newInstance(recv, new IRubyObject[]{recv.getRuntime().getClass("File").callMethod(context, "open", new IRubyObject[]{args[0], recv.getRuntime().newString("wb")}), level, strategy});
            return RubyGzipFile.wrap(recv, io, proc);
        }

        public RubyGzipWriter(IRuby runtime, RubyClass type) {
            super(runtime, type);
        }

        public IRubyObject initialize2(IRubyObject[] args) throws IOException {
            this.realIo = (RubyObject)args[0];
            this.io = new GZIPOutputStream(new IOOutputStream(args[0]));
            return this;
        }

        public IRubyObject close() throws IOException {
            if (!this.closed) {
                this.io.close();
            }
            this.closed = true;
            return this.getRuntime().getNil();
        }

        public IRubyObject append(IRubyObject p1) throws IOException {
            this.write(p1);
            return this;
        }

        public IRubyObject printf(IRubyObject[] args) throws IOException {
            this.write(RubyKernel.sprintf(this, args));
            return this.getRuntime().getNil();
        }

        public IRubyObject print(IRubyObject[] args) throws IOException {
            IRubyObject sep;
            if (args.length != 0) {
                int j = args.length;
                for (int i = 0; i < j; ++i) {
                    this.write(args[i]);
                }
            }
            if (!(sep = this.getRuntime().getGlobalVariables().get("$\\")).isNil()) {
                this.write(sep);
            }
            return this.getRuntime().getNil();
        }

        public IRubyObject pos() {
            return this.getRuntime().getNil();
        }

        public IRubyObject set_orig_name(RubyString ignored) {
            return this.getRuntime().getNil();
        }

        public IRubyObject set_comment(RubyString ignored) {
            return this.getRuntime().getNil();
        }

        public IRubyObject putc(RubyNumeric p1) throws IOException {
            this.io.write(RubyNumeric.fix2int(p1));
            return p1;
        }

        public IRubyObject puts(IRubyObject[] args) throws IOException {
            RubyStringIO sio = (RubyStringIO)RubyStringIO.newInstance(this, new IRubyObject[0]);
            sio.puts(args);
            this.write(sio.string());
            return this.getRuntime().getNil();
        }

        public IRubyObject finish() throws IOException {
            if (!this.finished) {
                this.io.finish();
            }
            this.finished = true;
            return this.realIo;
        }

        public IRubyObject flush(IRubyObject[] args) throws IOException {
            if (args.length == 0 || args[0].isNil() || RubyNumeric.fix2int(args[0]) != 0) {
                this.io.flush();
            }
            return this.getRuntime().getNil();
        }

        public IRubyObject set_mtime(IRubyObject ignored) {
            return this.getRuntime().getNil();
        }

        public IRubyObject tell() {
            return this.getRuntime().getNil();
        }

        public IRubyObject write(IRubyObject p1) throws IOException {
            String str = p1.toString();
            this.io.write(str.getBytes("ISO8859_1"));
            return this.getRuntime().newFixnum(str.length());
        }
    }

    public static class RubyGzipReader
    extends RubyGzipFile {
        private int line;
        private InputStream io;
        private static final int BUFF_SIZE = 4096;

        private static RubyGzipReader newInstance(IRubyObject recv, IRubyObject[] args) {
            RubyGzipReader result = new RubyGzipReader(recv.getRuntime(), recv.getRuntime().getModule("Zlib").getClass("GzipReader"));
            result.callInit(args);
            return result;
        }

        public static RubyGzipReader newCreate(IRubyObject recv, IRubyObject[] args) {
            RubyGzipReader result = new RubyGzipReader(recv.getRuntime(), (RubyClass)recv);
            result.callInit(args);
            return result;
        }

        public static IRubyObject open(IRubyObject recv, RubyString filename) throws IOException {
            RubyObject proc = recv.getRuntime().getCurrentContext().isBlockGiven() ? recv.getRuntime().newProc() : (RubyObject)recv.getRuntime().getNil();
            RubyGzipReader io = RubyGzipReader.newInstance(recv, new IRubyObject[]{recv.getRuntime().getClass("File").callMethod(recv.getRuntime().getCurrentContext(), "open", new IRubyObject[]{filename, recv.getRuntime().newString("rb")})});
            return RubyGzipFile.wrap(recv, io, proc);
        }

        public RubyGzipReader(IRuby runtime, RubyClass type) {
            super(runtime, type);
        }

        public IRubyObject initialize(IRubyObject io) {
            this.realIo = io;
            try {
                this.io = new GZIPInputStream(new IOInputStream(io));
            }
            catch (IOException e) {
                IRuby runtime = io.getRuntime();
                RubyClass errorClass = runtime.getModule("Zlib").getClass("GzipReader").getClass("Error");
                throw new RaiseException(RubyException.newException(runtime, errorClass, e.getMessage()));
            }
            this.line = 1;
            return this;
        }

        public IRubyObject rewind() {
            return this.getRuntime().getNil();
        }

        public IRubyObject lineno() {
            return this.getRuntime().newFixnum(this.line);
        }

        public IRubyObject readline() throws IOException {
            IRubyObject dst = this.gets(new IRubyObject[0]);
            if (dst.isNil()) {
                throw this.getRuntime().newEOFError();
            }
            return dst;
        }

        public IRubyObject internalGets(IRubyObject[] args) throws IOException {
            String sep = ((Object)((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getValue()).toString();
            if (args.length > 0) {
                sep = args[0].toString();
            }
            return this.internalSepGets(sep);
        }

        private IRubyObject internalSepGets(String sep) throws IOException {
            StringBuffer result = new StringBuffer();
            char ce = (char)this.io.read();
            while (ce != '\uffffffff' && sep.indexOf(ce) == -1) {
                result.append(ce);
                ce = (char)this.io.read();
            }
            ++this.line;
            return this.getRuntime().newString(result.append(sep).toString());
        }

        public IRubyObject gets(IRubyObject[] args) throws IOException {
            IRubyObject result = this.internalGets(args);
            if (!result.isNil()) {
                this.getRuntime().getCurrentContext().setLastline(result);
            }
            return result;
        }

        public IRubyObject read(IRubyObject[] args) throws IOException {
            if (args.length == 0 || args[0].isNil()) {
                StringBuffer val = new StringBuffer();
                byte[] buffer = new byte[4096];
                int read = this.io.read(buffer);
                while (read != -1) {
                    val.append(new String(buffer, 0, read));
                    read = this.io.read(buffer);
                }
                return this.getRuntime().newString(val.toString());
            }
            int len = RubyNumeric.fix2int(args[0]);
            if (len < 0) {
                throw this.getRuntime().newArgumentError("negative length " + len + " given");
            }
            if (len > 0) {
                byte[] buffer = new byte[len];
                int toRead = len;
                int offset = 0;
                int read = 0;
                while (toRead > 0 && (read = this.io.read(buffer, offset, toRead)) != -1) {
                    toRead -= read;
                    offset += read;
                }
                return this.getRuntime().newString(new String(buffer, 0, len - toRead, "PLAIN"));
            }
            return this.getRuntime().newString("");
        }

        public IRubyObject set_lineno(RubyNumeric lineArg) {
            this.line = RubyNumeric.fix2int(lineArg);
            return lineArg;
        }

        public IRubyObject pos() {
            return RubyFixnum.zero(this.getRuntime());
        }

        public IRubyObject readchar() throws IOException {
            int value = this.io.read();
            if (value == -1) {
                throw this.getRuntime().newEOFError();
            }
            return this.getRuntime().newFixnum(value);
        }

        public IRubyObject getc() throws IOException {
            int value = this.io.read();
            return value == -1 ? this.getRuntime().getNil() : this.getRuntime().newFixnum(value);
        }

        private boolean isEof() throws IOException {
            return ((GZIPInputStream)this.io).available() != 1;
        }

        public IRubyObject close() throws IOException {
            if (!this.closed) {
                this.io.close();
            }
            this.closed = true;
            return this.getRuntime().getNil();
        }

        public IRubyObject eof() throws IOException {
            return this.isEof() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        public IRubyObject eof_p() throws IOException {
            return this.eof();
        }

        public IRubyObject unused() {
            return this.getRuntime().getNil();
        }

        public IRubyObject tell() {
            return this.getRuntime().getNil();
        }

        public IRubyObject each(IRubyObject[] args) throws IOException {
            String sep = ((Object)((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getValue()).toString();
            if (args.length > 0 && !args[0].isNil()) {
                sep = args[0].toString();
            }
            ThreadContext context = this.getRuntime().getCurrentContext();
            while (!this.isEof()) {
                context.yield(this.internalSepGets(sep));
            }
            return this.getRuntime().getNil();
        }

        public IRubyObject ungetc(RubyNumeric arg) {
            return this.getRuntime().getNil();
        }

        public IRubyObject readlines(IRubyObject[] args) throws IOException {
            ArrayList<IRubyObject> array = new ArrayList<IRubyObject>();
            if (args.length != 0 && args[0].isNil()) {
                array.add(this.read(new IRubyObject[0]));
            } else {
                String seperator = ((Object)((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getValue()).toString();
                if (args.length > 0) {
                    seperator = args[0].toString();
                }
                while (!this.isEof()) {
                    array.add(this.internalSepGets(seperator));
                }
            }
            return this.getRuntime().newArray(array);
        }

        public IRubyObject each_byte() throws IOException {
            int value = this.io.read();
            ThreadContext context = this.getRuntime().getCurrentContext();
            while (value != -1) {
                context.yield(this.getRuntime().newFixnum(value));
                value = this.io.read();
            }
            return this.getRuntime().getNil();
        }
    }

    public static class RubyGzipFile
    extends RubyObject {
        protected boolean closed = false;
        protected boolean finished = false;
        private int os_code = 255;
        private int level = -1;
        private String orig_name;
        private String comment;
        protected IRubyObject realIo;
        private IRubyObject mtime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static IRubyObject wrap(IRubyObject recv, RubyGzipFile io, IRubyObject proc) throws IOException {
            if (!proc.isNil()) {
                try {
                    ((RubyProc)proc).call(new IRubyObject[]{io});
                }
                finally {
                    if (!io.isClosed()) {
                        io.close();
                    }
                }
                return recv.getRuntime().getNil();
            }
            return io;
        }

        public static RubyGzipFile newCreate(IRubyObject recv) {
            RubyGzipFile result = new RubyGzipFile(recv.getRuntime(), (RubyClass)recv);
            result.callInit(new IRubyObject[0]);
            return result;
        }

        public RubyGzipFile(IRuby runtime, RubyClass type) {
            super(runtime, type);
            this.mtime = runtime.getNil();
        }

        public IRubyObject os_code() {
            return this.getRuntime().newFixnum(this.os_code);
        }

        public IRubyObject closed_p() {
            return this.closed ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        protected boolean isClosed() {
            return this.closed;
        }

        public IRubyObject orig_name() {
            return this.orig_name == null ? this.getRuntime().getNil() : this.getRuntime().newString(this.orig_name);
        }

        public Object to_io() {
            return this.realIo;
        }

        public IRubyObject comment() {
            return this.comment == null ? this.getRuntime().getNil() : this.getRuntime().newString(this.comment);
        }

        public IRubyObject crc() {
            return RubyFixnum.zero(this.getRuntime());
        }

        public IRubyObject mtime() {
            return this.mtime;
        }

        public IRubyObject sync() {
            return this.getRuntime().getNil();
        }

        public IRubyObject finish() throws IOException {
            if (!this.finished) {
                // empty if block
            }
            this.finished = true;
            return this.realIo;
        }

        public IRubyObject close() throws IOException {
            return null;
        }

        public IRubyObject level() {
            return this.getRuntime().newFixnum(this.level);
        }

        public IRubyObject set_sync(IRubyObject ignored) {
            return this.getRuntime().getNil();
        }
    }

    public static class Deflate
    extends ZStream {
        private ZlibDeflate defl;

        public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
            Deflate result = new Deflate(recv.getRuntime(), (RubyClass)recv);
            result.callInit(args);
            return result;
        }

        public static IRubyObject s_deflate(IRubyObject recv, IRubyObject[] args) throws Exception {
            args = recv.scanArgs(args, 1, 1);
            int level = -1;
            if (!args[1].isNil()) {
                level = RubyNumeric.fix2int(args[1]);
            }
            return ZlibDeflate.s_deflate(recv, args[0].toString(), level);
        }

        public Deflate(IRuby runtime, RubyClass type) {
            super(runtime, type);
        }

        public IRubyObject _initialize(IRubyObject[] args) throws Exception {
            args = this.scanArgs(args, 0, 4);
            int level = -1;
            int window_bits = 15;
            int memlevel = 8;
            int strategy = 0;
            if (!args[0].isNil()) {
                level = RubyNumeric.fix2int(args[0]);
            }
            if (!args[1].isNil()) {
                window_bits = RubyNumeric.fix2int(args[1]);
            }
            if (!args[2].isNil()) {
                memlevel = RubyNumeric.fix2int(args[2]);
            }
            if (!args[3].isNil()) {
                strategy = RubyNumeric.fix2int(args[3]);
            }
            this.defl = new ZlibDeflate(this, level, window_bits, memlevel, strategy);
            return this;
        }

        public IRubyObject append(IRubyObject arg) throws Exception {
            this.defl.append(arg);
            return this;
        }

        public IRubyObject params(IRubyObject level, IRubyObject strategy) {
            this.defl.params(RubyNumeric.fix2int(level), RubyNumeric.fix2int(strategy));
            return this.getRuntime().getNil();
        }

        public IRubyObject set_dictionary(IRubyObject arg) throws Exception {
            return this.defl.set_dictionary(arg);
        }

        public IRubyObject flush(IRubyObject[] args) throws Exception {
            int flush = 2;
            if (this.checkArgumentCount(args, 0, 1) == 1 && !args[0].isNil()) {
                flush = RubyNumeric.fix2int(args[0]);
            }
            return this.defl.flush(flush);
        }

        public IRubyObject deflate(IRubyObject[] args) throws Exception {
            args = this.scanArgs(args, 1, 1);
            int flush = 0;
            if (!args[1].isNil()) {
                flush = RubyNumeric.fix2int(args[1]);
            }
            return this.defl.deflate(args[0].toString(), flush);
        }

        protected int internalTotalOut() {
            return this.defl.getDeflater().getTotalOut();
        }

        protected boolean internalStreamEndP() {
            return this.defl.getDeflater().finished();
        }

        protected void internalEnd() {
            this.defl.getDeflater().end();
        }

        protected void internalReset() {
            this.defl.getDeflater().reset();
        }

        protected int internalAdler() {
            return this.defl.getDeflater().getAdler();
        }

        protected IRubyObject internalFinish() throws Exception {
            return this.defl.finish();
        }

        protected int internalTotalIn() {
            return this.defl.getDeflater().getTotalIn();
        }

        protected void internalClose() {
            this.defl.close();
        }
    }

    public static class Inflate
    extends ZStream {
        private ZlibInflate infl;

        public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
            Inflate result = new Inflate(recv.getRuntime(), (RubyClass)recv);
            result.callInit(args);
            return result;
        }

        public static IRubyObject s_inflate(IRubyObject recv, IRubyObject string) throws Exception {
            return ZlibInflate.s_inflate(recv, string.toString());
        }

        public Inflate(IRuby runtime, RubyClass type) {
            super(runtime, type);
        }

        public IRubyObject _initialize(IRubyObject[] args) throws Exception {
            this.infl = new ZlibInflate(this);
            return this;
        }

        public IRubyObject append(IRubyObject arg) {
            this.infl.append(arg);
            return this;
        }

        public IRubyObject sync_point_p() {
            return this.infl.sync_point();
        }

        public IRubyObject set_dictionary(IRubyObject arg) throws Exception {
            return this.infl.set_dictionary(arg);
        }

        public IRubyObject inflate(IRubyObject string) throws Exception {
            return this.infl.inflate(string.toString());
        }

        public IRubyObject sync(IRubyObject string) {
            return this.infl.sync(string);
        }

        protected int internalTotalOut() {
            return this.infl.getInflater().getTotalOut();
        }

        protected boolean internalStreamEndP() {
            return this.infl.getInflater().finished();
        }

        protected void internalEnd() {
            this.infl.getInflater().end();
        }

        protected void internalReset() {
            this.infl.getInflater().reset();
        }

        protected int internalAdler() {
            return this.infl.getInflater().getAdler();
        }

        protected IRubyObject internalFinish() throws Exception {
            this.infl.finish();
            return this.getRuntime().getNil();
        }

        public IRubyObject finished_p() {
            return this.infl.getInflater().finished() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        protected int internalTotalIn() {
            return this.infl.getInflater().getTotalIn();
        }

        protected void internalClose() {
            this.infl.close();
        }
    }

    public static abstract class ZStream
    extends RubyObject {
        protected boolean closed = false;
        protected boolean ended = false;
        protected boolean finished = false;

        protected abstract int internalTotalOut();

        protected abstract boolean internalStreamEndP();

        protected abstract void internalEnd();

        protected abstract void internalReset();

        protected abstract int internalAdler();

        protected abstract IRubyObject internalFinish() throws Exception;

        protected abstract int internalTotalIn();

        protected abstract void internalClose();

        public ZStream(IRuby runtime, RubyClass type) {
            super(runtime, type);
        }

        public IRubyObject initialize() {
            return this;
        }

        public IRubyObject flush_next_out() {
            return this.getRuntime().getNil();
        }

        public IRubyObject total_out() {
            return this.getRuntime().newFixnum(this.internalTotalOut());
        }

        public IRubyObject stream_end_p() {
            return this.internalStreamEndP() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        public IRubyObject data_type() {
            return this.getRuntime().getModule("Zlib").getConstant("UNKNOWN");
        }

        public IRubyObject closed_p() {
            return this.closed ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        public IRubyObject ended_p() {
            return this.ended ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        public IRubyObject end() {
            if (!this.ended) {
                this.internalEnd();
                this.ended = true;
            }
            return this.getRuntime().getNil();
        }

        public IRubyObject reset() {
            this.internalReset();
            return this.getRuntime().getNil();
        }

        public IRubyObject avail_out() {
            return RubyFixnum.zero(this.getRuntime());
        }

        public IRubyObject set_avail_out(IRubyObject p1) {
            return p1;
        }

        public IRubyObject adler() {
            return this.getRuntime().newFixnum(this.internalAdler());
        }

        public IRubyObject finish() throws Exception {
            if (!this.finished) {
                this.finished = true;
                return this.internalFinish();
            }
            return this.getRuntime().newString("");
        }

        public IRubyObject avail_in() {
            return RubyFixnum.zero(this.getRuntime());
        }

        public IRubyObject flush_next_in() {
            return this.getRuntime().getNil();
        }

        public IRubyObject total_in() {
            return this.getRuntime().newFixnum(this.internalTotalIn());
        }

        public IRubyObject finished_p() {
            return this.finished ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        public IRubyObject close() {
            if (!this.closed) {
                this.internalClose();
                this.closed = true;
            }
            return this.getRuntime().getNil();
        }
    }
}

