/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.internal.runtime.methods.EvaluateCallable;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ICallable;

public class IterNode
extends Node {
    static final long serialVersionUID = -9181965000180892184L;
    private final Node varNode;
    private final Node bodyNode;
    private Node iterNode;
    private StaticScope scope;
    private transient ICallable callable;

    public IterNode(ISourcePosition position, Node varNode, StaticScope scope, Node bodyNode, Node iterNode) {
        this(position, varNode, scope, bodyNode, iterNode, 50);
    }

    public IterNode(ISourcePosition position, Node varNode, StaticScope scope, Node bodyNode, Node iterNode, int id) {
        super(position, id);
        this.varNode = varNode;
        this.scope = scope;
        this.bodyNode = bodyNode;
        this.iterNode = iterNode;
    }

    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitIterNode(this);
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getIterNode() {
        return this.iterNode;
    }

    public void setIterNode(Node iterNode) {
        this.iterNode = iterNode;
    }

    public Node getVarNode() {
        return this.varNode;
    }

    public List childNodes() {
        return Node.createList(this.varNode, this.bodyNode, this.iterNode);
    }

    public ICallable getCallable() {
        return this.callable == null ? (this.callable = new EvaluateCallable(this.bodyNode, this.varNode)) : this.callable;
    }
}

