/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

public class ListNode
extends Node {
    private static final long serialVersionUID = 1L;
    private List list = null;

    public ListNode(ISourcePosition position, int id, Node firstNode) {
        this(position, id);
        this.add(firstNode);
    }

    public ListNode(ISourcePosition position, int id) {
        super(position, id);
    }

    public ListNode(ISourcePosition position) {
        super(position, 51);
    }

    public ListNode add(Node node) {
        if (node == null) {
            return this;
        }
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.list.add(node);
        this.setPosition(this.getPosition().union(node.getPosition()));
        return this;
    }

    public Iterator iterator() {
        return this.list == null ? EMPTY_LIST.iterator() : this.list.iterator();
    }

    public ListIterator reverseIterator() {
        return this.list == null ? EMPTY_LIST.listIterator() : this.list.listIterator(this.list.size());
    }

    public int size() {
        return this.list == null ? 0 : this.list.size();
    }

    public ListNode addAll(ListNode other) {
        if (other != null) {
            if (this.list == null) {
                this.list = new ArrayList();
            }
            this.list.addAll(other.list);
            if (this.list.size() > 0) {
                this.setPosition(this.getPosition().union(this.getLast().getPosition()));
            }
        }
        return this;
    }

    public ListNode addAll(Node other) {
        return this.add(other);
    }

    public Node getLast() {
        return this.list == null ? null : (Node)this.list.get(this.list.size() - 1);
    }

    public String toString() {
        String string = super.toString();
        if (this.list == null) {
            return string + ": {}";
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.list.size(); ++i) {
            b.append(this.list.get(i));
            if (i + 1 >= this.list.size()) continue;
            b.append(", ");
        }
        return string + ": {" + b.toString() + "}";
    }

    public List childNodes() {
        return this.list == null ? EMPTY_LIST : this.list;
    }

    public Instruction accept(NodeVisitor visitor) {
        throw new RuntimeException("Base class ListNode should never be evaluated");
    }

    public Node get(int idx) {
        return (Node)this.list.get(idx);
    }
}

