/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.visitor;

import org.jruby.ast.BeginNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.RedoNode;
import org.jruby.ast.RetryNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.visitor.AbstractVisitor;
import org.jruby.evaluator.Instruction;

public class ExpressionVisitor
extends AbstractVisitor {
    private boolean expression;

    public boolean isExpression(Node node) {
        this.acceptNode(node);
        return this.expression;
    }

    protected Instruction visitNode(Node iVisited) {
        this.expression = true;
        return null;
    }

    public Instruction visitBeginNode(BeginNode iVisited) {
        this.acceptNode(iVisited.getBodyNode());
        return null;
    }

    public Instruction visitBlockNode(BlockNode iVisited) {
        this.acceptNode(iVisited.getLast());
        return null;
    }

    public Instruction visitBreakNode(BreakNode iVisited) {
        this.acceptNode(iVisited.getValueNode());
        return null;
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        this.expression = false;
        return null;
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        this.expression = false;
        return null;
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        this.expression = false;
        return null;
    }

    public Instruction visitIfNode(IfNode iVisited) {
        this.expression = this.isExpression(iVisited.getThenBody()) && this.isExpression(iVisited.getElseBody());
        return null;
    }

    public Instruction visitModuleNode(ModuleNode iVisited) {
        this.expression = false;
        return null;
    }

    public Instruction visitNewlineNode(NewlineNode iVisited) {
        this.acceptNode(iVisited.getNextNode());
        return null;
    }

    public Instruction visitNextNode(NextNode iVisited) {
        this.expression = false;
        return null;
    }

    public Instruction visitRedoNode(RedoNode iVisited) {
        this.expression = false;
        return null;
    }

    public Instruction visitRetryNode(RetryNode iVisited) {
        this.expression = false;
        return null;
    }

    public Instruction visitReturnNode(ReturnNode iVisited) {
        this.expression = false;
        return null;
    }

    public Instruction visitUntilNode(UntilNode iVisited) {
        this.expression = false;
        return null;
    }

    public Instruction visitWhileNode(WhileNode iVisited) {
        this.expression = false;
        return null;
    }
}

