/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.environment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Map;
import org.jruby.IRuby;
import org.jruby.environment.IOSEnvironmentReader;
import org.jruby.environment.OSEnvironment;
import org.jruby.environment.OSEnvironmentReaderExcepton;

class OSEnvironmentReaderFromFile
implements IOSEnvironmentReader {
    private static final String JRUBY_ENVFILE = "jruby.envfile";
    private final OSEnvironment environmentReader = new OSEnvironment();

    OSEnvironmentReaderFromFile() {
    }

    public boolean isAccessible(IRuby runtime) {
        String jrubyEnvFilename = System.getProperty(JRUBY_ENVFILE);
        if (jrubyEnvFilename == null || jrubyEnvFilename.length() < 1) {
            return false;
        }
        File jrubyEnvFile = new File(jrubyEnvFilename);
        return jrubyEnvFile.exists() && !jrubyEnvFile.isDirectory() && jrubyEnvFile.canRead();
    }

    public Map getVariables(IRuby runtime) {
        String jrubyEnvFilename = System.getProperty(JRUBY_ENVFILE);
        Map envs = null;
        if (jrubyEnvFilename == null || jrubyEnvFilename.length() < 1) {
            this.environmentReader.handleException(new OSEnvironmentReaderExcepton("Property jruby.envfile not defined."));
        } else {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(jrubyEnvFilename));
            }
            catch (FileNotFoundException e) {
                envs = null;
                this.environmentReader.handleException(e);
            }
            envs = this.environmentReader.getVariablesFrom(reader);
        }
        return envs;
    }
}

