/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class Attribute
extends RubyObject {
    private IRubyObject oid;
    private IRubyObject value;

    public static void createAttribute(IRuby runtime, RubyModule mX509) {
        RubyClass cAttribute = mX509.defineClassUnder("Attribute", runtime.getObject());
        mX509.defineClassUnder("AttributeError", runtime.getModule("OpenSSL").getClass("OpenSSLError"));
        CallbackFactory attrcb = runtime.callbackFactory(Attribute.class);
        cAttribute.defineSingletonMethod("new", attrcb.getOptSingletonMethod("newInstance"));
        cAttribute.defineMethod("initialize", attrcb.getOptMethod("_initialize"));
        cAttribute.defineMethod("to_der", attrcb.getMethod("to_der"));
        cAttribute.defineMethod("oid", attrcb.getMethod("oid"));
        cAttribute.defineMethod("oid=", attrcb.getMethod("set_oid", IRubyObject.class));
        cAttribute.defineMethod("value", attrcb.getMethod("value"));
        cAttribute.defineMethod("value=", attrcb.getMethod("set_value", IRubyObject.class));
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        Attribute result = new Attribute(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public Attribute(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    private DERObjectIdentifier getObjectIdentifier(String nameOrOid) {
        Object val1 = ASN1.getOIDLookup(this.getRuntime()).get(nameOrOid.toLowerCase());
        if (null != val1) {
            return (DERObjectIdentifier)val1;
        }
        DERObjectIdentifier val2 = new DERObjectIdentifier(nameOrOid);
        return val2;
    }

    DERObject toASN1() throws Exception {
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        v1.add((DEREncodable)this.getObjectIdentifier(this.oid.toString()));
        if (this.value instanceof ASN1.ASN1Constructive) {
            v1.add((DEREncodable)((ASN1.ASN1Constructive)this.value).toASN1());
        } else {
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            v2.add((DEREncodable)((ASN1.ASN1Data)this.value).toASN1());
            v1.add((DEREncodable)new DERSet((DEREncodableVector)v2));
        }
        return new DERSequence((DEREncodableVector)v1);
    }

    public IRubyObject _initialize(IRubyObject[] str) throws Exception {
        if (this.checkArgumentCount(str, 1, 2) == 1) {
            IRubyObject _oid = OpenSSLImpl.to_der_if_possible(str[0]);
            this.set_oid(_oid);
            return this;
        }
        this.set_oid(str[0]);
        this.set_value(str[1]);
        return this;
    }

    public IRubyObject to_der() {
        System.err.println("WARNING: unimplemented method called: attr#to_der");
        return this.getRuntime().getNil();
    }

    public IRubyObject oid() {
        return this.oid;
    }

    public IRubyObject set_oid(IRubyObject val) {
        this.oid = val;
        return val;
    }

    public IRubyObject value() {
        return this.value;
    }

    public IRubyObject set_value(IRubyObject val) throws Exception {
        IRubyObject tmp = OpenSSLImpl.to_der_if_possible(val);
        this.value = ASN1.decode(this.getRuntime().getModule("OpenSSL").getConstant("ASN1"), tmp);
        return val;
    }
}

