/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.SimpleSecretKey;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class Cipher
extends RubyObject {
    private static final Set BLOCK_MODES = new HashSet();
    private RubyClass ciphErr = (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("Cipher")).getConstant("CipherError");
    private javax.crypto.Cipher ciph;
    private String name;
    private String cryptoBase;
    private String cryptoVersion;
    private String cryptoMode;
    private String padding_type;
    private String realName;
    private int keyLen = -1;
    private int ivLen = -1;
    private boolean encryptMode = true;
    private IRubyObject[] modeParams;
    private boolean ciphInited = false;
    private byte[] key;
    private byte[] iv;
    private String padding;

    public static void createCipher(IRuby runtime, RubyModule ossl) {
        RubyModule mCipher = ossl.defineModuleUnder("Cipher");
        RubyClass cCipher = mCipher.defineClassUnder("Cipher", runtime.getObject());
        mCipher.defineClassUnder("CipherError", ossl.getClass("OpenSSLError"));
        CallbackFactory ciphercb = runtime.callbackFactory(Cipher.class);
        mCipher.defineSingletonMethod("ciphers", ciphercb.getSingletonMethod("ciphers"));
        cCipher.defineSingletonMethod("new", ciphercb.getOptSingletonMethod("newInstance"));
        cCipher.defineMethod("initialize", ciphercb.getMethod("initialize", IRubyObject.class));
        cCipher.defineMethod("initialize_copy", ciphercb.getMethod("initialize_copy", IRubyObject.class));
        cCipher.defineMethod("clone", ciphercb.getMethod("rbClone"));
        cCipher.defineMethod("name", ciphercb.getMethod("name"));
        cCipher.defineMethod("key_len", ciphercb.getMethod("key_len"));
        cCipher.defineMethod("key_len=", ciphercb.getMethod("set_key_len", IRubyObject.class));
        cCipher.defineMethod("iv_len", ciphercb.getMethod("iv_len"));
        cCipher.defineMethod("block_size", ciphercb.getMethod("block_size"));
        cCipher.defineMethod("encrypt", ciphercb.getOptMethod("encrypt"));
        cCipher.defineMethod("decrypt", ciphercb.getOptMethod("decrypt"));
        cCipher.defineMethod("key=", ciphercb.getMethod("set_key", IRubyObject.class));
        cCipher.defineMethod("iv=", ciphercb.getMethod("set_iv", IRubyObject.class));
        cCipher.defineMethod("reset", ciphercb.getMethod("reset"));
        cCipher.defineMethod("pkcs5_keyivgen", ciphercb.getOptMethod("pkcs5_keyivgen"));
        cCipher.defineMethod("update", ciphercb.getMethod("update", IRubyObject.class));
        cCipher.defineMethod("<<", ciphercb.getMethod("update_deprecated", IRubyObject.class));
        cCipher.defineMethod("final", ciphercb.getMethod("_final"));
        cCipher.defineMethod("padding=", ciphercb.getMethod("set_padding", IRubyObject.class));
    }

    private static String[] rubyToJavaCipher(String inName) {
        String[] split = inName.split("-");
        String cryptoBase = split[0];
        String cryptoVersion = null;
        String cryptoMode = null;
        String realName = null;
        String padding_type = "PKCS5Padding";
        if ("bf".equalsIgnoreCase(cryptoBase)) {
            cryptoBase = "Blowfish";
        }
        if (split.length == 3) {
            cryptoVersion = split[1];
            cryptoMode = split[2];
        } else {
            cryptoMode = split.length == 2 ? split[1] : "ECB";
        }
        realName = cryptoBase.equalsIgnoreCase("DES") && "EDE3".equalsIgnoreCase(cryptoVersion) ? "DESede" : cryptoBase;
        if (!BLOCK_MODES.contains(cryptoMode.toUpperCase())) {
            cryptoVersion = cryptoMode;
            cryptoMode = "CBC";
        }
        realName = realName + "/" + cryptoMode + "/" + padding_type;
        return new String[]{cryptoBase, cryptoVersion, cryptoMode, realName, padding_type};
    }

    private static boolean tryCipher(String rubyName) {
        try {
            javax.crypto.Cipher.getInstance(Cipher.rubyToJavaCipher(rubyName)[3], "BC");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static IRubyObject ciphers(IRubyObject recv) {
        int i;
        ArrayList<RubyString> ciphers = new ArrayList<RubyString>();
        String[] other = new String[]{"AES128", "AES192", "AES256", "BLOWFISH", "RC2-40-CBC", "RC2-64-CBC", "RC4", "RC4-40", "CAST", "CAST-CBC"};
        String[] bases = new String[]{"AES-128", "AES-192", "AES-256", "BF", "DES", "DES-EDE", "DES-EDE3", "RC2", "CAST5"};
        String[] suffixes = new String[]{"", "-CBC", "-CFB", "-CFB1", "-CFB8", "-ECB", "-OFB"};
        int j = bases.length;
        for (i = 0; i < j; ++i) {
            int l = suffixes.length;
            for (int k = 0; k < l; ++k) {
                String val = bases[i] + suffixes[k];
                if (!Cipher.tryCipher(val)) continue;
                ciphers.add(recv.getRuntime().newString(val));
                ciphers.add(recv.getRuntime().newString(val.toLowerCase()));
            }
        }
        j = other.length;
        for (i = 0; i < j; ++i) {
            if (!Cipher.tryCipher(other[i])) continue;
            ciphers.add(recv.getRuntime().newString(other[i]));
            ciphers.add(recv.getRuntime().newString(other[i].toLowerCase()));
        }
        return recv.getRuntime().newArray(ciphers);
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        Cipher result = new Cipher(recv.getRuntime(), (RubyClass)recv);
        result.callMethod(recv.getRuntime().getCurrentContext(), "initialize", args);
        return result;
    }

    public Cipher(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    public IRubyObject initialize(IRubyObject str) {
        this.name = str.toString();
        String[] values = Cipher.rubyToJavaCipher(this.name);
        this.cryptoBase = values[0];
        this.cryptoVersion = values[1];
        this.cryptoMode = values[2];
        this.realName = values[3];
        this.padding_type = values[4];
        try {
            this.ciph = javax.crypto.Cipher.getInstance(this.realName, "BC");
        }
        catch (NoSuchAlgorithmException e) {
            throw this.getRuntime().newLoadError("unsupported cipher algorithm (" + this.realName + ")");
        }
        catch (NoSuchProviderException e) {
            throw this.getRuntime().newLoadError("unsupported cipher algorithm (" + this.realName + ")");
        }
        catch (NoSuchPaddingException e) {
            throw this.getRuntime().newLoadError("unsupported cipher padding (" + this.realName + ")");
        }
        if (this.hasLen() && null != this.cryptoVersion) {
            try {
                this.keyLen = Integer.parseInt(this.cryptoVersion);
            }
            catch (NumberFormatException e) {
                this.keyLen = -1;
            }
        }
        if (this.keyLen == -1) {
            this.keyLen = "DES".equalsIgnoreCase(this.cryptoBase) ? ("EDE3".equalsIgnoreCase(this.cryptoVersion) ? 168 : 56) : 128;
        }
        if (this.ivLen == -1) {
            this.ivLen = "AES".equalsIgnoreCase(this.cryptoBase) ? 128 : 64;
        }
        return this;
    }

    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        this.cryptoBase = ((Cipher)obj).cryptoBase;
        this.cryptoVersion = ((Cipher)obj).cryptoVersion;
        this.cryptoMode = ((Cipher)obj).cryptoMode;
        this.padding_type = ((Cipher)obj).padding_type;
        this.realName = ((Cipher)obj).realName;
        this.name = ((Cipher)obj).name;
        this.keyLen = ((Cipher)obj).keyLen;
        this.ivLen = ((Cipher)obj).ivLen;
        this.encryptMode = ((Cipher)obj).encryptMode;
        this.ciphInited = false;
        if (((Cipher)obj).key != null) {
            this.key = new byte[((Cipher)obj).key.length];
            System.arraycopy(((Cipher)obj).key, 0, this.key, 0, this.key.length);
        } else {
            this.key = null;
        }
        if (((Cipher)obj).iv != null) {
            this.iv = new byte[((Cipher)obj).iv.length];
            System.arraycopy(((Cipher)obj).iv, 0, this.iv, 0, this.iv.length);
        } else {
            this.iv = null;
        }
        this.padding = ((Cipher)obj).padding;
        try {
            this.ciph = javax.crypto.Cipher.getInstance(this.realName, "BC");
        }
        catch (NoSuchAlgorithmException e) {
            throw this.getRuntime().newLoadError("unsupported cipher algorithm (" + this.realName + ")");
        }
        catch (NoSuchProviderException e) {
            throw this.getRuntime().newLoadError("unsupported cipher algorithm (" + this.realName + ")");
        }
        catch (NoSuchPaddingException e) {
            throw this.getRuntime().newLoadError("unsupported cipher padding (" + this.realName + ")");
        }
        return this;
    }

    public IRubyObject name() {
        return this.getRuntime().newString(this.name);
    }

    public IRubyObject key_len() {
        return this.getRuntime().newFixnum(this.keyLen);
    }

    public IRubyObject iv_len() {
        return this.getRuntime().newFixnum(this.ivLen);
    }

    public IRubyObject set_key_len(IRubyObject len) {
        this.keyLen = RubyNumeric.fix2int(len);
        return len;
    }

    public IRubyObject set_key(IRubyObject key) {
        if (key.toString().length() * 8 < this.keyLen) {
            throw new RaiseException(this.getRuntime(), this.ciphErr, "key length to short", true);
        }
        try {
            this.key = key.toString().getBytes("PLAIN");
        }
        catch (Exception e) {
            throw new RaiseException(this.getRuntime(), this.ciphErr, null, true);
        }
        return key;
    }

    public IRubyObject set_iv(IRubyObject iv) {
        if (iv.toString().length() * 8 < this.ivLen) {
            throw new RaiseException(this.getRuntime(), this.ciphErr, "iv length to short", true);
        }
        try {
            this.iv = iv.toString().getBytes("PLAIN");
        }
        catch (Exception e) {
            throw new RaiseException(this.getRuntime(), this.ciphErr, null, true);
        }
        return iv;
    }

    public IRubyObject block_size() {
        return this.getRuntime().newFixnum(this.ciph.getBlockSize());
    }

    public IRubyObject encrypt(IRubyObject[] args) {
        this.checkArgumentCount(args, 0, 2);
        this.encryptMode = true;
        this.modeParams = args;
        this.ciphInited = false;
        return this;
    }

    public IRubyObject decrypt(IRubyObject[] args) {
        this.checkArgumentCount(args, 0, 2);
        this.encryptMode = false;
        this.modeParams = args;
        this.ciphInited = false;
        return this;
    }

    public IRubyObject reset() {
        this.doInitialize();
        return this;
    }

    private boolean hasLen() {
        return Cipher.hasLen(this.cryptoBase);
    }

    private static boolean hasLen(String cryptoBase) {
        return "AES".equalsIgnoreCase(cryptoBase) || "RC2".equalsIgnoreCase(cryptoBase) || "RC4".equalsIgnoreCase(cryptoBase);
    }

    public IRubyObject pkcs5_keyivgen(IRubyObject[] args) {
        this.checkArgumentCount(args, 1, 4);
        String pass = args[0].toString();
        String salt = null;
        byte[] ssalt = null;
        int iter = 2048;
        IRubyObject vdigest = this.getRuntime().getNil();
        MessageDigest digest = null;
        if (args.length > 1) {
            if (!args[1].isNil()) {
                salt = args[1].toString();
            }
            if (args.length > 2) {
                if (!args[2].isNil()) {
                    iter = RubyNumeric.fix2int(args[2]);
                }
                if (args.length > 3) {
                    vdigest = args[3];
                }
            }
        }
        try {
            if (null != salt) {
                if (salt.length() != 8) {
                    throw new RaiseException(this.getRuntime(), this.ciphErr, "salt must be an 8-octet string", true);
                }
                ssalt = salt.getBytes("PLAIN");
            }
            digest = vdigest.isNil() ? MessageDigest.getInstance("MD5", "BC") : MessageDigest.getInstance(((Digest)vdigest).getAlgorithm(), "BC");
            OpenSSLImpl.KeyAndIv result = OpenSSLImpl.EVP_BytesToKey(this.keyLen / 8, this.ivLen / 8, digest, ssalt, pass.getBytes("PLAIN"), iter);
            this.key = result.getKey();
            this.iv = result.getIv();
        }
        catch (Exception e) {
            throw new RaiseException(this.getRuntime(), this.ciphErr, null, true);
        }
        this.doInitialize();
        return this.getRuntime().getNil();
    }

    private void doInitialize() {
        this.ciphInited = true;
        try {
            if (!"ECB".equalsIgnoreCase(this.cryptoMode) && this.iv != null) {
                this.ciph.init(this.encryptMode ? 1 : 2, (Key)new SimpleSecretKey(this.key), new IvParameterSpec(this.iv));
            } else {
                this.ciph.init(this.encryptMode ? 1 : 2, new SimpleSecretKey(this.key));
            }
        }
        catch (Exception e) {
            throw new RaiseException(this.getRuntime(), this.ciphErr, null, true);
        }
    }

    public IRubyObject update(IRubyObject data) {
        String val = data.toString();
        if (val.length() == 0) {
            throw this.getRuntime().newArgumentError("data must not be empty");
        }
        if (!this.ciphInited) {
            this.doInitialize();
        }
        String str = "";
        try {
            byte[] out = this.ciph.update(val.toString().getBytes("PLAIN"));
            if (out != null) {
                str = new String(out, "ISO8859_1");
            }
        }
        catch (Exception e) {
            throw new RaiseException(this.getRuntime(), this.ciphErr, null, true);
        }
        return this.getRuntime().newString(str);
    }

    public IRubyObject update_deprecated(IRubyObject data) {
        this.getRuntime().getWarnings().warn("" + this.getMetaClass().getRealClass().getName() + "#<< is deprecated; use " + this.getMetaClass().getRealClass().getName() + "#update instead");
        return this.update(data);
    }

    public IRubyObject _final() {
        if (!this.ciphInited) {
            this.doInitialize();
        }
        String str = "";
        try {
            byte[] out = this.ciph.doFinal();
            if (out != null) {
                str = new String(out, "ISO8859_1");
            }
        }
        catch (Exception e) {
            throw new RaiseException(this.getRuntime(), this.ciphErr, null, true);
        }
        return this.getRuntime().newString(str);
    }

    public IRubyObject set_padding(IRubyObject padding) {
        this.padding = padding.toString();
        return padding;
    }

    public IRubyObject rbClone() {
        Cipher clone = new Cipher(this.getRuntime(), this.getMetaClass().getRealClass());
        clone.setMetaClass(this.getMetaClass().getSingletonClassClone());
        clone.setTaint(this.isTaint());
        clone.initCopy(this);
        clone.setFrozen(this.isFrozen());
        return clone;
    }

    String getAlgorithm() {
        return this.ciph.getAlgorithm();
    }

    static {
        BLOCK_MODES.add("CBC");
        BLOCK_MODES.add("CFB");
        BLOCK_MODES.add("CFB1");
        BLOCK_MODES.add("CFB8");
        BLOCK_MODES.add("ECB");
        BLOCK_MODES.add("OFB");
    }
}

