/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jce.netscape.NetscapeCertRequest;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.PKey;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jvyaml.util.Base64Coder;

public class NetscapeSPKI
extends RubyObject {
    private IRubyObject public_key;
    private IRubyObject challenge;
    private NetscapeCertRequest cert;

    public static void createNetscapeSPKI(IRuby runtime, RubyModule ossl) {
        RubyModule mNetscape = ossl.defineModuleUnder("Netscape");
        RubyClass cSPKI = mNetscape.defineClassUnder("SPKI", runtime.getObject());
        mNetscape.defineClassUnder("SPKIError", ossl.getClass("OpenSSLError"));
        CallbackFactory spkicb = runtime.callbackFactory(NetscapeSPKI.class);
        cSPKI.defineSingletonMethod("new", spkicb.getOptSingletonMethod("newInstance"));
        cSPKI.defineMethod("initialize", spkicb.getOptMethod("_initialize"));
        cSPKI.defineMethod("to_der", spkicb.getMethod("to_der"));
        cSPKI.defineMethod("to_pem", spkicb.getMethod("to_pem"));
        cSPKI.defineMethod("to_s", spkicb.getMethod("to_pem"));
        cSPKI.defineMethod("to_text", spkicb.getMethod("to_text"));
        cSPKI.defineMethod("public_key", spkicb.getMethod("public_key"));
        cSPKI.defineMethod("public_key=", spkicb.getMethod("set_public_key", IRubyObject.class));
        cSPKI.defineMethod("sign", spkicb.getMethod("sign", IRubyObject.class, IRubyObject.class));
        cSPKI.defineMethod("verify", spkicb.getMethod("verify", IRubyObject.class));
        cSPKI.defineMethod("challenge", spkicb.getMethod("challenge"));
        cSPKI.defineMethod("challenge=", spkicb.getMethod("set_challenge", IRubyObject.class));
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        NetscapeSPKI result = new NetscapeSPKI(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public NetscapeSPKI(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    public IRubyObject _initialize(IRubyObject[] args) throws Exception {
        if (args.length > 0) {
            byte[] b = args[0].toString().getBytes("PLAIN");
            try {
                b = Base64Coder.decode(args[0].toString()).getBytes("PLAIN");
            }
            catch (Exception e) {
                b = args[0].toString().getBytes("PLAIN");
            }
            this.cert = new NetscapeCertRequest(b);
            this.challenge = this.getRuntime().newString(this.cert.getChallenge());
            String algo = this.cert.getPublicKey().getAlgorithm();
            byte[] enc = this.cert.getPublicKey().getEncoded();
            if ("RSA".equalsIgnoreCase(algo)) {
                this.public_key = ((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("PKey")).getClass("RSA").callMethod(this.getRuntime().getCurrentContext(), "new", this.getRuntime().newString(new String(enc, "ISO8859_1")));
            } else if ("DSA".equalsIgnoreCase(algo)) {
                this.public_key = ((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("PKey")).getClass("DSA").callMethod(this.getRuntime().getCurrentContext(), "new", this.getRuntime().newString(new String(enc, "ISO8859_1")));
            } else {
                throw this.getRuntime().newLoadError("not implemented algo for public key: " + algo);
            }
        }
        return this;
    }

    public IRubyObject to_der() throws Exception {
        DERSequence b = (DERSequence)this.cert.toASN1Object();
        DERObjectIdentifier encType = null;
        DERBitString publicKey = new DERBitString(((PKey)this.public_key).to_der().toString().getBytes("PLAIN"));
        DERIA5String challenge = new DERIA5String(this.challenge.toString());
        DERObjectIdentifier sigAlg = null;
        DERBitString sig = null;
        encType = (DERObjectIdentifier)((DERSequence)((DERSequence)((DERSequence)b.getObjectAt(0)).getObjectAt(0)).getObjectAt(0)).getObjectAt(0);
        sigAlg = ((AlgorithmIdentifier)b.getObjectAt(1)).getObjectId();
        sig = (DERBitString)b.getObjectAt(2);
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        ASN1EncodableVector v1_2 = new ASN1EncodableVector();
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        ASN1EncodableVector v3 = new ASN1EncodableVector();
        ASN1EncodableVector v4 = new ASN1EncodableVector();
        v4.add((DEREncodable)encType);
        v4.add((DEREncodable)new DERNull());
        v3.add((DEREncodable)new DERSequence((DEREncodableVector)v4));
        v3.add((DEREncodable)publicKey);
        v2.add((DEREncodable)new DERSequence((DEREncodableVector)v3));
        v2.add((DEREncodable)challenge);
        v1.add((DEREncodable)new DERSequence((DEREncodableVector)v2));
        v1_2.add((DEREncodable)sigAlg);
        v1_2.add((DEREncodable)new DERNull());
        v1.add((DEREncodable)new DERSequence((DEREncodableVector)v1_2));
        v1.add((DEREncodable)sig);
        return this.getRuntime().newString(new String(new DERSequence((DEREncodableVector)v1).getEncoded(), "ISO8859_1"));
    }

    public IRubyObject to_pem() throws Exception {
        return this.getRuntime().newString(Base64Coder.encode(this.to_der().toString()));
    }

    public IRubyObject to_text() {
        System.err.println("WARNING: calling unimplemented method: to_text");
        return this.getRuntime().getNil();
    }

    public IRubyObject public_key() {
        return this.public_key;
    }

    public IRubyObject set_public_key(IRubyObject arg) {
        this.public_key = arg;
        return arg;
    }

    public IRubyObject sign(IRubyObject key, IRubyObject digest) throws Exception {
        String keyAlg = ((PKey)key).getAlgorithm();
        String digAlg = ((Digest)digest).getAlgorithm();
        DERObjectIdentifier alg = (DERObjectIdentifier)ASN1.getOIDLookup(this.getRuntime()).get(keyAlg.toLowerCase() + "-" + digAlg.toLowerCase());
        this.cert = new NetscapeCertRequest(this.challenge.toString(), new AlgorithmIdentifier(alg), ((PKey)this.public_key).getPublicKey());
        this.cert.sign(((PKey)key).getPrivateKey());
        return this;
    }

    public IRubyObject verify(IRubyObject pkey) throws Exception {
        this.cert.setPublicKey(((PKey)pkey).getPublicKey());
        return this.cert.verify(this.challenge.toString()) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject challenge() {
        return this.challenge;
    }

    public IRubyObject set_challenge(IRubyObject arg) {
        this.challenge = arg;
        return arg;
    }
}

