/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.PKeyDSA;
import org.jruby.ext.openssl.PKeyRSA;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class PKey
extends RubyObject {
    public static void createPKey(IRuby runtime, RubyModule ossl) {
        RubyModule mPKey = ossl.defineModuleUnder("PKey");
        RubyClass cPKey = mPKey.defineClassUnder("PKey", runtime.getObject());
        mPKey.defineClassUnder("PKeyError", ossl.getClass("OpenSSLError"));
        CallbackFactory pkeycb = runtime.callbackFactory(PKey.class);
        cPKey.defineSingletonMethod("new", pkeycb.getSingletonMethod("newInstance"));
        cPKey.defineMethod("initialize", pkeycb.getMethod("initialize"));
        cPKey.defineMethod("sign", pkeycb.getMethod("sign", IRubyObject.class, IRubyObject.class));
        cPKey.defineMethod("verify", pkeycb.getMethod("verify", IRubyObject.class, IRubyObject.class, IRubyObject.class));
        PKeyRSA.createPKeyRSA(runtime, mPKey);
        PKeyDSA.createPKeyDSA(runtime, mPKey);
    }

    public static IRubyObject newInstance(IRubyObject recv) {
        throw recv.getRuntime().newNotImplementedError("OpenSSL::PKey::PKey is an abstract class.");
    }

    public PKey(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    public IRubyObject initialize() {
        return this;
    }

    PublicKey getPublicKey() {
        return null;
    }

    PrivateKey getPrivateKey() {
        return null;
    }

    String getAlgorithm() {
        return "NONE";
    }

    public abstract IRubyObject to_der() throws Exception;

    public IRubyObject sign(IRubyObject digest, IRubyObject data) throws Exception {
        if (!this.callMethod(this.getRuntime().getCurrentContext(), "private?").isTrue()) {
            throw this.getRuntime().newArgumentError("Private key is needed.");
        }
        Signature sig = Signature.getInstance(((Digest)digest).getAlgorithm() + "WITH" + this.getAlgorithm(), "BC");
        sig.initSign(this.getPrivateKey());
        byte[] inp = data.toString().getBytes("PLAIN");
        sig.update(inp);
        byte[] sigge = sig.sign();
        return this.getRuntime().newString(new String(sigge, "ISO8859_1"));
    }

    public IRubyObject verify(IRubyObject digest, IRubyObject sig, IRubyObject data) {
        System.err.println("WARNING: unimplemented method PKey#verify called");
        return this.getRuntime().getNil();
    }
}

