/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.x509store.PEM;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class PKeyRSA
extends PKey {
    private RSAPrivateCrtKey privKey;
    private RSAPublicKey pubKey;

    public static void createPKeyRSA(IRuby runtime, RubyModule mPKey) {
        RubyClass cRSA = mPKey.defineClassUnder("RSA", mPKey.getClass("PKey"));
        mPKey.defineClassUnder("RSAError", mPKey.getClass("PKeyError"));
        CallbackFactory rsacb = runtime.callbackFactory(PKeyRSA.class);
        cRSA.defineSingletonMethod("new", rsacb.getOptSingletonMethod("newInstance"));
        cRSA.defineMethod("initialize", rsacb.getOptMethod("initialize"));
        cRSA.defineMethod("public?", rsacb.getMethod("public_p"));
        cRSA.defineMethod("private?", rsacb.getMethod("private_p"));
        cRSA.defineMethod("to_der", rsacb.getMethod("to_der"));
        cRSA.defineMethod("public_key", rsacb.getMethod("public_key"));
        cRSA.defineMethod("export", rsacb.getOptMethod("export"));
        cRSA.defineMethod("to_pem", rsacb.getOptMethod("export"));
        cRSA.defineMethod("to_s", rsacb.getOptMethod("export"));
        cRSA.defineMethod("private_encrypt", rsacb.getOptMethod("private_encrypt"));
        cRSA.defineMethod("private_decrypt", rsacb.getOptMethod("private_decrypt"));
        cRSA.defineMethod("public_encrypt", rsacb.getOptMethod("public_encrypt"));
        cRSA.defineMethod("public_decrypt", rsacb.getOptMethod("public_decrypt"));
        cRSA.setConstant("PKCS1_PADDING", runtime.newFixnum(1L));
        cRSA.setConstant("SSLV23_PADDING", runtime.newFixnum(2L));
        cRSA.setConstant("NO_PADDING", runtime.newFixnum(3L));
        cRSA.setConstant("PKCS1_OAEP_PADDING", runtime.newFixnum(4L));
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        PKeyRSA result = new PKeyRSA(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public PKeyRSA(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    PublicKey getPublicKey() {
        return this.pubKey;
    }

    PrivateKey getPrivateKey() {
        return this.privKey;
    }

    String getAlgorithm() {
        return "RSA";
    }

    public IRubyObject initialize(IRubyObject[] args) {
        IRubyObject pass = null;
        char[] passwd = null;
        if (this.checkArgumentCount(args, 0, 2) == 0) {
            Object rsa = null;
        } else {
            BigInteger pubexp;
            BigInteger mod;
            DERSequence seq;
            IRubyObject arg = args[0];
            if (args.length > 1) {
                pass = args[1];
            }
            if (arg instanceof RubyFixnum) {
                int keyLen = RubyNumeric.fix2int(arg);
                BigInteger pubExp = RSAKeyGenParameterSpec.F4;
                if (null != pass && !pass.isNil()) {
                    pubExp = BigInteger.valueOf(RubyNumeric.num2long(pass));
                }
                try {
                    KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
                    gen.initialize(new RSAKeyGenParameterSpec(keyLen, pubExp));
                    KeyPair pair = gen.generateKeyPair();
                    this.privKey = (RSAPrivateCrtKey)pair.getPrivate();
                    this.pubKey = (RSAPublicKey)pair.getPublic();
                }
                catch (Exception e) {
                    throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("PKey")).getConstant("RSAError"), null, true);
                }
            }
            if (pass != null && !pass.isNil()) {
                passwd = pass.toString().toCharArray();
            }
            String input = arg.toString();
            Serializable val = null;
            KeyFactory fact = null;
            try {
                fact = KeyFactory.getInstance("RSA");
            }
            catch (Exception e) {
                throw this.getRuntime().newLoadError("unsupported key algorithm (RSA)");
            }
            if (null == val) {
                try {
                    val = PEM.read_RSAPrivateKey(new StringReader(input), passwd);
                }
                catch (Exception e) {
                    val = null;
                }
            }
            if (null == val) {
                try {
                    val = PEM.read_RSAPublicKey(new StringReader(input), passwd);
                }
                catch (Exception e) {
                    val = null;
                }
            }
            if (null == val) {
                try {
                    val = PEM.read_RSA_PUBKEY(new StringReader(input), passwd);
                }
                catch (Exception e) {
                    val = null;
                }
            }
            if (null == val) {
                try {
                    seq = (DERSequence)new ASN1InputStream(input.getBytes("PLAIN")).readObject();
                    if (seq.size() == 9) {
                        mod = ((DERInteger)seq.getObjectAt(1)).getValue();
                        pubexp = ((DERInteger)seq.getObjectAt(2)).getValue();
                        BigInteger privexp = ((DERInteger)seq.getObjectAt(3)).getValue();
                        BigInteger primep = ((DERInteger)seq.getObjectAt(4)).getValue();
                        BigInteger primeq = ((DERInteger)seq.getObjectAt(5)).getValue();
                        BigInteger primeep = ((DERInteger)seq.getObjectAt(6)).getValue();
                        BigInteger primeeq = ((DERInteger)seq.getObjectAt(7)).getValue();
                        BigInteger crtcoeff = ((DERInteger)seq.getObjectAt(8)).getValue();
                        val = fact.generatePrivate(new RSAPrivateCrtKeySpec(mod, pubexp, privexp, primep, primeq, primeep, primeeq, crtcoeff));
                    } else {
                        val = null;
                    }
                }
                catch (Exception ex) {
                    val = null;
                }
            }
            if (null == val) {
                try {
                    seq = (DERSequence)new ASN1InputStream(input.getBytes("PLAIN")).readObject();
                    if (seq.size() == 2) {
                        mod = ((DERInteger)seq.getObjectAt(0)).getValue();
                        pubexp = ((DERInteger)seq.getObjectAt(1)).getValue();
                        val = fact.generatePublic(new RSAPublicKeySpec(mod, pubexp));
                    } else {
                        val = null;
                    }
                }
                catch (Exception ex) {
                    val = null;
                }
            }
            if (null == val) {
                try {
                    val = fact.generatePublic(new X509EncodedKeySpec(input.getBytes("PLAIN")));
                }
                catch (Exception e) {
                    val = null;
                }
            }
            if (null == val) {
                try {
                    val = fact.generatePrivate(new PKCS8EncodedKeySpec(input.getBytes("PLAIN")));
                }
                catch (Exception e) {
                    val = null;
                }
            }
            if (null == val) {
                throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("PKey")).getConstant("RSAError"), "Neither PUB key nor PRIV key:", true);
            }
            if (val instanceof KeyPair) {
                this.privKey = (RSAPrivateCrtKey)((KeyPair)val).getPrivate();
                this.pubKey = (RSAPublicKey)((KeyPair)val).getPublic();
            } else if (val instanceof RSAPrivateCrtKey) {
                this.privKey = (RSAPrivateCrtKey)val;
                try {
                    this.pubKey = (RSAPublicKey)fact.generatePublic(new RSAPublicKeySpec(this.privKey.getModulus(), this.privKey.getPublicExponent()));
                }
                catch (Exception e) {
                    throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("PKey")).getConstant("RSAError"), "Something rotten with private key", true);
                }
            } else if (val instanceof RSAPublicKey) {
                this.pubKey = (RSAPublicKey)val;
                this.privKey = null;
            } else {
                throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("PKey")).getConstant("RSAError"), "Neither PUB key nor PRIV key:", true);
            }
        }
        return this;
    }

    public IRubyObject public_p() {
        return this.pubKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject private_p() {
        return this.privKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject to_der() throws Exception {
        if (this.pubKey != null && this.privKey == null) {
            ASN1EncodableVector v1 = new ASN1EncodableVector();
            v1.add((DEREncodable)new DERInteger(this.pubKey.getModulus()));
            v1.add((DEREncodable)new DERInteger(this.pubKey.getPublicExponent()));
            return this.getRuntime().newString(new String(new DERSequence((DEREncodableVector)v1).getEncoded(), "ISO8859_1"));
        }
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        v1.add((DEREncodable)new DERInteger(0));
        v1.add((DEREncodable)new DERInteger(this.privKey.getModulus()));
        v1.add((DEREncodable)new DERInteger(this.privKey.getPublicExponent()));
        v1.add((DEREncodable)new DERInteger(this.privKey.getPrivateExponent()));
        v1.add((DEREncodable)new DERInteger(this.privKey.getPrimeP()));
        v1.add((DEREncodable)new DERInteger(this.privKey.getPrimeQ()));
        v1.add((DEREncodable)new DERInteger(this.privKey.getPrimeExponentP()));
        v1.add((DEREncodable)new DERInteger(this.privKey.getPrimeExponentQ()));
        v1.add((DEREncodable)new DERInteger(this.privKey.getCrtCoefficient()));
        return this.getRuntime().newString(new String(new DERSequence((DEREncodableVector)v1).getEncoded(), "ISO8859_1"));
    }

    public IRubyObject public_key() {
        PKeyRSA val = new PKeyRSA(this.getRuntime(), this.getMetaClass().getRealClass());
        val.privKey = null;
        val.pubKey = this.pubKey;
        return val;
    }

    public IRubyObject export(IRubyObject[] args) throws Exception {
        StringWriter w = new StringWriter();
        this.checkArgumentCount(args, 0, 2);
        char[] passwd = null;
        String algo = null;
        if (args.length > 0 && !args[0].isNil()) {
            algo = ((Cipher)((Object)args[0])).getAlgorithm();
            if (args.length > 1 && !args[1].isNil()) {
                passwd = args[1].toString().toCharArray();
            }
        }
        if (this.privKey != null) {
            PEM.write_RSAPrivateKey(w, this.privKey, algo, passwd);
        } else {
            PEM.write_RSAPublicKey(w, this.pubKey);
        }
        w.close();
        return this.getRuntime().newString(w.toString());
    }

    private String getPadding(int padding) {
        if (padding < 1 || padding > 4) {
            throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("PKey")).getConstant("RSAError"), null, true);
        }
        String p = "/NONE/PKCS1Padding";
        if (padding == 3) {
            p = "/NONE/NoPadding";
        } else if (padding == 4) {
            p = "/NONE/OAEPWithMD5AndMGF1Padding";
        } else if (padding == 2) {
            p = "/NONE/ISO9796-1Padding";
        }
        return p;
    }

    public IRubyObject private_encrypt(IRubyObject[] args) throws Exception {
        int padding = 1;
        if (this.checkArgumentCount(args, 1, 2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int(args[1]);
        }
        String p = this.getPadding(padding);
        String buffer = args[0].toString();
        if (this.privKey == null) {
            throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("PKey")).getConstant("RSAError"), "private key needed.", true);
        }
        Cipher engine = Cipher.getInstance("RSA" + p);
        engine.init(1, this.privKey);
        byte[] outp = engine.doFinal(buffer.getBytes("PLAIN"));
        return this.getRuntime().newString(new String(outp, "ISO8859_1"));
    }

    public IRubyObject private_decrypt(IRubyObject[] args) throws Exception {
        int padding = 1;
        if (this.checkArgumentCount(args, 1, 2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int(args[1]);
        }
        String p = this.getPadding(padding);
        String buffer = args[0].toString();
        if (this.privKey == null) {
            throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("PKey")).getConstant("RSAError"), "private key needed.", true);
        }
        Cipher engine = Cipher.getInstance("RSA" + p);
        engine.init(2, this.privKey);
        byte[] outp = engine.doFinal(buffer.getBytes("PLAIN"));
        return this.getRuntime().newString(new String(outp, "ISO8859_1"));
    }

    public IRubyObject public_encrypt(IRubyObject[] args) throws Exception {
        int padding = 1;
        if (this.checkArgumentCount(args, 1, 2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int(args[1]);
        }
        String p = this.getPadding(padding);
        String buffer = args[0].toString();
        Cipher engine = Cipher.getInstance("RSA" + p);
        engine.init(1, this.pubKey);
        byte[] outp = engine.doFinal(buffer.getBytes("PLAIN"));
        return this.getRuntime().newString(new String(outp, "ISO8859_1"));
    }

    public IRubyObject public_decrypt(IRubyObject[] args) throws Exception {
        int padding = 1;
        if (this.checkArgumentCount(args, 1, 2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int(args[1]);
        }
        String p = this.getPadding(padding);
        String buffer = args[0].toString();
        Cipher engine = Cipher.getInstance("RSA" + p);
        engine.init(2, this.pubKey);
        byte[] outp = engine.doFinal(buffer.getBytes("PLAIN"));
        return this.getRuntime().newString(new String(outp, "ISO8859_1"));
    }
}

