/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.x509.X509DefaultEntryConverter;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class X509Name
extends RubyObject {
    public static final int COMPAT = 0;
    public static final int RFC2253 = 17892119;
    public static final int ONELINE = 8520479;
    public static final int MULTILINE = 44302342;
    private org.bouncycastle.asn1.x509.X509Name name;
    private List oids = new ArrayList();
    private List values = new ArrayList();
    private List types = new ArrayList();

    public static void createX509Name(IRuby runtime, RubyModule mX509) {
        RubyClass cX509Name = mX509.defineClassUnder("Name", runtime.getObject());
        mX509.defineClassUnder("NameError", runtime.getModule("OpenSSL").getClass("OpenSSLError"));
        CallbackFactory namecb = runtime.callbackFactory(X509Name.class);
        cX509Name.defineSingletonMethod("new", namecb.getOptSingletonMethod("newInstance"));
        cX509Name.defineMethod("initialize", namecb.getOptMethod("initialize"));
        cX509Name.defineMethod("add_entry", namecb.getOptMethod("add_entry"));
        cX509Name.defineMethod("to_s", namecb.getOptMethod("_to_s"));
        cX509Name.defineMethod("to_a", namecb.getMethod("to_a"));
        cX509Name.defineMethod("cmp", namecb.getMethod("cmp", IRubyObject.class));
        cX509Name.defineMethod("<=>", namecb.getMethod("cmp", IRubyObject.class));
        cX509Name.defineMethod("eql?", namecb.getMethod("eql_p", IRubyObject.class));
        cX509Name.defineMethod("hash", namecb.getMethod("hash"));
        cX509Name.defineMethod("to_der", namecb.getMethod("to_der"));
        cX509Name.setConstant("COMPAT", runtime.newFixnum(0L));
        cX509Name.setConstant("RFC2253", runtime.newFixnum(17892119L));
        cX509Name.setConstant("ONELINE", runtime.newFixnum(8520479L));
        cX509Name.setConstant("MULTILINE", runtime.newFixnum(44302342L));
        cX509Name.setConstant("DEFAULT_OBJECT_TYPE", runtime.newFixnum(12L));
        HashMap<RubyString, RubyFixnum> val = new HashMap<RubyString, RubyFixnum>();
        val.put(runtime.newString("C"), runtime.newFixnum(19L));
        val.put(runtime.newString("countryName"), runtime.newFixnum(19L));
        val.put(runtime.newString("serialNumber"), runtime.newFixnum(19L));
        val.put(runtime.newString("dnQualifier"), runtime.newFixnum(19L));
        val.put(runtime.newString("DC"), runtime.newFixnum(22L));
        val.put(runtime.newString("domainComponent"), runtime.newFixnum(22L));
        val.put(runtime.newString("emailAddress"), runtime.newFixnum(22L));
        cX509Name.setConstant("OBJECT_TYPE_TEMPLATE", new RubyHash(runtime, val, runtime.newFixnum(12L)));
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        X509Name result = new X509Name(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public X509Name(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    void addEntry(Object oid, Object value, Object type) {
        this.oids.add(oid);
        this.values.add(value);
        this.types.add(type);
    }

    public IRubyObject initialize(IRubyObject[] args) {
        IRubyObject tmp;
        if (this.checkArgumentCount(args, 0, 2) == 0) {
            return this;
        }
        IRubyObject arg = args[0];
        IRubyObject template = this.getRuntime().getNil();
        if (args.length > 1) {
            template = args[1];
        }
        IRubyObject iRubyObject = tmp = arg instanceof RubyArray ? arg : this.getRuntime().getNil();
        if (!tmp.isNil()) {
            if (template.isNil()) {
                template = ((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getClass("Name").getConstant("OBJECT_TYPE_TEMPLATE");
            }
            Iterator iter = ((RubyArray)tmp).getList().iterator();
            while (iter.hasNext()) {
                RubyArray arr = (RubyArray)iter.next();
                IRubyObject[] entry = new IRubyObject[3];
                List l = arr.getList();
                entry[0] = (IRubyObject)l.get(0);
                entry[1] = (IRubyObject)l.get(1);
                if (l.size() > 2) {
                    entry[2] = (IRubyObject)l.get(2);
                }
                if (entry[2] == null || entry[2].isNil()) {
                    entry[2] = template.callMethod(this.getRuntime().getCurrentContext(), "[]", entry[0]);
                }
                if (entry[2] == null || entry[2].isNil()) {
                    entry[2] = ((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getClass("Name").getConstant("DEFAULT_OBJECT_TYPE");
                }
                this.add_entry(entry);
            }
        } else {
            try {
                ASN1Sequence seq = (ASN1Sequence)new ASN1InputStream(OpenSSLImpl.to_der_if_possible(arg).toString().getBytes("PLAIN")).readObject();
                this.oids = new ArrayList();
                this.values = new ArrayList();
                this.types = new ArrayList();
                Enumeration enm = seq.getObjects();
                while (enm.hasMoreElements()) {
                    ASN1Sequence value = (ASN1Sequence)((ASN1Set)enm.nextElement()).getObjectAt(0);
                    this.oids.add(value.getObjectAt(0));
                    if (value.getObjectAt(1) instanceof DERString) {
                        this.values.add(((DERString)value.getObjectAt(1)).getString());
                    } else {
                        this.values.add(null);
                    }
                    this.types.add(this.getRuntime().newFixnum(ASN1.idForClass(value.getObjectAt(1).getClass())));
                }
            }
            catch (Exception e) {
                System.err.println("exception in init for X509Name: " + e);
            }
        }
        return this;
    }

    private void printASN(DERObject obj) {
        this.printASN(obj, 0);
    }

    private void printASN(DERObject obj, int indent) {
        if (obj instanceof ASN1Sequence) {
            for (int i = 0; i < indent; ++i) {
                System.err.print(" ");
            }
            System.err.println("- Sequence:");
            Enumeration enm = ((ASN1Sequence)obj).getObjects();
            while (enm.hasMoreElements()) {
                this.printASN((DERObject)enm.nextElement(), indent + 1);
            }
        } else if (obj instanceof ASN1Set) {
            for (int i = 0; i < indent; ++i) {
                System.err.print(" ");
            }
            System.err.println("- Set:");
            Enumeration enm = ((ASN1Set)obj).getObjects();
            while (enm.hasMoreElements()) {
                this.printASN((DERObject)enm.nextElement(), indent + 1);
            }
        } else {
            for (int i = 0; i < indent; ++i) {
                System.err.print(" ");
            }
            if (obj instanceof DERString) {
                System.err.println("- " + obj + "=" + ((DERString)obj).getString() + "[" + obj.getClass() + "]");
            } else {
                System.err.println("- " + obj + "[" + obj.getClass() + "]");
            }
        }
    }

    private DERObjectIdentifier getObjectIdentifier(String nameOrOid) {
        Object val1 = ASN1.getOIDLookup(this.getRuntime()).get(nameOrOid.toLowerCase());
        if (null != val1) {
            return (DERObjectIdentifier)val1;
        }
        DERObjectIdentifier val2 = new DERObjectIdentifier(nameOrOid);
        return val2;
    }

    public IRubyObject add_entry(IRubyObject[] args) {
        DERObjectIdentifier oid_v;
        this.checkArgumentCount(args, 2, 3);
        String oid = args[0].toString();
        String value = args[1].toString();
        IRubyObject type = ((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getClass("Name").getConstant("OBJECT_TYPE_TEMPLATE").callMethod(this.getRuntime().getCurrentContext(), "[]", args[0]);
        if (args.length > 2 && !args[2].isNil()) {
            type = args[2];
        }
        try {
            oid_v = this.getObjectIdentifier(oid);
        }
        catch (IllegalArgumentException e) {
            throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("NameError"), "invalid field name", true);
        }
        if (null == oid_v) {
            throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("NameError"), null, true);
        }
        this.oids.add(oid_v);
        this.values.add(value);
        this.types.add(type);
        return this;
    }

    public IRubyObject _to_s(IRubyObject[] args) {
        int flag = -1;
        if (args.length > 0 && !args[0].isNil()) {
            flag = RubyNumeric.fix2int(args[0]);
        }
        StringBuffer sb = new StringBuffer();
        Map lookup = ASN1.getSymLookup(this.getRuntime());
        Iterator oiter = null;
        Iterator viter = null;
        if (flag == 17892119) {
            ArrayList ao = new ArrayList(this.oids);
            ArrayList av = new ArrayList(this.values);
            Collections.reverse(ao);
            Collections.reverse(av);
            oiter = ao.iterator();
            viter = av.iterator();
        } else {
            oiter = this.oids.iterator();
            viter = this.values.iterator();
        }
        String sep = "";
        while (oiter.hasNext()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)oiter.next();
            String val = (String)viter.next();
            String outOid = (String)lookup.get(oid);
            if (null == outOid) {
                outOid = oid.toString();
            }
            if (flag == 17892119) {
                sb.append(sep).append(outOid).append("=").append(val);
                sep = ",";
                continue;
            }
            sb.append("/").append(outOid).append("=").append(val);
        }
        return this.getRuntime().newString(sb.toString());
    }

    public IRubyObject to_a() {
        ArrayList<RubyArray> entries = new ArrayList<RubyArray>();
        Map lookup = ASN1.getSymLookup(this.getRuntime());
        Iterator oiter = this.oids.iterator();
        Iterator viter = this.values.iterator();
        Iterator titer = this.types.iterator();
        while (oiter.hasNext()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)oiter.next();
            String val = (String)viter.next();
            String outOid = (String)lookup.get(oid);
            if (null == outOid) {
                outOid = "UNDEF";
            }
            IRubyObject type = (IRubyObject)titer.next();
            entries.add(this.getRuntime().newArray(new IRubyObject[]{this.getRuntime().newString(outOid), this.getRuntime().newString(val), type}));
        }
        return this.getRuntime().newArray(entries);
    }

    public IRubyObject cmp(IRubyObject other) {
        if (this.eql_p(other).isTrue()) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return RubyFixnum.one(this.getRuntime());
    }

    org.bouncycastle.asn1.x509.X509Name getRealName() {
        return new org.bouncycastle.asn1.x509.X509Name(new Vector(this.oids), new Vector(this.values));
    }

    public IRubyObject eql_p(IRubyObject other) {
        if (!(other instanceof X509Name)) {
            return this.getRuntime().getFalse();
        }
        X509Name o = (X509Name)other;
        org.bouncycastle.asn1.x509.X509Name nm = new org.bouncycastle.asn1.x509.X509Name(new Vector(this.oids), new Vector(this.values));
        org.bouncycastle.asn1.x509.X509Name o_nm = new org.bouncycastle.asn1.x509.X509Name(new Vector(o.oids), new Vector(o.values));
        return nm.equals((Object)o_nm) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(new org.bouncycastle.asn1.x509.X509Name(new Vector(this.oids), new Vector(this.values)).hashCode());
    }

    public IRubyObject to_der() throws Exception {
        DERSequence seq = null;
        if (this.oids.size() > 0) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            ASN1EncodableVector sVec = new ASN1EncodableVector();
            DERObjectIdentifier lstOid = null;
            for (int i = 0; i != this.oids.size(); ++i) {
                ASN1EncodableVector v = new ASN1EncodableVector();
                DERObjectIdentifier oid = (DERObjectIdentifier)this.oids.get(i);
                v.add((DEREncodable)oid);
                String str = (String)this.values.get(i);
                v.add((DEREncodable)this.convert(oid, str, RubyNumeric.fix2int((RubyFixnum)this.types.get(i))));
                if (lstOid == null) {
                    sVec.add((DEREncodable)new DERSequence((DEREncodableVector)v));
                } else {
                    vec.add((DEREncodable)new DERSet((DEREncodableVector)sVec));
                    sVec = new ASN1EncodableVector();
                    sVec.add((DEREncodable)new DERSequence((DEREncodableVector)v));
                }
                lstOid = oid;
            }
            vec.add((DEREncodable)new DERSet((DEREncodableVector)sVec));
            seq = new DERSequence((DEREncodableVector)vec);
        } else {
            seq = new DERSequence();
        }
        return this.getRuntime().newString(new String(seq.getDEREncoded(), "ISO8859_1"));
    }

    private DERObject convert(DERObjectIdentifier oid, String value, int type) throws Exception {
        Constructor ctor;
        Class clzz = ASN1.classForId(type);
        if (clzz != null && null != (ctor = clzz.getConstructor(String.class))) {
            return (DERObject)ctor.newInstance(value);
        }
        return new X509DefaultEntryConverter().getConvertedValue(oid, value);
    }
}

