/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.X509CRL;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509StoreCtx;
import org.jruby.ext.openssl.x509store.Function2;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509_STORE;
import org.jruby.ext.openssl.x509store.X509_STORE_CTX;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class X509Store
extends RubyObject {
    private RubyClass cStoreError;
    private RubyClass cStoreContext;
    private X509_STORE store = new X509_STORE();
    private static final Function2 ossl_verify_cb = new Function2(){

        public int call(Object a1, Object a2) throws Exception {
            X509_STORE_CTX ctx = (X509_STORE_CTX)a2;
            int ok = (Integer)a1;
            IRubyObject proc = (IRubyObject)ctx.get_ex_data(1);
            if (null == proc) {
                proc = (IRubyObject)ctx.ctx.get_ex_data(0);
            }
            if (null == proc) {
                return ok;
            }
            if (!proc.isNil()) {
                System.err.println("WARNING: unimplemented method called: ossl_verify_cb");
                System.err.println("GOJS");
            }
            return ok;
        }
    };

    public static void createX509Store(IRuby runtime, RubyModule mX509) {
        RubyClass cX509Store = mX509.defineClassUnder("Store", runtime.getObject());
        mX509.defineClassUnder("StoreError", runtime.getModule("OpenSSL").getClass("OpenSSLError"));
        cX509Store.attr_accessor(new IRubyObject[]{runtime.newSymbol("verify_callback"), runtime.newSymbol("error"), runtime.newSymbol("error_string"), runtime.newSymbol("chain")});
        CallbackFactory storecb = runtime.callbackFactory(X509Store.class);
        cX509Store.defineSingletonMethod("new", storecb.getOptSingletonMethod("newInstance"));
        cX509Store.defineMethod("initialize", storecb.getOptMethod("_initialize"));
        cX509Store.defineMethod("verify_callback=", storecb.getMethod("set_verify_callback", IRubyObject.class));
        cX509Store.defineMethod("flags=", storecb.getMethod("set_flags", IRubyObject.class));
        cX509Store.defineMethod("purpose=", storecb.getMethod("set_purpose", IRubyObject.class));
        cX509Store.defineMethod("trust=", storecb.getMethod("set_trust", IRubyObject.class));
        cX509Store.defineMethod("time=", storecb.getMethod("set_time", IRubyObject.class));
        cX509Store.defineMethod("add_path", storecb.getMethod("add_path", IRubyObject.class));
        cX509Store.defineMethod("add_file", storecb.getMethod("add_file", IRubyObject.class));
        cX509Store.defineMethod("set_default_paths", storecb.getMethod("set_default_paths"));
        cX509Store.defineMethod("add_cert", storecb.getMethod("add_cert", IRubyObject.class));
        cX509Store.defineMethod("add_crl", storecb.getMethod("add_crl", IRubyObject.class));
        cX509Store.defineMethod("verify", storecb.getOptMethod("verify"));
        X509StoreCtx.createX509StoreCtx(runtime, mX509);
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        X509Store result = new X509Store(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public X509Store(IRuby runtime, RubyClass type) {
        super(runtime, type);
        this.cStoreError = (RubyClass)((RubyModule)runtime.getModule("OpenSSL").getConstant("X509")).getConstant("StoreError");
        this.cStoreContext = (RubyClass)((RubyModule)runtime.getModule("OpenSSL").getConstant("X509")).getConstant("StoreContext");
    }

    X509_STORE getStore() {
        return this.store;
    }

    private void raise(String msg) {
        throw new RaiseException(this.getRuntime(), this.cStoreError, msg, true);
    }

    public IRubyObject _initialize(IRubyObject[] args) throws Exception {
        this.store.set_verify_cb_func(ossl_verify_cb);
        this.set_verify_callback(this.getRuntime().getNil());
        this.setInstanceVariable("@flags", RubyFixnum.zero(this.getRuntime()));
        this.setInstanceVariable("@purpose", RubyFixnum.zero(this.getRuntime()));
        this.setInstanceVariable("@trust", RubyFixnum.zero(this.getRuntime()));
        this.setInstanceVariable("@error", this.getRuntime().getNil());
        this.setInstanceVariable("@error_string", this.getRuntime().getNil());
        this.setInstanceVariable("@chain", this.getRuntime().getNil());
        this.setInstanceVariable("@time", this.getRuntime().getNil());
        return this;
    }

    public IRubyObject set_verify_callback(IRubyObject cb) {
        this.store.set_ex_data(1, cb);
        this.setInstanceVariable("@verify_callback", cb);
        return cb;
    }

    public IRubyObject set_flags(IRubyObject arg) {
        this.store.set_flags(RubyNumeric.fix2long(arg));
        return arg;
    }

    public IRubyObject set_purpose(IRubyObject arg) throws Exception {
        this.store.set_purpose(RubyNumeric.fix2int(arg));
        return arg;
    }

    public IRubyObject set_trust(IRubyObject arg) {
        this.store.set_trust(RubyNumeric.fix2int(arg));
        return arg;
    }

    public IRubyObject set_time(IRubyObject arg) {
        this.setInstanceVariable("@time", arg);
        return arg;
    }

    public IRubyObject add_path(IRubyObject arg) {
        System.err.println("WARNING: unimplemented method called: Store#add_path");
        return this.getRuntime().getNil();
    }

    public IRubyObject add_file(IRubyObject arg) {
        System.err.println("WARNING: unimplemented method called: Store#add_file");
        return this.getRuntime().getNil();
    }

    public IRubyObject set_default_paths() {
        System.err.println("WARNING: unimplemented method called: Store#set_default_paths");
        return this.getRuntime().getNil();
    }

    public IRubyObject add_cert(IRubyObject _cert) {
        X509AuxCertificate cert;
        X509AuxCertificate x509AuxCertificate = cert = _cert instanceof X509Cert ? ((X509Cert)_cert).getAuxCert() : (X509AuxCertificate)null;
        if (this.store.add_cert(cert) != 1) {
            this.raise(null);
        }
        return this;
    }

    public IRubyObject add_crl(IRubyObject arg) {
        java.security.cert.X509CRL crl;
        java.security.cert.X509CRL x509CRL = crl = arg instanceof X509CRL ? ((X509CRL)arg).getCRL() : null;
        if (this.store.add_crl(crl) != 1) {
            this.raise(null);
        }
        return this;
    }

    public IRubyObject verify(IRubyObject[] args) throws Exception {
        IRubyObject chain = this.checkArgumentCount(args, 1, 2) == 2 ? args[1] : this.getRuntime().getNil();
        IRubyObject cert = args[0];
        X509StoreCtx ctx = (X509StoreCtx)this.cStoreContext.callMethod(this.getRuntime().getCurrentContext(), "new", new IRubyObject[]{this, cert, chain});
        IRubyObject proc = this.getRuntime().getCurrentContext().isBlockGiven() ? RubyProc.newProc(this.getRuntime(), false) : this.getInstanceVariable("@verify_callback");
        ctx.setInstanceVariable("@verify_callback", proc);
        IRubyObject result = ctx.callMethod(this.getRuntime().getCurrentContext(), "verify");
        this.setInstanceVariable("@error", ctx.error());
        this.setInstanceVariable("@error_string", ctx.error_string());
        this.setInstanceVariable("@chain", ctx.chain());
        return result;
    }
}

