/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.jruby.ext.openssl.x509store.X509_AUX;

public class X509AuxCertificate
extends X509Certificate {
    private final X509Certificate wrap;
    private final X509_AUX aux;
    private boolean valid = false;
    private int ex_flags = 0;

    public X509AuxCertificate(X509Certificate wrap) {
        this(wrap, null);
    }

    public X509AuxCertificate(X509Certificate wrap, X509_AUX aux) {
        this.wrap = wrap;
        this.aux = aux;
    }

    public X509_AUX getAux() {
        return this.aux;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean v) {
        this.valid = v;
    }

    public int getExFlags() {
        return this.ex_flags;
    }

    public void setExFlags(int ex_flags) {
        this.ex_flags = ex_flags;
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.wrap.checkValidity();
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.wrap.checkValidity(date);
    }

    public int getBasicConstraints() {
        return this.wrap.getBasicConstraints();
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        return this.wrap.getExtendedKeyUsage();
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return this.wrap.getIssuerAlternativeNames();
    }

    public Principal getIssuerDN() {
        return this.wrap.getIssuerDN();
    }

    public boolean[] getIssuerUniqueID() {
        return this.wrap.getIssuerUniqueID();
    }

    public X500Principal getIssuerX500Principal() {
        return this.wrap.getIssuerX500Principal();
    }

    public boolean[] getKeyUsage() {
        return this.wrap.getKeyUsage();
    }

    public Date getNotAfter() {
        return this.wrap.getNotAfter();
    }

    public Date getNotBefore() {
        return this.wrap.getNotBefore();
    }

    public BigInteger getSerialNumber() {
        return this.wrap.getSerialNumber();
    }

    public String getSigAlgName() {
        return this.wrap.getSigAlgName();
    }

    public String getSigAlgOID() {
        return this.wrap.getSigAlgOID();
    }

    public byte[] getSigAlgParams() {
        return this.wrap.getSigAlgParams();
    }

    public byte[] getSignature() {
        return this.wrap.getSignature();
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return this.wrap.getSubjectAlternativeNames();
    }

    public Principal getSubjectDN() {
        return this.wrap.getSubjectDN();
    }

    public boolean[] getSubjectUniqueID() {
        return this.wrap.getSubjectUniqueID();
    }

    public X500Principal getSubjectX500Principal() {
        return this.wrap.getSubjectX500Principal();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return this.wrap.getTBSCertificate();
    }

    public int getVersion() {
        return this.wrap.getVersion();
    }

    public boolean equals(Object other) {
        boolean ret;
        boolean bl = ret = this == other;
        if (!ret && other instanceof X509AuxCertificate) {
            X509AuxCertificate o = (X509AuxCertificate)other;
            ret = this.wrap.equals(o.wrap) && this.aux == null ? o.aux == null : this.aux.equals(o.aux);
        }
        return ret;
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.wrap.getEncoded();
    }

    public PublicKey getPublicKey() {
        return this.wrap.getPublicKey();
    }

    public int hashCode() {
        int ret = this.wrap.hashCode();
        return ret += 3 * (this.aux == null ? 1 : this.aux.hashCode());
    }

    public String toString() {
        return this.wrap.toString();
    }

    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.wrap.verify(key);
    }

    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.wrap.verify(key, sigProvider);
    }

    public Set getCriticalExtensionOIDs() {
        return this.wrap.getCriticalExtensionOIDs();
    }

    public byte[] getExtensionValue(String oid) {
        return this.wrap.getExtensionValue(oid);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.wrap.getNonCriticalExtensionOIDs();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.wrap.hasUnsupportedCriticalExtension();
    }
}

